# -*- coding: utf-8 -*-
#
# Tab Links extension for Epiphany written in Python
#
# Version: 0.1
#
# Copyright (c) 2007 George Notaras <gnotar@gmail.com>
#
# This plugin is UNOFFICIAL and completely UNSUPPORTED.
# It is released without any warranties of any kind.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the:
#
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston,
# MA 02111-1307  USA
#


import gtk

# Menu Items
_ui_str = """
<ui>
	<menubar name="menubar">
		<menu name="ToolsMenu" action="Tools">
			<separator />
			<menu name="Tab Links Menu" action="TabLinksMenu">
				<menuitem name="Default" action="CopyTabLinksDefault" />
				<menuitem name="Mediawiki" action="CopyTabLinksMediaWiki" />
				<menuitem name="MoinMoin" action="CopyTabLinksMoinMoin" />
				<menuitem name="DokuWiki" action="CopyTabLinksDokuwiki" />
				<menuitem name="HTML" action="CopyTabLinksHTML" />
			</menu>
			<separator />
		</menu>
	</menubar>
</ui>
"""

def _get_tab_links_list(window):
	LinkList = []
	for aTab in window.get_notebook():
		LinkList.append( (aTab.get_address(), aTab.get_title() ) )
	return LinkList

def _copy_links_text_to_clipboard(LinksText):
	clipboard = gtk.Clipboard(gtk.gdk.display_get_default(), 'CLIPBOARD')
	clipboard.set_text(LinksText, -1)

def _get_formatted_links_text(window, format = ""):
	LinkList = _get_tab_links_list(window)
	outfmt = {
		# Format: "format_name" : (leading_text, format_template, trailing_text)
		# contains all except the default bare naked link list
		"mediawiki"	: ("", "* [%s %s]", ""),
		"moinmoin"	: ("", " * [%s %s]", ""),
		"dokuwiki"	: ("", "  * [[%s|%s]]", ""),
		"html"		: ("<ul>\n", "<li><a href=\"%s\">%s</a></li>", "\n</ul>"),
		}
	if LinkList:
		if outfmt.has_key(format):
			LinksText = "\n".join( [ outfmt[format][1] % (tablink[0], tablink[1]) for tablink in LinkList if tablink] )
			LinksText = "%s%s%s" % ( outfmt[format][0], LinksText, outfmt[format][2] )
		else:
			# just return the links
			LinksText = "\n".join( [tablink[0] for tablink in LinkList if tablink] )
		_copy_links_text_to_clipboard(LinksText)


def _copy_tab_links_default(action, window):
	_get_formatted_links_text(window, "default")

def _copy_tab_links_mediawiki(action, window):
	_get_formatted_links_text(window, "mediawiki")

def _copy_tab_links_moinmoin(action, window):
	_get_formatted_links_text(window, "moinmoin")

def _copy_tab_links_dokuwiki(action, window):
	_get_formatted_links_text(window, "dokuwiki")

def _copy_tab_links_html(action, window):
	_get_formatted_links_text(window, "html")


# This is to pass to gtk.ActionGroup.add_actions()
_actions = [
		('TabLinksMenu', None, 'Tab Links', None, None, None),
		('CopyTabLinksDefault', None, 'Default', None, None, _copy_tab_links_default),
		('CopyTabLinksMediaWiki', None, 'Mediawiki', None, None, _copy_tab_links_mediawiki),
		('CopyTabLinksMoinMoin', None, 'MoinMoin', None, None, _copy_tab_links_moinmoin),
		('CopyTabLinksDokuwiki', None, 'DokuWiki', None, None, _copy_tab_links_dokuwiki),
		('CopyTabLinksHTML', None, 'HTML', None, None, _copy_tab_links_html),
		]

# These implement the EphyExtension interface.

def attach_window(window):
	ui_manager = window.get_ui_manager()
	group = gtk.ActionGroup('TabLinks')
	group.add_actions(_actions, window)
	ui_manager.insert_action_group(group, -1)
	ui_id = ui_manager.add_ui_from_string(_ui_str)

	window._TabLinks_data = (group, ui_id)


def detach_window(window):
	group, ui_id = window._TabLinks_data
	del window._TabLinks_data

	ui_manager = window.get_ui_manager()
	ui_manager.remove_ui(ui_id)
	ui_manager.remove_action_group(group)
	ui_manager.ensure_update()

