#include "timerchain.h"
#include <iostream>
#include "console.h"

using namespace std;

TimerChain::TimerChain()
{
	starton = false;
	doneon = false;
}

void TimerChain::add( const Timer & t )
{
	timers.push_back( t );
}

void TimerChain::clear()
{
	// Can't remove timers while running
	if( starton )
		return;
	timers.clear();
}

/** Start the timer.
  *
  */
void TimerChain::start()
{
	// Can't start something twice
	if( starton )
		return;

	if( timers.size() <= 0 ) {
		starton = false;
		doneon = true;
		return;
	}
		
	starton = true;
	doneon = false;

	curtimer = 0;

	for( unsigned int i = 0; i < timers.size(); i++ ) {
		timers.at( i ).stop();
		timers.at( i ).resetDone();
	}
	
	timers.at( 0 ).start();
	val = timers.at( 0 ).startv();
}

bool TimerChain::started() const
{
	return starton;
}

void TimerChain::stop()
{
	starton = false;
}

bool TimerChain::done()
{
	return doneon;
}

void TimerChain::resetDone()
{
	doneon = false;
}

/** Update the timer.
 *  Modifies the value to reflect the time elapsed.
 */
void TimerChain::update()
{
	// Timer must be running to update
	if( !starton )
		return;
	
	lastval = val;
	
	timers.at( curtimer )++;

	val = timers.at( curtimer ).value();

	// As long as this isn't the last timer
	if( timers.at( curtimer ).done() && curtimer < timers.size() - 1 ) {
		curtimer++;
		timers.at( curtimer ).start();
	} else if( timers.at( curtimer ).done() && curtimer == timers.size() - 1 ) {
		lastval = val;
		starton = false;
		doneon = true;
	}	
}

/** Update the timer.
 *
 */
void TimerChain::operator++(int)
{
	update();
}

/** Returns the change in the value since the last update.
 *
 */
double TimerChain::change() const
{
	// No change if the timer isn't running
	if( !starton )
		return 0;
	
	return val - lastval;
}

/** Returns the current value within the range.
  * If the timer isn't running, returns the start of the range.
  * If the timer is finished, returns the end of the range.
  */
double TimerChain::value() const
{
	if( timers.size() <= 0 )
		return 0;

	if( doneon )
		return timers.at( timers.size() - 1 ) .end();

	// Still at the start if not running
	if( !starton )
		return timers.at( 0 ).startv();
	
	return timers.at( curtimer ).value();
}
