// Brutal Chess
//
// File : board.h
// Date : 05/03/2005
// Authors : Maxwell Lazaroff and Michael Cook
//
// Description : Implements a chessboard, with methods for checking bounds, etc. 

#ifndef __BOARD_H_IS_INCLUDED__
#define __BOARD_H_IS_INCLUDED__

#include <iostream>
#include <string>
#include "boardmove.h"

using namespace std;

/***************************************************************************
*	Piece Class
***************************************************************************/

enum Color { BLANK, BLACK, WHITE };
enum Unit  { EMPTY, PAWN, KNIGHT, BISHOP, ROOK, QUEEN, KING };

class Piece{
protected:
	
	//******** MEMBER DATA ********

	Color        _color;
	Unit         _piece;
	unsigned int _movecount;
	bool		 _justMoved;
	
public:
	
	//******** MANAGERS ********

	Piece(Color color = BLANK, Unit piece = EMPTY, unsigned int movecount = 0){
		_color 	   = color;
		_piece 	   = piece;
		_movecount = movecount;
		_justMoved = false;
	}
		
	//******** ACCESSORS ********
	
	Color 		 getColor() const;
	Unit  		 getUnit () const;
	unsigned int getMovecount() const;
	bool		 getJustMoved() const;
	string		 getName() const; 
	
	//******** UTILITIES ********

	void setColor(Color color);
	void setUnit (Unit unit);
	void setMovecount(unsigned int movecount);
	void setJustMoved();
	void unsetJustMoved();

};
	
/***************************************************************************
*	Board Class
***************************************************************************/

class Board {
private:

	//******** MEMBER DATA ********

	static const int BOARDSIZE = 8;

public:
	
	//******** PUBLIC DATA ********

	Piece _board[BOARDSIZE][BOARDSIZE];

	//******** MANAGERS ********

    Board() 
	{
		reset();
	}
    
	//******** UTILITIES ********
    
    void reset();
    void print();
	void pawnPromotion();
	bool inDanger(bool is_white, int row, int col) const;
	uint inDangerCount(bool is_white, int row, int col) const;
	bool is_in(BoardMove move) const;

	void updateBoard(BoardMove move);
};

#endif // __BOARD_H_IS_INCLUDED__

// End of file board.h
