/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: runthrd.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:09:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <vos/runthrd.hxx>
#include <vos/diagnose.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif

VOS_IMPLEMENT_CLASSINFO(VOS_CLASSNAME(OExecutableThread, vos), 
						VOS_NAMESPACE(OExecutableThread, vos), 
						VOS_NAMESPACE(OThread, vos), 0);


/*****************************************************************************/
// OExecutableThread 
/*****************************************************************************/
OExecutableThread::OExecutableThread(const ORef<IExecutable>& refWorker,
									 const ORef<IObserver>&	  refCompletionObserver)					
{
	m_refExecutable= refWorker;
	m_refCompletionObserver= refCompletionObserver;
}

/*****************************************************************************/
// ~OExecutableThread 
/*****************************************************************************/
OExecutableThread::~OExecutableThread() {
	// TRACE("~OExecutableThread()\n");
}

/*****************************************************************************/
// getExecutable
/*****************************************************************************/
ORef<IExecutable> OExecutableThread::getExecutable() const
{
	return m_refExecutable;
}

/*****************************************************************************/
// run
/*****************************************************************************/
void OExecutableThread::run() {
	VOS_ASSERT(m_refExecutable.isValid());
	
	while(m_refExecutable->execute() && schedule());
}

/*****************************************************************************/
// onTerminated 
/*****************************************************************************/
void OExecutableThread::onTerminated() {

	if(m_refCompletionObserver.isValid()) {
		m_refCompletionObserver->notify(0, this);
	}
}


