/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: documentlist.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:41:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
#include <com/sun/star/frame/XFramesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_MOZILLA_XPLUGININSTANCE_HPP_
#include <com/sun/star/mozilla/XPluginInstance.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_CLOSEVETOEXCEPTION_HPP_
#include <com/sun/star/util/CloseVetoException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#include <services/documentlist.hxx>
#include <documentlist.hrc>
#include <vcl/lstbox.hxx>
#include <comphelper/processfactory.hxx>
#include <tools/urlobj.hxx>
#include <vcl/menu.hxx>
#include <svtools/pathoptions.hxx>
#include <svtools/internaloptions.hxx>
#include <unotools/tempfile.hxx>
#include <unotools/ucbhelper.hxx>
#include <unotools/localfilehelper.hxx>

using namespace ::com::sun::star;

namespace framework
{

// this object is a Singleton
static ModifiedDocumentsWindow* pWindow = NULL;

// own static mutex to protect the static pointer
::osl::Mutex& GetStaticMutex_Impl()
{
    // Initialize static mutex
    static ::osl::Mutex* pMutex = NULL;
    if( pMutex == NULL )
    {
        // protect creation with global osl-Mutex
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if( pMutex == NULL )
        {
            // double check pattern
            static ::osl::Mutex aMutex;
            pMutex = &aMutex;
        }
    }

    return *pMutex;
}

// a struct that describes every modified document whose view have been closed
struct ModifiedDocumentInfo_Impl
{
    String      aURL;                   // the URL of the file ( or a unique ID for unnamed documents )
    String      aFilter;                // the filter that has been used on loading the document
    String      aTempName;              // optional: file was removed from memory and has been saved to disk
    String      aTitle;                 // display title of the document
    uno::Reference < frame::XModel > xModel;
};

// internal ListBox
class ModifiedDocumentsWindow_Impl : public ListBox
{
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& mxServiceFactory;

public:
	// #110897#
	ModifiedDocumentsWindow_Impl( 
		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
		Window* pParent );

    virtual long Notify( NotifyEvent& rNEvt );

	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& getServiceFactory();
};

// #110897#
ModifiedDocumentsWindow_Impl::ModifiedDocumentsWindow_Impl( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	Window* pParent )
:	// #110897#
	mxServiceFactory(xServiceFactory),
	ListBox( pParent )
{
}

ResId impl_getResId( sal_uInt16	nId )
{
	// If our ressource member not initialized we must create a new one.
	// Ask our ressource member to get right ressource for given ID.
	static ResMgr* pRessourceManager = ResMgr::CreateResMgr( "lgd" MAKE_NUMSTR(SUPD) );
	return ResId( nId, pRessourceManager );
}

long ModifiedDocumentsWindow_Impl::Notify( NotifyEvent& rNEvt )
{
	USHORT nType = rNEvt.GetType();
    if ( EVENT_COMMAND != nType )
        return 0L;

	const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
	if ( pCEvt->GetCommand() != COMMAND_CONTEXTMENU )
		return 0L;

	// UserData contains name of temporary file and URL
	ModifiedDocumentInfo_Impl* pUserData = (ModifiedDocumentInfo_Impl*) GetEntryData( GetSelectEntryPos() );

    // we need a plugin frame to open the document in a browser window
    uno::Reference < mozilla::XPluginInstance > xPlugin;

	// search for selected entry - may be it's a hidden task
    uno::Reference < frame::XFrame > xTask;      // remember the task, will be closed after save/discard/open
    uno::Reference < frame::XModel > xModel;  	// remember the model, will be used for saving operation
    uno::Reference < frame::XController > xController;
    try
    {
	// #110897#
    // uno::Reference < frame::XFramesSupplier > xDesk( ::comphelper::getProcessServiceFactory()->createInstance(
	//	SERVICENAME_DESKTOP ), uno::UNO_QUERY );
    uno::Reference < frame::XFramesSupplier > xDesk( getServiceFactory()->createInstance(
		SERVICENAME_DESKTOP ), uno::UNO_QUERY );

	uno::Reference < container::XIndexAccess > xTasks ( xDesk->getFrames(), uno::UNO_QUERY );
    sal_Int32 nCount = xTasks->getCount();
    for(sal_Int32 i=0; i<nCount; ++i)
    {
        uno::Any aElement = xTasks->getByIndex(i);
        if ( !(aElement>>=xTask) || !xTask.is() )
            continue;

        uno::Reference < mozilla::XPluginInstance > xPlug( xTask, uno::UNO_QUERY );
        if ( xPlug.is() )
        {
            // this pluginframe will be used for loading the file
            if ( !xPlugin.is() )
                xPlugin = xPlug;
        }
        else
        {
            // model not yet found ?
            if ( !xModel.is() )
            {
                // compare URL with the URL of the model or the model itself
                if ( xTask.is() )
                    xController = xTask->getController();
                if ( xController.is() )
                    xModel = xController->getModel();

                if ( xModel != pUserData->xModel || pUserData->aURL != String( xModel->getURL() ) )
                    // only one of the models is set, they are different or none is set and URLs differ
                    xModel = NULL;
            }
        }

        if ( xModel.is() && xPlugin.is() )
            // if we have all what we need, the loop can be stopped
            break;
    }
    }
    catch ( uno::Exception& )
    {
    }

    // perform context menu
    PopupMenu aMenu( impl_getResId( RID_DOCUMENTS_POPUP ) );
    if ( !xPlugin.is() )
		// without an open plugin reopening is impossible
        aMenu.RemoveItem( aMenu.GetItemPos( ID_OPEN ) );

    USHORT nId = aMenu.Execute( this, pCEvt->GetMousePosPixel() );
	switch ( nId )
	{
		case ID_SAVE :
		{
			// save document
            if ( xModel.is() )
            {
                try
                {
                uno::Reference < frame::XStorable > xStor( xModel, uno::UNO_QUERY );
                if ( pUserData->aURL.Len() )
                {
                    // already persistent, save again
                    if ( xStor.is() )
                        // if there is a "living" document, save it
                        xStor->store();
                }
                else if ( xStor.is() )
                {
                    // not persistent, save with default name
                    String aExtension;
                    String aSaveDir( SvtPathOptions().GetWorkPath() );

                    // get the filter name
                    ::rtl::OUString aOrigFilterName;
                    uno::Sequence < beans::PropertyValue > aArgs( xModel->getArgs() );
                    sal_Int32 nProps = aArgs.getLength();
                    for ( sal_Int32 nProp = 0; nProp<nProps; nProp++ )
                    {
                        const beans::PropertyValue& rProp = aArgs[nProp];
                        if( rProp.Name == ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
                        {
                            rProp.Value >>= aOrigFilterName;
                            break;
                        }
                    }

                    // determine correct extension
					// #110897#
                    // uno::Reference< lang::XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
                    // uno::Reference< container::XNameAccess > xFilterCFG( xServiceManager->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.FilterFactory" ) ) ), uno::UNO_QUERY );
                    // uno::Reference< container::XNameAccess > xTypeCFG( xServiceManager->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.TypeDetection" ) ) ), ::com::sun::star::uno::UNO_QUERY );
                    uno::Reference< container::XNameAccess > xFilterCFG( getServiceFactory()->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.FilterFactory" ) ) ), uno::UNO_QUERY );
                    uno::Reference< container::XNameAccess > xTypeCFG( getServiceFactory()->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.TypeDetection" ) ) ), ::com::sun::star::uno::UNO_QUERY );
                    
					uno::Sequence< beans::PropertyValue > lFilterProperties;
                    uno::Any aResult = xFilterCFG->getByName( aOrigFilterName );
                    if( aResult >>= lFilterProperties )
                    {
                        ::rtl::OUString sType;
                        sal_Int32 nFilterPropertyCount = lFilterProperties.getLength();
                        sal_Int32 nFilterProperty = 0;
                        for( nFilterProperty=0; nFilterProperty<nFilterPropertyCount; ++nFilterProperty )
                        {
                            if( lFilterProperties[nFilterProperty].Name.compareToAscii( "Type" ) == 0 )
                            {
                                lFilterProperties[nFilterProperty].Value >>= sType;
                                aResult = xTypeCFG->getByName( sType );
                                ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > lTypeProperties;
                                if( aResult >>= lTypeProperties )
                                {
                                    sal_Int32 nTypePropertyCount = lTypeProperties.getLength();
                                    sal_Int32 nTypeProperty = 0;
                                    for( nTypeProperty=0; nTypeProperty<nTypePropertyCount; ++nTypeProperty )
                                    {
                                        if( lTypeProperties[nTypeProperty].Name.compareToAscii( "Extensions" ) == 0 )
                                        {
                                            ::com::sun::star::uno::Sequence< ::rtl::OUString > lExtensions;
                                            lTypeProperties[nTypeProperty].Value >>= lExtensions;
                                            if ( lExtensions.getLength() )
                                            {
                                                aExtension = String('.');
                                                aExtension += lExtensions[0].getStr();
                                                break;
                                            }
                                        }
                                    }
                                }

                                break;
                            }
                        }
                    }

                    ::utl::TempFile aTempFile( pUserData->aTitle, &aExtension, &aSaveDir );
                    xStor->storeAsURL( aTempFile.GetURL(), uno::Sequence < beans::PropertyValue >() );
                }

				// clear modify flag before closing task to avoid messages
                uno::Reference < util::XModifiable > xModify( xModel, uno::UNO_QUERY );
				if ( xModify.is() )
					xModify->setModified( sal_False );

                    // close hidden task
                    try
                    {
                        uno::Reference< util::XCloseable > xCloseable(xTask, uno::UNO_QUERY);
                        if(xCloseable.is())
                            xCloseable->close(sal_True);
                        else
                        {
                            uno::Reference< lang::XComponent > xDisposable(xTask, uno::UNO_QUERY);
                            if (xDisposable.is())
                                xDisposable->dispose();
                        }
                    }
                    catch ( util::CloseVetoException& )
                    {
                    }
                    catch ( lang::DisposedException& )
                    {
                    }

                }
                catch ( uno::Exception& )
                {
                }
			}
			else if ( pUserData->aTempName.Len() )
            {
                // not a "living" task
                if ( !pUserData->aURL.Len() )
                {
                    // currently unnamed document, use title to construct file name
                    INetURLObject aObj( SvtPathOptions().GetStoragePath() );
                    aObj.insertName( pUserData->aTitle, false, INetURLObject::LAST_SEGMENT, true, INetURLObject::ENCODE_ALL );
                    pUserData->aURL = aObj.GetMainURL( INetURLObject::NO_DECODE );
                }

                // move file to its real destination
                ::utl::UCBContentHelper::MoveTo( pUserData->aTempName, pUserData->aURL, com::sun::star::ucb::NameClash::OVERWRITE );
            }
			else
				// the document must be a living one or stored in a TempFile
				OSL_ENSURE(sal_False, "Suspicous entry: no model, no TempFile!");

            delete pUserData;
            RemoveEntry( GetSelectEntryPos() );
			break;
		}
		case ID_DISCARD :
		{
            // discard document
            if ( xModel.is() )
            {
                uno::Reference < util::XModifiable > xModify( xModel, uno::UNO_QUERY );
                if ( xModify.is() )
                    // if there is a "living" document, clear its modify flag to avoid messages on closing the task
                    xModify->setModified( sal_False );

                // close hidden task ( dispose model ?! )
                try
                {
                    uno::Reference< util::XCloseable > xCloseable(xTask, uno::UNO_QUERY);
                    if(xCloseable.is())
                        xCloseable->close(sal_True);
                    else
                    {
                        uno::Reference< lang::XComponent > xDisposable(xTask, uno::UNO_QUERY);
                        if (xDisposable.is())
                            xDisposable->dispose();
                    }
                }
                catch ( util::CloseVetoException& )
                {
                }
                catch ( lang::DisposedException& )
                {
                }
			}
			else if ( pUserData->aTempName.Len() )
				// kill TempFile, is not needed anymore
                ::utl::UCBContentHelper::Kill( pUserData->aTempName );
			else
				// the document must be a living one or stored in a TempFile
				OSL_ENSURE(sal_False, "Suspicous entry: no model, no TempFile!");

            delete pUserData;
            RemoveEntry( GetSelectEntryPos() );
			break;
		}
		case ID_OPEN :
		{
            // use DispatchProvider of PluginFrame to open the file in a browser window
            uno::Reference < frame::XDispatchProvider > xProv( xPlugin, uno::UNO_QUERY );
        	if ( xProv.is() )
        	{
                try
                {
                // open document
                util::URL aTargetURL;

				// #110897#
                // uno::Reference < util::XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance(
				//	rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );
                uno::Reference < util::XURLTransformer > xTrans( getServiceFactory()->createInstance(
					rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );

                if ( pUserData->aTempName.Len() )
                    // file recovery
                    aTargetURL.Complete = pUserData->aTempName;
                else if ( pUserData->aURL.Len() )
                    // reopen persisten file
                    aTargetURL.Complete = pUserData->aURL;
                else
                    // reopen unnamed document
                    aTargetURL.Complete = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("private:factory/swriter") );

                xTrans->parseStrict( aTargetURL );

                // open new browser window
                uno::Reference < frame::XDispatch > xDisp = xProv->queryDispatch( aTargetURL,
                        ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("_blank") ), 0 );
                if ( xDisp.is() )
                {
                    // create the parameter array
                    uno::Sequence < beans::PropertyValue > aArgs( 2 );
                    aArgs[0].Name = ::rtl::OUString::createFromAscii("Referer");
                    aArgs[0].Value <<= ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("private:user") );
                    if ( pUserData->aTempName.Len() )
                    {
                        // recovery
                        aArgs.realloc( 4 );
                        aArgs[1].Name = ::rtl::OUString::createFromAscii("AsTemplate");
                        aArgs[2].Name = ::rtl::OUString::createFromAscii("FilterName");
                        aArgs[3].Name = ::rtl::OUString::createFromAscii("SalvagedFile");

                        aArgs[2].Value <<= ::rtl::OUString( pUserData->aFilter );
                        if ( pUserData->aURL.Len() )
                        {
                            // get the original URL for the recovered document
                            aArgs[1].Value <<= sal_False;
                            aArgs[3].Value <<= ::rtl::OUString( pUserData->aURL );
                        }
                        else
                        {
                            // this was an untitled document ( open as template )
                            aArgs[1].Value <<= sal_True;
                            aArgs[3].Value <<= ::rtl::OUString();
                        }

                        xDisp->dispatch( aTargetURL, aArgs );
                        RemoveEntry( GetSelectEntryPos() );
                        delete pUserData;
                    }
                    else if ( xModel.is() )
                    {
                        // reopening, document will be reopened by TryToLoad method below
                        aArgs[1].Name = ::rtl::OUString::createFromAscii("Model");
                        aArgs[1].Value <<= xModel;
                        xDisp->dispatch( aTargetURL, aArgs );
                    }
                    else
                        // the document must be a living one or stored in a TempFile
                        OSL_ENSURE(sal_False, "Suspicous entry: no model, no TempFile!");

                    break;
                }
                }
                catch ( uno::Exception& )
                {
                }
			}
		}

		default:
			break;
	}

    if ( !GetEntryCount() )
        pWindow->Hide();
    return 1L;
}

// #110897#
const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& ModifiedDocumentsWindow_Impl::getServiceFactory()
{
	// #110897#
	return mxServiceFactory;
}

// #110897#
ModifiedDocumentsWindow::ModifiedDocumentsWindow(
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
:	WorkWindow( NULL, WB_STDWORK | WB_CLIPCHILDREN | WB_3DLOOK )
{
	// ctor reads in the file recovery list, so it must be called before the first document is loaded
	// it is not made visible if recovery list is empty, only adding an entry makes it visible
    SetSizePixel( Size(300, 100) );
    SetText( String( impl_getResId( STR_MODIFIEDDOCS ) ) );

	// #110897#
	// pImp = new ModifiedDocumentsWindow_Impl( this );
	pImp = new ModifiedDocumentsWindow_Impl( xServiceFactory, this );

	pImp->Show();
    pImp->SetPosPixel( Point( 6,6 ) );

	// get all entries from the file recovery list
    ::rtl::OUString sName;
    ::rtl::OUString sFilter;
    ::rtl::OUString sTempName;
    SvtInternalOptions aInternalOptions;
    while( !aInternalOptions.IsRecoveryListEmpty() )
    {
        // Read and delete top recovery item from list0
        aInternalOptions.PopRecoveryItem( sName, sFilter, sTempName );
        ModifiedDocumentInfo_Impl* pUserData = new ModifiedDocumentInfo_Impl;

        INetURLObject aObj( sName );
        if ( INetURLObject::CompareProtocolScheme( sName ) != INET_PROT_NOT_VALID )
        {
            pUserData->aURL = sName;
            pUserData->aTitle = aObj.GetMainURL( INetURLObject::DECODE_WITH_CHARSET );
        }
        else
        {
            pUserData->aTitle = sName;
        }

        pUserData->aFilter = sFilter;
        pUserData->aTempName = sTempName;

        USHORT nPos = pImp->InsertEntry( pUserData->aTitle );
        pImp->SetEntryData( nPos, pUserData );
    }

	if ( pImp->GetEntryCount() )
		Show();
}

// #110897#
ModifiedDocumentsWindow* ModifiedDocumentsWindow::Get(
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
    ::osl::MutexGuard aGuard( GetStaticMutex_Impl() );

	if ( !pWindow )
	{
        pWindow = new ModifiedDocumentsWindow(xServiceFactory);
	}

	return pWindow;
}

// #110897#
void ModifiedDocumentsWindow::Remove(
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
    ::osl::MutexGuard aGuard( GetStaticMutex_Impl() );
    if ( !pWindow )
        return;

    // store to storage path ( this is local to the running soffice process )
    String aSavePath( SvtPathOptions().GetStoragePath() );
    String aSaveDir;
    ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aSavePath, aSaveDir );

    // add all document from the list to the RecoveryList
    SvtInternalOptions aOpt;

    // save all documents in the list, if they are kept by a hidden task
    // documents represented as TempFiles can be added to the list directly
    try
    {
	// #110897#
	// uno::Reference < frame::XFramesSupplier > xDesk( ::comphelper::getProcessServiceFactory()->createInstance(
	//	SERVICENAME_DESKTOP), uno::UNO_QUERY );
    uno::Reference < frame::XFramesSupplier > xDesk( xServiceFactory->createInstance(
		SERVICENAME_DESKTOP), uno::UNO_QUERY );

	uno::Reference < container::XIndexAccess > xTasks ( xDesk->getFrames(), uno::UNO_QUERY );
    uno::Reference < frame::XFrame > xTask;
    uno::Reference < frame::XController > xController;
    uno::Reference < frame::XModel > xModel;
    sal_Int32 nCount = xTasks->getCount();
    for (sal_Int32 i=0; i<nCount; ++i)
    {
        // it's cheaper to iterate over tasks first ( inner loop should be the faster one )
        uno::Any aElement = xTasks->getByIndex(i);
        if ( !(aElement>>=xTask) || !xTask.is() )
            continue;

        xController = xTask->getController();
        if ( xController.is() )
            xModel = xController->getModel();

        uno::Reference < util::XModifiable > xModify( xModel, uno::UNO_QUERY );
		if ( xModify.is() && xModify->isModified() )
		{
			// search in the list for this model
			ModifiedDocumentInfo_Impl* pUserData = NULL;
			USHORT i;
			for ( i=0; i<pWindow->pImp->GetEntryCount(); i++ )
        	{
                // compare the model with the internal references
            	pUserData = ( ModifiedDocumentInfo_Impl* ) pWindow->pImp->GetEntryData( i );
                if ( xModel == pUserData->xModel )
                	break;
        	}

            rtl::OUString aTitle;
            if ( i == pWindow->pImp->GetEntryCount() )
				// list searched until end and not found
				xController = NULL;
			else
			{
				// remove from list
                aTitle = pUserData->aTitle;
            	DELETEZ( pUserData );
            	pWindow->pImp->RemoveEntry( i );
			}

            // document found ?
            if ( xController.is() )
            {
                // clear modify flag to avoid messages when task is closed
                uno::Reference < util::XModifiable > xModify( xModel, uno::UNO_QUERY );
                if ( xModify.is() )
                    xModify->setModified( sal_False );

                // store document as temporary file
                uno::Reference < frame::XStorable > xStor( xModel, uno::UNO_QUERY );
                if ( xStor.is() )
                {
                    // get the media descriptor and retrieve filter name and password
                    ::rtl::OUString aOrigPassword, aOrigFilterName;
                    uno::Sequence < beans::PropertyValue > aArgs( xModel->getArgs() );
                    sal_Int32 nProps = aArgs.getLength();
                    for ( sal_Int32 nProp = 0; nProp<nProps; nProp++ )
                    {
                        const beans::PropertyValue& rProp = aArgs[nProp];
                        if( rProp.Name == ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
                            rProp.Value >>= aOrigFilterName;
                        if( rProp.Name == ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Password")) )
                            rProp.Value >>= aOrigPassword;
                    }

                    // save document as tempfile in backup directory
                    // remember old name or title
                    ::rtl::OUString aOrigURL = xModel->getURL();
                    ::rtl::OUString aOldName, aSaveURL;
                    if ( aOrigURL.getLength() )
                    {
                        ::utl::TempFile aTempFile( &aSaveDir );
                        aSaveURL = aTempFile.GetURL();
                        aOldName = aOrigURL;
                    }
                    else
                    {
                        // untitled document
                        String aExt( RTL_CONSTASCII_USTRINGPARAM( ".sav" ) );
                        ::utl::TempFile aTempFile( String( RTL_CONSTASCII_USTRINGPARAM( "exc" ) ), &aExt, &aSaveDir );
                        aSaveURL = aTempFile.GetURL();
                        aOldName = aTitle;
                    }

                    if ( aOrigPassword.getLength() )
                    {
                        // if the document was loaded with a password, it should be stored with password
                        uno::Sequence < beans::PropertyValue > aSaveArgs(1);
                        aSaveArgs[0].Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("Password") );
                        aSaveArgs[0].Value <<= aOrigPassword;

                        xStor->storeToURL( aSaveURL, aSaveArgs );
                    }
                    else
                        xStor->storeToURL( aSaveURL, uno::Sequence < beans::PropertyValue >() );

                    // remember original name and filter
                    aOpt.PushRecoveryItem( aOldName, aOrigFilterName, aSaveURL );
                }
            }
        }
    }
    }
    catch ( uno::Exception& )
    {
    }

    // now handle all documents in TempFiles
    for ( USHORT i=0; i<pWindow->pImp->GetEntryCount(); )
	{
        ModifiedDocumentInfo_Impl* pUserData = ( ModifiedDocumentInfo_Impl* ) pWindow->pImp->GetEntryData( i );
        if ( pUserData->aTempName.Len() )
            aOpt.PushRecoveryItem( pUserData->aTitle, pUserData->aFilter, pUserData->aTempName );
        else
            OSL_ENSURE(sal_False, "Suspicous entry: no model, no TempFile!");
		delete pUserData;
        pWindow->pImp->RemoveEntry( i );
	}

    DELETEZ( pWindow );
}

ModifiedDocumentsWindow::~ModifiedDocumentsWindow()
{
    delete pImp;
}

void ModifiedDocumentsWindow::Resize()
{
    Size aSize( GetOutputSizePixel() );
    aSize.Width() -= 12;
    aSize.Height() -= 12;
    pImp->SetSizePixel( aSize );
}

void ModifiedDocumentsWindow::Resizing( Size& rSize )
{
    if ( rSize.Width() < 12 )
        rSize.Width() = 12;
    if ( rSize.Height() < 12 )
        rSize.Height() = 12;
}

BOOL ModifiedDocumentsWindow::Close()
{
	// #110897#
    // Remove();
    Remove( pImp->getServiceFactory() );

	return TRUE;
}

// #110897#
void ModifiedDocumentsWindow::CheckForAdding( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	uno::Reference < frame::XFrame >& xFrame )
{
	// try to clone the view if neccessary
    try
    {
    uno::Reference < frame::XController > xController( xFrame->getController() );
    uno::Reference < frame::XDispatchProvider > xProv( xController, uno::UNO_QUERY );
    if ( xProv.is() )
    {
        uno::Reference < frame::XModel > xModel( xController->getModel() );
        uno::Reference < util::XModifiable > xMod( xModel, uno::UNO_QUERY );
        if ( xMod.is() && xMod->isModified() )
        {
			// #110897#
			// ModifiedDocumentsWindow* pThis = Get();
			ModifiedDocumentsWindow* pThis = Get( xServiceFactory );
    
			// it's a modified document, so try to clone its view
            util::URL aTargetURL;
            aTargetURL.Complete = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("slot:5620") );

			// #110897#
			// uno::Reference < util::XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance(
			//	rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );
			uno::Reference < util::XURLTransformer > xTrans( xServiceFactory->createInstance(
				rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );

			xTrans->parseStrict( aTargetURL );

            uno::Reference < frame::XDispatch > xDisp;
            if ( xProv.is() )
                xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
            if ( xDisp.is() )
            {
				// perform cloning
                uno::Sequence < beans::PropertyValue > aArgs(1);
                beans::PropertyValue* pArg = aArgs.getArray();
                pArg[0].Name = rtl::OUString::createFromAscii("Hidden");
                pArg[0].Value <<= (sal_Bool) sal_True;
                xDisp->dispatch( aTargetURL, aArgs );

				// get the name of the filter and remember it
				::rtl::OUString aFilterName;
                const uno::Sequence < beans::PropertyValue > rArgs = xModel->getArgs();
                for ( sal_Int32 nArg=0; nArg<rArgs.getLength(); nArg++ )
                {
                    const beans::PropertyValue& rProp = rArgs[nArg];
                    if ( rProp.Name.equalsAscii("FilterName") )
                    {
                        rProp.Value >>= aFilterName;
                        break;
                    }
                }

                ModifiedDocumentInfo_Impl* pUserData = new ModifiedDocumentInfo_Impl;
                pUserData->xModel = xModel;
                rtl::OUString aModelURL( xModel->getURL() );
                if ( aModelURL.getLength() )
                {
                    INetURLObject aURLObj( aModelURL );
                    pUserData->aURL = aURLObj.GetMainURL( INetURLObject::NO_DECODE );
                    pUserData->aTitle = aURLObj.GetMainURL( INetURLObject::DECODE_WITH_CHARSET );
                }
                else
                {
                    for ( sal_Int32 nArg=0; nArg<rArgs.getLength(); nArg++ )
                    {
                        const beans::PropertyValue& rProp = rArgs[nArg];
                        if ( rProp.Name.equalsAscii("Title") )
                        {
                            ::rtl::OUString aTitle;
                            rProp.Value >>= aTitle;
                            pUserData->aTitle = aTitle;
                            break;
                        }
                    }
                }

                pUserData->aFilter = aFilterName;
                USHORT nPos = pThis->pImp->InsertEntry( pUserData->aTitle );
                pThis->pImp->SetEntryData( nPos, pUserData );

                if ( !pThis->IsVisible() )
                    pThis->Show();
            }
        }
    }
    }
    catch ( uno::Exception& )
    {
    }
}

BOOL ModifiedDocumentsWindow::TryToLoad( const ::rtl::OUString& rURL, const uno::Sequence < beans::PropertyValue >& rArgs,
        const uno::Reference < frame::XFrame >& xTarget )
{
	// the given document should be loaded in the given Frame - may be that there is a hidden task or a TempFile ?
	INetURLObject aURLObj(rURL);

	// search list for given URL
    ModifiedDocumentInfo_Impl* pUserData = NULL;
    USHORT nEntryCount = pImp->GetEntryCount();
    String aSearch( aURLObj.GetMainURL( INetURLObject::NO_DECODE ) );
    USHORT nEntry;
    for ( nEntry=0; nEntry<nEntryCount; nEntry++ )
    {
        pUserData = ( ModifiedDocumentInfo_Impl* ) pImp->GetEntryData( nEntry );
        if ( pUserData->aURL == aSearch )
                break;
    }

    try
    {
    if ( nEntry == nEntryCount )
    {
        // not found in list by using URL, try using model in argument list ( if there is one )
        uno::Reference < frame::XModel > xModel;
        for ( sal_Int32 nArg=0; nArg<rArgs.getLength(); nArg++ )
        {
            const beans::PropertyValue& rProp = rArgs[nArg];
            if ( rProp.Name.equalsAscii("Model") )
            {
                rProp.Value >>= xModel;
                for ( nEntry=0; nEntry<nEntryCount; nEntry++ )
                {
                    pUserData = ( ModifiedDocumentInfo_Impl* ) pImp->GetEntryData( nEntry );
                    if ( pUserData->xModel == xModel )
                            break;
                }

                break;
            }
        }
    }

	// entry found ?
    if ( nEntry < nEntryCount )
    {
		// is it represented by a temporary file ?
		if ( pUserData->aTempName.Len() )
		{
            // perform a recovery load
        	uno::Reference < frame::XDispatchProvider > xProv( xTarget, uno::UNO_QUERY );
        	if ( xProv.is() )
        	{
				// parse URL

				// #110897#
            	// uno::Reference < util::XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance(
				//	rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );
            	uno::Reference < util::XURLTransformer > xTrans( pImp->getServiceFactory()->createInstance(
					rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );

            	util::URL aTargetURL;
            	aTargetURL.Complete = pUserData->aTempName;
            	xTrans->parseStrict( aTargetURL );

            	uno::Reference < frame::XDispatch > xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
            	if ( xDisp.is() )
            	{
                	// create the parameter array
                	uno::Sequence < beans::PropertyValue > aArgs( 4 );
                	aArgs[0].Name = ::rtl::OUString::createFromAscii("Referer");
                	aArgs[1].Name = ::rtl::OUString::createFromAscii("AsTemplate");
                	aArgs[2].Name = ::rtl::OUString::createFromAscii("FilterName");
                	aArgs[3].Name = ::rtl::OUString::createFromAscii("SalvagedFile");

                	aArgs[0].Value <<= ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("private:user") );
                	aArgs[2].Value <<= ::rtl::OUString( pUserData->aFilter );
                    if ( pUserData->aURL.Len() )
                	{
                    	// get the original URL for the recovered document
                    	aArgs[1].Value <<= sal_False;
                    	aArgs[3].Value <<= ::rtl::OUString( pUserData->aURL );
                	}
                	else
                	{
                    	// this was an untitled document ( open as template )
                    	aArgs[1].Value <<= sal_True;
                        aArgs[3].Value <<= ::rtl::OUString( pUserData->aTitle );
                	}

                	xDisp->dispatch( aTargetURL, aArgs );
                	pImp->RemoveEntry( nEntry );
                    if ( !pImp->GetEntryCount() )
                        Hide();
                	delete pUserData;
                	return TRUE;
            	}
        	}
		}
		else
		{
			// search for selected entry - may be it's a hidden task

			// #110897#
            // uno::Reference < frame::XFramesSupplier > xDesk( ::comphelper::getProcessServiceFactory()->createInstance(
			//	SERVICENAME_DESKTOP), uno::UNO_QUERY );
            uno::Reference < frame::XFramesSupplier > xDesk( pImp->getServiceFactory()->createInstance(
				SERVICENAME_DESKTOP), uno::UNO_QUERY );

			uno::Reference < container::XIndexAccess > xTasks ( xDesk->getFrames(), uno::UNO_QUERY );
            uno::Reference < frame::XFrame > xTask;      // remember the task, will be closed opening
    		uno::Reference < frame::XController > xController; // remember the controller, will be needed for cloning
            sal_Int32 nCount = xTasks->getCount();
            for( sal_Int32 i=0; i<nCount; ++i )
    		{
    			uno::Reference < frame::XModel > xModel;
                uno::Any aElement = xTasks->getByIndex(i);
                if( !(aElement>>=xTask) || !xTask.is() )
                    continue;

                xController = xTask->getController();
        		if ( xController.is() )
            		xModel = xController->getModel();
                if ( xModel == pUserData->xModel )
            		break;
        		else
            		xController = NULL;
    		}

    		if ( xController.is() )
    		{
				// hidden view found, clone it into the target frame
        		uno::Reference < frame::XDispatchProvider > xProv( xController, uno::UNO_QUERY );
        		if ( xProv.is() )
        		{
					// #110897#
            		// uno::Reference < util::XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance(
					//	rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );
            		uno::Reference < util::XURLTransformer > xTrans( pImp->getServiceFactory()->createInstance(
						rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), uno::UNO_QUERY );

            		util::URL aTargetURL;
            		aTargetURL.Complete = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("slot:5620") );
            		xTrans->parseStrict( aTargetURL );

            		uno::Reference < frame::XDispatch > xDisp;
            		if ( xProv.is() )
                		xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
            		if ( xDisp.is() )
            		{
                		uno::Sequence < beans::PropertyValue > aArgs(2);
                		beans::PropertyValue* pArg = aArgs.getArray();
                		pArg[0].Name = rtl::OUString::createFromAscii("Hidden");
                		pArg[0].Value <<= (sal_Bool) sal_False;
                		pArg[1].Name = rtl::OUString::createFromAscii("Frame");
                		pArg[1].Value <<= xTarget;
                		xDisp->dispatch( aTargetURL, aArgs );
                		pImp->RemoveEntry( nEntry );
                        if ( !pImp->GetEntryCount() )
                            Hide();
                		delete pUserData;
                        // close task
                        try
                        {
                            uno::Reference< util::XCloseable > xCloseable(xTask, uno::UNO_QUERY);
                            if(xCloseable.is())
                                xCloseable->close(sal_True);
                            else
                            {
                                uno::Reference< lang::XComponent > xDisposable(xTask, uno::UNO_QUERY);
                                if (xDisposable.is())
                                    xDisposable->dispose();
                            }
                        }
                        catch ( util::CloseVetoException& )
                        {
                        }
                        catch ( lang::DisposedException& )
                        {
                        }
                		return TRUE;
            		}
        		}
    		}
			else
				OSL_ENSURE(sal_False, "Suspicous entry: no model, no TempFile!");
		}
    }
    }
    catch ( uno::Exception& )
    {
    }

    return FALSE;
}

} //  namespace framework
