/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Awrapadox.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:56:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_ADO_AWRAPADOX_HXX_
#define _CONNECTIVITY_ADO_AWRAPADOX_HXX_

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

// Includes fuer ADO
//#include <oledb.h>
//#include <objbase.h>
//#include <initguid.h>
//#include <mapinls.h>
//#include <ocidl.h>

#ifndef __User_FWD_DEFINED__
#define __User_FWD_DEFINED__
typedef struct _ADOUser User;
#endif 	/* __User_FWD_DEFINED__ */

#ifndef __Group_FWD_DEFINED__
#define __Group_FWD_DEFINED__
typedef struct _ADOGroup Group;
#endif /* __Group_FWD_DEFINED__ */

#ifndef __Column_FWD_DEFINED__
#define __Column_FWD_DEFINED__
typedef struct _ADOColumn Column;
#endif 	/* __Column_FWD_DEFINED__ */

#ifndef __Index_FWD_DEFINED__
#define __Index_FWD_DEFINED__
typedef struct _ADOIndex Index;
#endif /* __cplusplus */

#ifndef __Key_FWD_DEFINED__
#define __Key_FWD_DEFINED__
typedef struct _ADOKey Key;
#endif 	/* __Key_FWD_DEFINED__ */

#ifndef __Table_FWD_DEFINED__
#define __Table_FWD_DEFINED__
typedef struct _ADOTable Table;
#endif 	/* __Table_FWD_DEFINED__ */

#include <adoint.h>

#include <ado/ADOCTINT.H>


#ifndef _CONNECTIVITY_ADO_AOLEWRAP_HXX_
#include "ado/Aolewrap.hxx"
#endif
#ifndef _CONNECTIVITY_ADO_AOLEVARIANT_HXX_
#include "ado/Aolevariant.hxx"
#endif
#ifndef _CONNECTIVITY_ADO_ADOIMP_HXX_
#include "ado/adoimp.hxx"
#endif
#include "ado/Awrapado.hxx"
#include "ado/WrapColumn.hxx"
#include "ado/WrapIndex.hxx"
#include "ado/WrapKey.hxx"
#include "ado/WrapTable.hxx"
#include "ado/WrapCatalog.hxx"

namespace connectivity
{
	namespace ado
	{
		class WpADOView : public WpOLEBase<ADOView>
		{
		public:
			WpADOView(ADOView* pInt=NULL)	:	WpOLEBase<ADOView>(pInt){}
			WpADOView(const WpADOView& rhs){operator=(rhs);}

			inline WpADOView& operator=(const WpADOView& rhs)
				{WpOLEBase<ADOView>::operator=(rhs); return *this;}

			::rtl::OUString get_Name() const;
			void get_Command(OLEVariant& _rVar) const;
			void put_Command(OLEVariant& _rVar);
		};

		class WpADOGroup : public WpOLEBase<ADOGroup>
		{
		public:
			WpADOGroup(ADOGroup* pInt=NULL)	:	WpOLEBase<ADOGroup>(pInt){}
			WpADOGroup(const WpADOGroup& rhs){operator=(rhs);}

			inline WpADOGroup& operator=(const WpADOGroup& rhs)
				{WpOLEBase<ADOGroup>::operator=(rhs); return *this;}

			void Create();

			::rtl::OUString get_Name() const;
			void put_Name(const ::rtl::OUString& _rName);
			RightsEnum GetPermissions( 
				/* [in] */ const OLEVariant& Name,
				/* [in] */ ObjectTypeEnum ObjectType);
			sal_Bool SetPermissions( 
				/* [in] */ const OLEVariant& Name,
				/* [in] */ ObjectTypeEnum ObjectType,
				/* [in] */ ActionEnum Action,
				/* [in] */ RightsEnum Rights);
			WpADOUsers get_Users( );
		};

		class WpADOUser : public WpOLEBase<_ADOUser>
		{
		public:
			WpADOUser(_ADOUser* pInt=NULL)	:	WpOLEBase<_ADOUser>(pInt){}
			WpADOUser(const WpADOUser& rhs){operator=(rhs);}

			inline WpADOUser& operator=(const WpADOUser& rhs)
				{WpOLEBase<_ADOUser>::operator=(rhs); return *this;}

			void Create();

			::rtl::OUString get_Name() const;
			void put_Name(const ::rtl::OUString& _rName);
			sal_Bool ChangePassword(const ::rtl::OUString& _rPwd,const ::rtl::OUString& _rNewPwd);
			WpADOGroups get_Groups();
			RightsEnum GetPermissions( 
				/* [in] */ const OLEVariant& Name,
				/* [in] */ ObjectTypeEnum ObjectType);
			sal_Bool SetPermissions( 
				/* [in] */ const OLEVariant& Name,
				/* [in] */ ObjectTypeEnum ObjectType,
				/* [in] */ ActionEnum Action,
				/* [in] */ RightsEnum Rights);
		};
	}
}
#endif // _CONNECTIVITY_ADO_AWRAPADOX_HXX_

