/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizmulti.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:28:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _WIZMULTI_HXX
#define _WIZMULTI_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#include <svtools/svmedit.hxx>

#include "wizpage.hxx"
namespace binfilter {

class WizardDokuDlg;

////////////////////////////////////////////////////////////////////////////////
// Abgekuerzte Dateinamen
////////////////////////////////////////////////////////////////////////////////

void FNam2FixedText(const String& rFNam, FixedText& rText);

////////////////////////////////////////////////////////////////////////////////
// MultiOne
////////////////////////////////////////////////////////////////////////////////

struct WinMerkRec
{
	Window* pWin;
	BOOL    bIsVisible : 1;
	BOOL    bIsGroup : 1;
	BOOL 	bGetFocus : 1;
};

// Enthaelt die Verweise auf alle Elemente eines Schrittes
class MultiOne
{
	USHORT      ElemAnz;
	USHORT      ArrSize;
	long		nHelpId;	// HelpId fuer diese Page
	WinMerkRec* ElemList; // Array mit Zeigern auf die Elemente
public:
	MultiOne();
	~MultiOne();

	void Show();
	void Hide();

	BOOL SetWinShowHide( Window* pWin, BOOL bShow );
	void SetAnz(USHORT nAnz);
	void AddWin(Window* pWin, BOOL bGetFocus=FALSE, BOOL bGroup=FALSE);
	BOOL FindWin(Window* pWin);

	USHORT GetAnz() { return ElemAnz; }
	Window* GetWin( USHORT Num )
		{ return Num < ElemAnz ? ElemList[ Num ].pWin : 0; }
	long GetHelpId() const			{ return nHelpId; }
	void SetHelpId( long nId )		{ nHelpId = nId; }
};

////////////////////////////////////////////////////////////////////////////////
// MultiDialog
////////////////////////////////////////////////////////////////////////////////

class MultiDialog: public ModalDialog
{
private:
	BOOL Step( short n, BOOL bOnlyCheck );
protected:
	USHORT     StepAnz; // Anzahl der Schritte
	USHORT     AktStep; // Aktueller Schritt
	MultiOne*  WinList; // Array mit Zeigern auf Arrays mit Zeigern auf die umzuschaltenden Elemente
	Button*    PrevBtn;
	Button*    NextBtn;

public:
	MultiDialog(Window* pParent, const ResId& rResId, USHORT nAnz);
	~MultiDialog();
	virtual void Init(Button* pPrev, Button* pNext);
	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Leave(USHORT StepNum); // Aufruf vor Hide
	virtual void Enter(USHORT StepNum); // Aufruf nach Show

	void Inc()			{ Step( +1, FALSE ); }
	void Dec()			{ Step( -1, FALSE ); }
	BOOL IsFrst()		{ return !Step( -1, TRUE ); }
	BOOL IsLast()		{ return !Step( +1, TRUE ); }

	void Switch(USHORT nStepNum);
	void ShowHideWin( Window& rWin, BOOL bShow );
	DECL_LINK( MultiClickHdl, Button * );
	BOOL FindWin(Window* pWin, USHORT& nStep); // Feststellen, in welchem Step das Win ist
	MultiOne* GetWinList(USHORT Num)
		{ return Num < StepAnz ? &WinList[ Num ] : 0; }
};

////////////////////////////////////////////////////////////////////////////////
// WizardPreview
////////////////////////////////////////////////////////////////////////////////

class WizardPreview: public Window
{
	WizardPage* pAktPage;
public:
	WizardPreview(Window* pParent, const ResId& rResId);
	virtual void Paint(const Rectangle&);
	void SetPage(WizardPage* pPage);
};

////////////////////////////////////////////////////////////////////////////////
// SwWizardDialog
////////////////////////////////////////////////////////////////////////////////

class SwWizardDialog : public MultiDialog
{
protected:
	Window*       pTrenWin;
	HelpButton*   pHelpBtn;
	CancelButton* pCnclBtn;
	PushButton*   pPrevBtn;
	PushButton*   pNextBtn;
	OKButton*     pOkayBtn;

	Size          aMinSize;
	Size          aSize0;
	MultiOne      URElem;  // Elemente die nicht umgeschaltet werden

	void FillFldListBox( ListBox& rLstBox, USHORT nType );

public:                    // die muss ich fuers Resize kennen
	WizardPreview aPrevWin;
	WizardDokuDlg* pDoku;

	SwWizardDialog( Window* pParent, const ResId& rResId, USHORT nAnz );
	~SwWizardDialog();

	virtual void Init();
	void FillDefElems(MultiOne& WinArr);

	virtual void WriteToIni() = 0;
	virtual BOOL MakeDoc() = 0;
};

////////////////////////////////////////////////////////////////////////////////
// JBitmapButton
////////////////////////////////////////////////////////////////////////////////

class JBitmapButton: public ImageButton
{
	Image aEnabImg;
	Image aDisbImg;
	Image aEnabImg_h;
	Image aDisbImg_h;
public:
	JBitmapButton(Window* pParent, const ResId& rResId);
	void Enable(BOOL bEnable);
	void setBitmaps(const Bitmap& rBmp_h);
	void ChangeDisbBitmap(const Bitmap& rBmp,const Bitmap& rBmp_h);
};



} //namespace binfilter
#endif  //_WIZMULTI_HXX

