/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_clipboardctl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:23:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXTBXCTRL_HXX
// auto strip #include <bf_sfx2/tbxctrl.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _PASTEDLG_HXX
// auto strip #include <so3/pastedlg.hxx>
// auto strip #endif
// auto strip #ifndef _SV_GEN_HXX
// auto strip #include <tools/gen.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SOT_EXCHANGE_HXX
// auto strip #include <sot/exchange.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif

#ifndef _SVX_CLIPBOARDCTL_HXX_
#include <clipboardctl.hxx>
#endif
// auto strip #ifndef _SVX_CLIPFMTITEM_HXX
// auto strip #include <clipfmtitem.hxx>
// auto strip #endif

#include <svxids.hrc>
namespace binfilter {

/////////////////////////////////////////////////////////////////

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxClipBoardControl, SfxVoidItem /*SfxUInt16Item*/ );


/*N*/ SvxClipBoardControl::SvxClipBoardControl(
/*N*/ 		USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 	pPopup		(0),
/*N*/     nItemId     (nId),
/*N*/     aForwarder( SID_CLIPBOARD_FORMAT_ITEMS, *this ),
/*N*/     pClipboardFmtItem( 0 )
/*N*/ {
/*N*/ 	ToolBox& rBox = GetToolBox();
/*N*/ 	rBox.SetItemBits( nId, TIB_DROPDOWN | rBox.GetItemBits( nId ) );
/*N*/ 	rBox.Invalidate();
/*N*/ }


/*N*/ SvxClipBoardControl::~SvxClipBoardControl()
/*N*/ {
/*N*/ 	DelPopup();
/*N*/     delete pClipboardFmtItem;
/*N*/ }


/*N*/ SfxPopupWindow* SvxClipBoardControl::CreatePopupWindow()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001     const SvxClipboardFmtItem* pFmtItem = PTR_CAST( SvxClipboardFmtItem, pClipboardFmtItem );
//STRIP001     if ( pFmtItem )
//STRIP001 	{
//STRIP001 		if (pPopup)
//STRIP001 			pPopup->Clear();
//STRIP001 		else
//STRIP001 			pPopup = new PopupMenu;
//STRIP001 
//STRIP001 		USHORT nCount = pFmtItem->Count();
//STRIP001 		for (USHORT i = 0;  i < nCount;  ++i)
//STRIP001 		{
//STRIP001 			ULONG nFmtID =  pFmtItem->GetClipbrdFormatId( i );
//STRIP001 			String aFmtStr( pFmtItem->GetClipbrdFormatName( i ) );
//STRIP001 			if (!aFmtStr.Len())
//STRIP001 				aFmtStr = SvPasteObjectDialog::GetSotFormatUIName( nFmtID );
//STRIP001 			pPopup->InsertItem( (USHORT)nFmtID, aFmtStr );
//STRIP001 		}
//STRIP001 
//STRIP001 		ToolBox& rBox = GetToolBox();
//STRIP001 		USHORT nId = GetId();
//STRIP001 		rBox.SetItemDown( nId, TRUE );
//STRIP001 
//STRIP001 		//Point aPt( rBox.OutputToScreenPixel( rBox.GetPointerPosPixel() ) );
//STRIP001 		Point aPt( rBox.OutputToScreenPixel(
//STRIP001 						rBox.GetItemRect( nItemId ).BottomLeft() ) );
//STRIP001 		pPopup->Execute( &rBox, rBox.ScreenToOutputPixel( aPt ) );
//STRIP001 		rBox.SetItemDown( nId, FALSE );
//STRIP001 
//STRIP001 		SfxUInt32Item aItem( SID_CLIPBOARD_FORMAT_ITEMS, pPopup->GetCurItemId() );
//STRIP001 		const SfxPoolItem* pArgs[] =
//STRIP001 		{
//STRIP001 			&aItem, NULL
//STRIP001 		};
//STRIP001 		GetBindings().ExecuteSynchron( SID_CLIPBOARD_FORMAT_ITEMS, pArgs );
//STRIP001 	}
//STRIP001 
//STRIP001 	GetToolBox().EndSelection();
//STRIP001 	DelPopup();
//STRIP001 	return 0;
/*N*/ }


/*N*/ SfxPopupWindowType SvxClipBoardControl::GetPopupWindowType() const
/*N*/ {
/*N*/ 	return SFX_POPUPWINDOW_ONTIMEOUT;
/*N*/ }


/*N*/ void SvxClipBoardControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     if ( SID_CLIPBOARD_FORMAT_ITEMS == nSID )
/*N*/     {
/*N*/         DELETEZ( pClipboardFmtItem );
/*N*/         if ( eState >= SFX_ITEM_AVAILABLE )
/*N*/ 		{
/*N*/             pClipboardFmtItem = pState->Clone();
/*N*/             GetToolBox().SetItemBits( GetId(), GetToolBox().GetItemBits( GetId() ) | TIB_DROPDOWN );
/*N*/ 		}
/*N*/ 		else
/*N*/             GetToolBox().SetItemBits( GetId(), GetToolBox().GetItemBits( GetId() ) & ~TIB_DROPDOWN );
/*N*/         GetToolBox().Invalidate( GetToolBox().GetItemRect( GetId() ) );
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         // enable the item as a whole
/*N*/         GetToolBox().EnableItem( GetId(), (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/     }
/*N*/ }


/*N*/ void SvxClipBoardControl::DelPopup()
/*N*/ {
/*N*/ 	if(pPopup)
/*N*/ 	{
/*?*/ 		delete pPopup;
/*?*/ 		pPopup = 0;
/*N*/ 	}
/*N*/ }


/////////////////////////////////////////////////////////////////

}
