/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tphatch.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:10:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#pragma hdrstop

#define _SVX_TPHATCH_CXX

#include "dialogs.hrc"
#include "tabarea.hrc"
#include "dlgname.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_HATCH_LIST		SID_HATCH_LIST

#include "xattr.hxx"
#include "xpool.hxx"
#include "xtable.hxx"
#include "xoutx.hxx"

#include "drawitem.hxx"
#include "tabarea.hxx"
#include "dlgname.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()

//STRIP001 #define BITMAP_WIDTH  32
//STRIP001 #define BITMAP_HEIGHT 12

/*************************************************************************
|*
|*	Dialog zum Aendern und Definieren der Schraffuren
|*
\************************************************************************/

//STRIP001 SvxHatchTabPage::SvxHatchTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 
//STRIP001 	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_HATCH ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 	aXFStyleItem		( XFILL_HATCH ),
//STRIP001 	aXHatchItem			( String(), XHatch() ),
//STRIP001 
//STRIP001 	aFtDistance			( this, ResId( FT_LINE_DISTANCE ) ),
//STRIP001 	aMtrDistance		( this, ResId( MTR_FLD_DISTANCE ) ),
//STRIP001 	aFtAngle			( this, ResId( FT_LINE_ANGLE ) ),
//STRIP001 	aMtrAngle			( this, ResId( MTR_FLD_ANGLE ) ),
//STRIP001 	aCtlAngle			( this, ResId( CTL_ANGLE ),
//STRIP001 									RP_RB, 200, 80, CS_ANGLE ),
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001 	aFtLineType			( this, ResId( FT_LINE_TYPE ) ),
//STRIP001 	aLbLineType			( this, ResId( LB_LINE_TYPE ) ),
//STRIP001 	aFtLineColor		( this, ResId( FT_LINE_COLOR ) ),
//STRIP001 	aLbLineColor		( this, ResId( LB_LINE_COLOR ) ),
//STRIP001 	aLbHatchings		( this, ResId( LB_HATCHINGS ) ),
//STRIP001 	aCtlPreview			( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 	aBtnAdd				( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnModify			( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnDelete			( this, ResId( BTN_DELETE ) ),
//STRIP001 	aBtnLoad			( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave			( this, ResId( BTN_SAVE ) ),
//STRIP001 	rOutAttrs			( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMtrDistance, eFUnit );
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_FILL_HATCH );
//STRIP001 
//STRIP001 	// Setzen des Output-Devices
//STRIP001 	rXFSet.Put( aXFStyleItem );
//STRIP001 	rXFSet.Put( aXHatchItem );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001     // Set line at the OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineWidthItem( 1 ));
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aLbHatchings.SetSelectHdl( LINK( this, SvxHatchTabPage, ChangeHatchHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxHatchTabPage, ModifiedHdl_Impl );
//STRIP001 	aMtrDistance.SetModifyHdl( aLink );
//STRIP001 	aMtrAngle.SetModifyHdl( aLink );
//STRIP001 	aLbLineType.SetSelectHdl( aLink );
//STRIP001 	aLbLineColor.SetSelectHdl( aLink );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl( LINK( this, SvxHatchTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxHatchTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxHatchTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 	aBtnLoad.SetClickHdl( LINK( this, SvxHatchTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl( LINK( this, SvxHatchTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 	pHatchingList = NULL;
//STRIP001 
//STRIP001 	
//STRIP001 	aCtlPreview.SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHatchTabPage::Construct()
//STRIP001 {
//STRIP001 	// Farbtabelle
//STRIP001 	aLbLineColor.Fill( pColorTab );
//STRIP001 
//STRIP001 	// Schraffurentabelle
//STRIP001 	aLbHatchings.Fill( pHatchingList );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHatchTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	int nPos;
//STRIP001 	int nCount;
//STRIP001 
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		*pbAreaTP = FALSE;
//STRIP001 
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			// ColorTable
//STRIP001 			if( *pnColorTableState & CT_CHANGED ||
//STRIP001 				*pnColorTableState & CT_MODIFIED )
//STRIP001 			{
//STRIP001 				if( *pnColorTableState & CT_CHANGED )
//STRIP001 					pColorTab = ( (SvxAreaTabDialog*) DLGWIN )->GetNewColorTable();
//STRIP001 
//STRIP001 				// LbLineColor
//STRIP001 				nPos = aLbLineColor.GetSelectEntryPos();
//STRIP001 				aLbLineColor.Clear();
//STRIP001 				aLbLineColor.Fill( pColorTab );
//STRIP001 				nCount = aLbLineColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbLineColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbLineColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ModifiedHdl_Impl( this );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 			INetURLObject	aURL( pHatchingList->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pHatchingList->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			if( *pPageType == PT_HATCH && *pPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbHatchings.SelectEntryPos( *pPos );
//STRIP001 			}
//STRIP001 			// Farben koennten geloescht worden sein
//STRIP001 			ChangeHatchHdl_Impl( this );
//STRIP001 
//STRIP001 			*pPageType = PT_HATCH;
//STRIP001 			*pPos = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rXFSet.Put ( ( XFillColorItem& )    rSet.Get(XATTR_FILLCOLOR) );
//STRIP001 	rXFSet.Put ( ( XFillBackgroundItem&)rSet.Get(XATTR_FILLBACKGROUND) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SvxHatchTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( CheckChanges_Impl() == -1L )
//STRIP001 		return KEEP_PAGE;
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long SvxHatchTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	if( aMtrDistance.GetText()			 != aMtrDistance.GetSavedValue() ||
//STRIP001 		aMtrAngle.GetText()				 != aMtrAngle.GetSavedValue() ||
//STRIP001 		aLbLineType.GetSelectEntryPos()	 != aLbLineType.GetSavedValue()  ||
//STRIP001 		aLbLineColor.GetSelectEntryPos() != aLbLineColor.GetSavedValue() ||
//STRIP001 		aLbHatchings.GetSelectEntryPos() != aLbHatchings.GetSavedValue() )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001         Image aWarningBoxImage = WarningBox::GetStandardImage();
//STRIP001 		SvxMessDialog aMessDlg( DLGWIN,
//STRIP001 			String( ResId( RID_SVXSTR_HATCH, pMgr ) ),
//STRIP001 			String( ResId( RID_SVXSTR_ASK_CHANGE_HATCH, pMgr ) ),
//STRIP001 			&aWarningBoxImage );
//STRIP001 		aMessDlg.SetButtonText( MESS_BTN_1,
//STRIP001 								String( ResId( RID_SVXSTR_CHANGE, pMgr ) ) );
//STRIP001 		aMessDlg.SetButtonText( MESS_BTN_2,
//STRIP001 								String( ResId( RID_SVXSTR_ADD, pMgr ) ) );
//STRIP001 
//STRIP001 		short nRet = aMessDlg.Execute();
//STRIP001 
//STRIP001 		switch( nRet )
//STRIP001 		{
//STRIP001 			case RET_BTN_1: // Aendern
//STRIP001 			{
//STRIP001 				ClickModifyHdl_Impl( this );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RET_BTN_2: // Hinzufuegen
//STRIP001 			{
//STRIP001 				ClickAddHdl_Impl( this );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RET_CANCEL:
//STRIP001 				// return( -1L ); <-- wuerde die Seite nicht verlassen
//STRIP001 			break;
//STRIP001 			// return( TRUE ); // Abbruch
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		*pPos = nPos;
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxHatchTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 && *pbAreaTP == FALSE ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		if( *pPageType == PT_HATCH )
//STRIP001 		{
//STRIP001 			// CheckChanges(); <-- doppelte Abfrage ?
//STRIP001 
//STRIP001 			XHatch*	pXHatch = NULL;
//STRIP001 			String	aString;
//STRIP001 			USHORT	nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 			if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				pXHatch = new XHatch( pHatchingList->Get( nPos )->GetHatch() );
//STRIP001 				aString = aLbHatchings.GetSelectEntry();
//STRIP001 			}
//STRIP001 			// Farbverlauf wurde (unbekannt) uebergeben
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pXHatch = new XHatch( aLbLineColor.GetSelectEntryColor(),
//STRIP001 								 (XHatchStyle) aLbLineType.GetSelectEntryPos(),
//STRIP001 								 GetCoreValue( aMtrDistance, ePoolUnit ),
//STRIP001 								 aMtrAngle.GetValue() * 10 );
//STRIP001 			}
//STRIP001 			DBG_ASSERT( pXHatch, "XHatch konnte nicht erzeugt werden" );
//STRIP001 			rOutAttrs.Put( XFillStyleItem( XFILL_HATCH ) );
//STRIP001 			rOutAttrs.Put( XFillHatchItem( aString, *pXHatch ) );
//STRIP001 
//STRIP001 			delete pXHatch;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHatchTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	// aLbHatchings.SelectEntryPos( 0 );
//STRIP001 	ChangeHatchHdl_Impl( this );
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pHatchingList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	rXFSet.Put ( ( XFillColorItem& )    rOutAttrs.Get(XATTR_FILLCOLOR) );
//STRIP001 	rXFSet.Put ( ( XFillBackgroundItem&)rOutAttrs.Get(XATTR_FILLBACKGROUND) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxHatchTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return new SvxHatchTabPage( pWindow, rOutAttrs );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ModifiedHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( p == &aMtrAngle )
//STRIP001 	{
//STRIP001 		// Setzen des Winkels im AngleControl
//STRIP001 		switch( aMtrAngle.GetValue() )
//STRIP001 		{
//STRIP001 			case 135: aCtlAngle.SetActualRP( RP_LT ); break;
//STRIP001 			case  90: aCtlAngle.SetActualRP( RP_MT ); break;
//STRIP001 			case  45: aCtlAngle.SetActualRP( RP_RT ); break;
//STRIP001 			case 180: aCtlAngle.SetActualRP( RP_LM ); break;
//STRIP001 			case   0: aCtlAngle.SetActualRP( RP_RM ); break;
//STRIP001 			case 225: aCtlAngle.SetActualRP( RP_LB ); break;
//STRIP001 			case 270: aCtlAngle.SetActualRP( RP_MB ); break;
//STRIP001 			case 315: aCtlAngle.SetActualRP( RP_RB ); break;
//STRIP001 			default:  aCtlAngle.SetActualRP( RP_MM ); break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	XHatch aXHatch( aLbLineColor.GetSelectEntryColor(),
//STRIP001 					(XHatchStyle) aLbLineType.GetSelectEntryPos(),
//STRIP001 					GetCoreValue( aMtrDistance, ePoolUnit ),
//STRIP001 					aMtrAngle.GetValue() * 10 );
//STRIP001 
//STRIP001 	rXFSet.Put( XFillHatchItem( String(), aXHatch ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ChangeHatchHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	XHatch* pHatch = NULL;
//STRIP001 	int nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		pHatch = new XHatch( ( (XHatchEntry*) pHatchingList->Get( nPos ) )->GetHatch() );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pPoolItem = NULL;
//STRIP001 		if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLSTYLE ), TRUE, &pPoolItem ) )
//STRIP001 		{
//STRIP001 			if( ( XFILL_HATCH == (XFillStyle) ( ( const XFillStyleItem* ) pPoolItem )->GetValue() ) &&
//STRIP001 				( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLHATCH ), TRUE, &pPoolItem ) ) )
//STRIP001 			{
//STRIP001 				pHatch = new XHatch( ( ( const XFillHatchItem* ) pPoolItem )->GetValue() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( !pHatch )
//STRIP001 		{
//STRIP001 			aLbHatchings.SelectEntryPos( 0 );
//STRIP001 			nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 			if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 				pHatch = new XHatch( ( (XHatchEntry*) pHatchingList->Get( nPos ) )->GetHatch() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pHatch )
//STRIP001 	{
//STRIP001 		aLbLineType.SelectEntryPos( pHatch->GetHatchStyle() );
//STRIP001 		// Wenn der Eintrag nicht in der Listbox ist, wird die Farbe
//STRIP001 		// temporaer hinzugenommen
//STRIP001 		aLbLineColor.SetNoSelection();
//STRIP001 		aLbLineColor.SelectEntry( pHatch->GetColor() );
//STRIP001 		if( aLbLineColor.GetSelectEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			aLbLineColor.InsertEntry( pHatch->GetColor(), String() );
//STRIP001 			aLbLineColor.SelectEntry( pHatch->GetColor() );
//STRIP001 		}
//STRIP001 		SetMetricValue( aMtrDistance, pHatch->GetDistance(), ePoolUnit );
//STRIP001 		aMtrAngle.SetValue( pHatch->GetAngle() / 10 );
//STRIP001 
//STRIP001 		// Setzen des Winkels im AngleControl
//STRIP001 		switch( aMtrAngle.GetValue() )
//STRIP001 		{
//STRIP001 			case 135: aCtlAngle.SetActualRP( RP_LT ); break;
//STRIP001 			case  90: aCtlAngle.SetActualRP( RP_MT ); break;
//STRIP001 			case  45: aCtlAngle.SetActualRP( RP_RT ); break;
//STRIP001 			case 180: aCtlAngle.SetActualRP( RP_LM ); break;
//STRIP001 			case   0: aCtlAngle.SetActualRP( RP_RM ); break;
//STRIP001 			case 225: aCtlAngle.SetActualRP( RP_LB ); break;
//STRIP001 			case 270: aCtlAngle.SetActualRP( RP_MB ); break;
//STRIP001 			case 315: aCtlAngle.SetActualRP( RP_RB ); break;
//STRIP001 			default:  aCtlAngle.SetActualRP( RP_MM ); break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Backgroundcolor
//STRIP001 		/*
//STRIP001 		const SfxPoolItem* pPoolItem = NULL;
//STRIP001 		if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLBACKGROUND ), TRUE, &pPoolItem ) )
//STRIP001 		{
//STRIP001 			rXFSet.Put ( XFillBackgroundItem( ( ( XFillBackgroundItem* )pPoolItem)->GetValue() ) );
//STRIP001 			if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE, &pPoolItem ) )
//STRIP001 			{
//STRIP001 				Color aColor( ( ( const XFillColorItem* ) pPoolItem )->GetValue() );
//STRIP001 				rXFSet.Put( XFillColorItem( String(), aColor ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		*/
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		rXFSet.Put( XFillHatchItem( String(), *pHatch ) );
//STRIP001 		XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 		delete pHatch;
//STRIP001 	}
//STRIP001 	aMtrDistance.SaveValue();
//STRIP001 	aMtrAngle.SaveValue();
//STRIP001 	aLbLineType.SaveValue();
//STRIP001 	aLbLineColor.SaveValue();
//STRIP001 	aLbHatchings.SaveValue();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	String aNewName( ResId( RID_SVXSTR_HATCH, pMgr ) );
//STRIP001 	String aDesc( ResId( RID_SVXSTR_DESC_HATCH, pMgr ) );
//STRIP001 	String aName;
//STRIP001 
//STRIP001 	long nCount = pHatchingList->Count();
//STRIP001 	long j = 1;
//STRIP001 	BOOL bDifferent = FALSE;
//STRIP001 
//STRIP001 	while( !bDifferent )
//STRIP001 	{
//STRIP001 		aName  = aNewName;
//STRIP001 		aName += sal_Unicode(' ');
//STRIP001 		aName += UniString::CreateFromInt32( j++ );
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pHatchingList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxNameDialog* pDlg     = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 	WarningBox*    pWarnBox = NULL;
//STRIP001 	USHORT         nError   = RID_SVXSTR_WARN_NAME_DUPLICATE;
//STRIP001 
//STRIP001 	while( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		pDlg->GetName( aName );
//STRIP001 
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pHatchingList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 
//STRIP001 		if( bDifferent ) {
//STRIP001 			nError = 0;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !pWarnBox )
//STRIP001 		{
//STRIP001 			pWarnBox = new WarningBox( DLGWIN,
//STRIP001 									   WinBits( WB_OK_CANCEL ),
//STRIP001 									   String( ResId( nError, pMgr ) ) );
//STRIP001 			pWarnBox->SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pWarnBox->Execute() != RET_OK )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	//Rectangle aDlgRect( pDlg->GetPosPixel(), pDlg->GetSizePixel() );
//STRIP001 	delete pDlg;
//STRIP001 	delete pWarnBox;
//STRIP001 
//STRIP001 	if( !nError )
//STRIP001 	{
//STRIP001 		XHatch aXHatch( aLbLineColor.GetSelectEntryColor(),
//STRIP001 						(XHatchStyle) aLbLineType.GetSelectEntryPos(),
//STRIP001 						GetCoreValue( aMtrDistance, ePoolUnit ),
//STRIP001 						aMtrAngle.GetValue() * 10 );
//STRIP001 		XHatchEntry* pEntry = new XHatchEntry( aXHatch, aName );
//STRIP001 
//STRIP001 		pHatchingList->Insert( pEntry, nCount );
//STRIP001 
//STRIP001 		aLbHatchings.Append( pEntry );
//STRIP001 
//STRIP001 		aLbHatchings.SelectEntryPos( aLbHatchings.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 		// hack: #31355# W.P.
//STRIP001 		Rectangle aRect( aLbHatchings.GetPosPixel(), aLbHatchings.GetSizePixel() );
//STRIP001 		if( TRUE ) {				// ??? overlapped with pDlg
//STRIP001 									// and srolling
//STRIP001 			Invalidate( aRect );
//STRIP001 			//aLbHatchings.Invalidate();
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		// Flag fuer modifiziert setzen
//STRIP001 		*pnHatchingListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 		ChangeHatchHdl_Impl( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pHatchingList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aNewName( ResId( RID_SVXSTR_HATCH, pMgr ) );
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_HATCH, pMgr ) );
//STRIP001 		String aName( pHatchingList->Get( nPos )->GetName() );
//STRIP001 		String aOldName = aName;
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 
//STRIP001 		long nCount = pHatchingList->Count();
//STRIP001 		BOOL bDifferent = FALSE;
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 		while( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pHatchingList->Get( i )->GetName() &&
//STRIP001 					aName != aOldName )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bDifferent )
//STRIP001 			{
//STRIP001 				bLoop = FALSE;
//STRIP001 				XHatch aXHatch( aLbLineColor.GetSelectEntryColor(),
//STRIP001 								(XHatchStyle) aLbLineType.GetSelectEntryPos(),
//STRIP001 								 GetCoreValue( aMtrDistance, ePoolUnit ),
//STRIP001 								aMtrAngle.GetValue() * 10 );
//STRIP001 
//STRIP001 				XHatchEntry* pEntry = new XHatchEntry( aXHatch, aName );
//STRIP001 
//STRIP001 				delete pHatchingList->Replace( pEntry, nPos );
//STRIP001 
//STRIP001 				aLbHatchings.Modify( pEntry, nPos );
//STRIP001 
//STRIP001 				aLbHatchings.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// Werte sichern fuer Changes-Erkennung ( -> Methode )
//STRIP001 				aMtrDistance.SaveValue();
//STRIP001 				aMtrAngle.SaveValue();
//STRIP001 				aLbLineType.SaveValue();
//STRIP001 				aLbLineColor.SaveValue();
//STRIP001 				aLbHatchings.SaveValue();
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnHatchingListState |= CT_MODIFIED;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				WarningBox aBox( DLGWIN, WinBits( WB_OK ),String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 				aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete( pDlg );
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbHatchings.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!			SVX_RES( RID_SVXSTR_DEL_HATCH ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_HATCH ) ) );
//STRIP001 
//STRIP001 		if( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			delete pHatchingList->Remove( nPos );
//STRIP001 			aLbHatchings.RemoveEntry( nPos );
//STRIP001 			aLbHatchings.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 			aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 			ChangeHatchHdl_Impl( this );
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnHatchingListState |= CT_MODIFIED;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( !pHatchingList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ClickLoadHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 
//STRIP001 	if ( *pnHatchingListState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pHatchingList->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soh" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Liste speichern
//STRIP001 			XHatchList* pHatchList = new XHatchList( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pHatchList->SetName( aURL.getName() );
//STRIP001 			if( pHatchList->Load() )
//STRIP001 			{
//STRIP001 				if( pHatchList )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if( pHatchingList != ( (SvxAreaTabDialog*) DLGWIN )->GetHatchingList() )
//STRIP001 						delete pHatchingList;
//STRIP001 
//STRIP001 					pHatchingList = pHatchList;
//STRIP001 					( (SvxAreaTabDialog*) DLGWIN )->SetNewHatchingList( pHatchingList );
//STRIP001 
//STRIP001 					aLbHatchings.Clear();
//STRIP001 					aLbHatchings.Fill( pHatchingList );
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pHatchingList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 					if ( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnHatchingListState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnHatchingListState &= ~CT_MODIFIED;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pHatchingList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHatchTabPage, ClickSaveHdl_Impl, void *, p )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soh" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pHatchingList->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pHatchingList->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "soh" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pHatchingList->SetName( aURL.getName() );
//STRIP001 		pHatchingList->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pHatchingList->Save() )
//STRIP001 		{
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnHatchingListState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnHatchingListState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxHatchTabPage::PointChanged( Window* pWindow, RECT_POINT eRcPt )
//STRIP001 {
//STRIP001 	if( pWindow == &aCtlAngle )
//STRIP001 	{
//STRIP001 		switch( eRcPt )
//STRIP001 		{
//STRIP001 			case RP_LT: aMtrAngle.SetValue( 135 ); break;
//STRIP001 			case RP_MT: aMtrAngle.SetValue( 90 );  break;
//STRIP001 			case RP_RT: aMtrAngle.SetValue( 45 );  break;
//STRIP001 			case RP_LM: aMtrAngle.SetValue( 180 ); break;
//STRIP001 			case RP_RM: aMtrAngle.SetValue( 0 );   break;
//STRIP001 			case RP_LB: aMtrAngle.SetValue( 225 ); break;
//STRIP001 			case RP_MB: aMtrAngle.SetValue( 270 ); break;
//STRIP001 			case RP_RB: aMtrAngle.SetValue( 315 ); break;
//STRIP001 		}
//STRIP001 		ModifiedHdl_Impl( this );
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxHatchTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		aCtlPreview.SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 
//STRIP001 	SvxTabPage::DataChanged( rDCEvt );
//STRIP001 }

}
