/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hyperdlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:49:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _SV_SETTINGS_HXX
// auto strip #include <vcl/settings.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
// auto strip #include <svtools/viewoptions.hxx>
// auto strip #endif

#include "hyperdlg.hxx"

// auto strip #include "hlinettp.hxx"
// auto strip #include "hlmailtp.hxx"
// auto strip #include "hldoctp.hxx"
// auto strip #include "hldocntp.hxx"

#include "hyperdlg.hrc"
namespace binfilter {

//########################################################################
//#                                                                      #
//# Childwindow-Wrapper-Class                                            #
//#                                                                      #
//########################################################################

//STRIP001 SvxHlinkCtrl::SvxHlinkCtrl( USHORT nId, SfxBindings & rBindings, SvxHpLinkDlg* pDlg )
//STRIP001 : SfxControllerItem ( nId, rBindings ),
//STRIP001   aRdOnlyForwarder  ( SID_READONLY_MODE, *this ),
//STRIP001   aOnlineForwarder  ( SID_INTERNET_ONLINE , *this )
//STRIP001 {
//STRIP001 	pParent = pDlg;
//STRIP001 }

//STRIP001 void SvxHlinkCtrl::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 								 const SfxPoolItem* pState )
//STRIP001 {
//STRIP001     if ( eState == SFX_ITEM_AVAILABLE )
//STRIP001     {
//STRIP001         switch ( nSID )
//STRIP001         {
//STRIP001 	        case SID_INTERNET_ONLINE :
//STRIP001             {
//STRIP001     		    pParent->EnableInetBrowse( !( (SfxBoolItem*)pState)->GetValue() );
//STRIP001             }
//STRIP001             break;
//STRIP001 		    case SID_HYPERLINK_GETLINK :
//STRIP001 		    {
//STRIP001 			    pParent->SetPage ( (SvxHyperlinkItem*)pState);
//STRIP001 		    }
//STRIP001             break;
//STRIP001             case SID_READONLY_MODE :
//STRIP001             {
//STRIP001                 pParent->SetReadOnlyMode( ( (SfxBoolItem*)pState)->GetValue() == TRUE );
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//########################################################################
//#                                                                      #
//# Childwindow-Wrapper-Class                                            #
//#                                                                      #
//########################################################################

/*N*/ SFX_IMPL_CHILDWINDOW(SvxHlinkDlgWrapper, SID_HYPERLINK_DIALOG)

// -----------------------------------------------------------------------

//STRIP001 struct MyStruct
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > xFrame;
//STRIP001 	SfxChildWinFactory* pFact;
//STRIP001 	sal_Bool				bHideNotDelete;
//STRIP001 	sal_Bool				bVisible;
//STRIP001 	sal_Bool				bHideAtToggle;
//STRIP001 	SfxModule*			pContextModule;
//STRIP001 	SfxWorkWindow*		pWorkWin;
//STRIP001 };

/*N*/ SvxHlinkDlgWrapper::SvxHlinkDlgWrapper( Window* pParent, USHORT nId,
/*N*/ 												SfxBindings* pBindings,
/*N*/ 												SfxChildWinInfo* pInfo ) :
/*N*/ 	SfxChildWindow( pParent, nId )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pWindow = new SvxHpLinkDlg( pParent, pBindings );
//STRIP001 	((MyStruct*)pImp)->bVisible = FALSE;
//STRIP001 
//STRIP001 	if ( pInfo->aSize.Width() != 0 && pInfo->aSize.Height() != 0 )
//STRIP001 	{
//STRIP001 		Size aParentSize( SFX_APP()->GetTopWindow()->GetSizePixel() );
//STRIP001 		Size aDlgSize (	GetSizePixel () );
//STRIP001 
//STRIP001 		if( aParentSize.Width() < pInfo->aPos.X() )
//STRIP001 			pInfo->aPos.setX( aParentSize.Width()-aDlgSize.Width() < long(0.1*aParentSize.Width()) ?
//STRIP001 			                  long(0.1*aParentSize.Width()) : aParentSize.Width()-aDlgSize.Width() );
//STRIP001 		if( aParentSize.Height() < pInfo->aPos.	Y() )
//STRIP001 			pInfo->aPos.setY( aParentSize.Height()-aDlgSize.Height() < long(0.1*aParentSize.Height()) ?
//STRIP001 			                  long(0.1*aParentSize.Height()) : aParentSize.Height()-aDlgSize.Height() );
//STRIP001 
//STRIP001 		pWindow->SetPosPixel( pInfo->aPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001 	SetHideNotDelete( TRUE );
/*N*/ }

/*N*/ SfxChildWinInfo SvxHlinkDlgWrapper::GetInfo() const
/*N*/ {
/*?*/ 	return SfxChildWindow::GetInfo();
/*N*/ }

//########################################################################
//#                                                                      #
//# Hyperlink - Dialog                                                   #
//#                                                                      #
//########################################################################

/*************************************************************************
|*
|* Contructor / Destructor
|*
|************************************************************************/

//STRIP001 SvxHpLinkDlg::SvxHpLinkDlg (Window* pParent, SfxBindings* pBindings)
//STRIP001 :	IconChoiceDialog( pParent, SVX_RES ( RID_SVXDLG_NEWHYPERLINK ) ),
//STRIP001 	maCtrl			( SID_HYPERLINK_GETLINK, *pBindings, this ),
//STRIP001 	mpBindings		( pBindings ),
//STRIP001 	mbIsHTMLDoc		( sal_False ),
//STRIP001     mbReadOnly      ( sal_False )
//STRIP001 {
//STRIP001     mbGrabFocus = sal_True;
//STRIP001 	// insert pages
//STRIP001 	Image aImage;
//STRIP001 	Image aImageHC;
//STRIP001 	String aStrTitle;
//STRIP001 	SvxIconChoiceCtrlEntry* pEntry = NULL;
//STRIP001 
//STRIP001 	aStrTitle = SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLINETTP );
//STRIP001 	aImage = Image( SVX_RES ( RID_SVXBMP_HLINETTP ) );
//STRIP001 	aImageHC = Image( SVX_RES ( RID_SVXBMP_HLINETTP_H ) );
//STRIP001 	pEntry = AddTabPage ( RID_SVXPAGE_HYPERLINK_INTERNET, aStrTitle, aImage, aImageHC, SvxHyperlinkInternetTp::Create );
//STRIP001 	pEntry->SetQuickHelpText( SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLINETTP_HELP ) );
//STRIP001 	aStrTitle = SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLMAILTP );
//STRIP001 	aImage = Image( SVX_RES ( RID_SVXBMP_HLMAILTP ) );
//STRIP001 	aImageHC = Image( SVX_RES ( RID_SVXBMP_HLMAILTP_H ) );
//STRIP001 	pEntry = AddTabPage ( RID_SVXPAGE_HYPERLINK_MAIL, aStrTitle, aImage, aImageHC, SvxHyperlinkMailTp::Create );
//STRIP001 	pEntry->SetQuickHelpText( SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLMAILTP_HELP ) );
//STRIP001 	aStrTitle = SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLDOCTP );
//STRIP001 	aImage = Image( SVX_RES ( RID_SVXBMP_HLDOCTP ) );
//STRIP001 	aImageHC = Image( SVX_RES ( RID_SVXBMP_HLDOCTP_H ) );
//STRIP001 	pEntry = AddTabPage ( RID_SVXPAGE_HYPERLINK_DOCUMENT, aStrTitle, aImage, aImageHC, SvxHyperlinkDocTp::Create );
//STRIP001 	pEntry->SetQuickHelpText( SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLDOCTP_HELP ) );
//STRIP001 	aStrTitle = SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLDOCNTP );
//STRIP001 	aImage = Image( SVX_RES ( RID_SVXBMP_HLDOCNTP ) );
//STRIP001 	aImageHC = Image( SVX_RES ( RID_SVXBMP_HLDOCNTP_H ) );
//STRIP001 	pEntry = AddTabPage ( RID_SVXPAGE_HYPERLINK_NEWDOCUMENT, aStrTitle, aImage, aImageHC, SvxHyperlinkNewDocTp::Create );
//STRIP001 	pEntry->SetQuickHelpText( SVX_RESSTR( RID_SVXSTR_HYPERDLG_HLDOCNTP_HELP ) );
//STRIP001 
//STRIP001 	// all tab pages set -> create mnemonics
//STRIP001 	//	CreateIconTextAutoMnemonics();	#99671# not useful, because this is not what user expects when using mnemonics on the pages
//STRIP001 
//STRIP001 	// create itemset for tabpages
//STRIP001 	mpItemSet = new SfxItemSet( SFX_APP()->GetPool(), SID_HYPERLINK_GETLINK,
//STRIP001 		                       SID_HYPERLINK_SETLINK );
//STRIP001 
//STRIP001 	SvxHyperlinkItem aItem;
//STRIP001 	mpItemSet->Put (aItem, SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	SetInputSet (mpItemSet);
//STRIP001 
//STRIP001 	// Init Dialog
//STRIP001 	Start (FALSE);
//STRIP001 
//STRIP001 	pBindings->Update( SID_READONLY_MODE );
//STRIP001 
//STRIP001 	// set OK/Cancel - button
//STRIP001 	GetOKButton().SetText ( SVX_RESSTR(RID_SVXSTR_HYPDLG_APPLYBUT) );
//STRIP001 	GetCancelButton().SetText ( SVX_RESSTR(RID_SVXSTR_HYPDLG_CLOSEBUT) );
//STRIP001 
//STRIP001 	GetOKButton().SetClickHdl    ( LINK ( this, SvxHpLinkDlg, ClickApplyHdl_Impl ) );
//STRIP001 	GetCancelButton().SetClickHdl( LINK ( this, SvxHpLinkDlg, ClickCloseHdl_Impl ) );
//STRIP001 }

//STRIP001 SvxHpLinkDlg::~SvxHpLinkDlg ()
//STRIP001 {
//STRIP001 	// delete config item, so the base class (IconChoiceDialog) can not load it on the next start
//STRIP001 	SvtViewOptions aViewOpt( E_TABDIALOG, String::CreateFromInt32( SID_HYPERLINK_DIALOG ) );
//STRIP001 	aViewOpt.Delete();
//STRIP001 
//STRIP001 	delete mpItemSet;
//STRIP001 }

/*************************************************************************
|*
|* Close Dialog-Window
|*
|************************************************************************/

//STRIP001 BOOL SvxHpLinkDlg::Close()
//STRIP001 {
//STRIP001 	GetDispatcher()->Execute( SID_HYPERLINK_DIALOG,
//STRIP001 		                      SFX_CALLMODE_ASYNCHRON |
//STRIP001 							  SFX_CALLMODE_RECORD);
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* When extrawindow is visible and its never moved by user, then move that
|* window, too.
|*
|************************************************************************/

//STRIP001 void SvxHpLinkDlg::Move()
//STRIP001 {
//STRIP001 	SvxHyperlinkTabPageBase* pCurrentPage = ( SvxHyperlinkTabPageBase* )
//STRIP001 		                                    GetTabPage ( GetCurPageId() );
//STRIP001 
//STRIP001 	if( pCurrentPage->IsMarkWndVisible () )
//STRIP001 	{
//STRIP001 		// Pos&Size of this dialog-window
//STRIP001 		Point aDlgPos ( GetPosPixel () );
//STRIP001 		Size aDlgSize (	GetSizePixel () );
//STRIP001 
//STRIP001 		// Size of Office-Main-Window
//STRIP001 		Size aWindowSize( SFX_APP()->GetTopWindow()->GetSizePixel() );
//STRIP001 
//STRIP001 		// Size of Extrawindow
//STRIP001 		Size aExtraWndSize( pCurrentPage->GetSizeExtraWnd() );
//STRIP001 
//STRIP001 		BOOL bDoInvalid ;
//STRIP001 		if( aDlgPos.X()+(1.02*aDlgSize.Width())+aExtraWndSize.Width() > aWindowSize.Width() )
//STRIP001 		{
//STRIP001 			if( aDlgPos.X() - ( 0.02*aDlgSize.Width() ) - aExtraWndSize.Width() < 0 )
//STRIP001 			{
//STRIP001 				// Pos Extrawindow anywhere
//STRIP001 				bDoInvalid = pCurrentPage->MoveToExtraWnd( Point( 1, long(1.1*aDlgPos.Y()) ), TRUE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Pos Extrawindow on the left side of Dialog
//STRIP001 				bDoInvalid = pCurrentPage->MoveToExtraWnd( aDlgPos -
//STRIP001 														   Point( long(0.02*aDlgSize.Width()), 0 ) -
//STRIP001 														   Point( aExtraWndSize.Width(), 0 ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Pos Extrawindow on the right side of Dialog
//STRIP001 			bDoInvalid = pCurrentPage->MoveToExtraWnd ( aDlgPos + Point( long(1.02*aDlgSize.Width()), 0 ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bDoInvalid )
//STRIP001 			Invalidate(INVALIDATE_BACKGROUND);
//STRIP001 	}
//STRIP001 
//STRIP001 	Window::Move();
//STRIP001 }

/*long SvxHpLinkDlg::PreNotify( NotifyEvent& rNEvt )
{
	long nRet = 0;

	if( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		DBG_ASSERT( rNEvt.GetKeyEvent(), "-SvxHpLinkDlg::PreNotify(): no KeyEvent for key event?!" );

        const KeyEvent* pKEvt = rNEvt.GetKeyEvent();

		if( KEY_MOD2 == pKEvt->GetKeyCode().GetModifier() && pKEvt->GetCharCode() && HandleShortCutKey( *pKEvt ) )
			nRet = 1;
	}

	if( !nRet )
		nRet = IconChoiceDialog::PreNotify( rNEvt );

	return nRet;
}*/

/*************************************************************************
|*
|* Click on Apply-button
|*
|************************************************************************/

//STRIP001 IMPL_LINK ( SvxHpLinkDlg, ClickApplyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SfxItemSet aItemSet( SFX_APP()->GetPool(), SID_HYPERLINK_GETLINK,
//STRIP001 		                 SID_HYPERLINK_SETLINK );
//STRIP001 
//STRIP001 	SvxHyperlinkTabPageBase* pCurrentPage = (SvxHyperlinkTabPageBase*)
//STRIP001 		                                    GetTabPage ( GetCurPageId() );
//STRIP001 
//STRIP001 	if ( pCurrentPage->AskApply() )
//STRIP001 	{
//STRIP001 		pCurrentPage->FillItemSet( aItemSet );
//STRIP001 
//STRIP001 		SvxHyperlinkItem *aItem = (SvxHyperlinkItem *)
//STRIP001 			                      aItemSet.GetItem (SID_HYPERLINK_SETLINK);
//STRIP001 
//STRIP001 		String aStrEmpty;
//STRIP001 		if ( aItem->GetURL() != aStrEmpty )
//STRIP001 			GetDispatcher()->Execute( SID_HYPERLINK_SETLINK, SFX_CALLMODE_ASYNCHRON |
//STRIP001 									  SFX_CALLMODE_RECORD, aItem, 0L);
//STRIP001 
//STRIP001 		( (SvxHyperlinkTabPageBase*)GetTabPage ( GetCurPageId() ) )->DoApply();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|* Click on Close-button
|*
|************************************************************************/

//STRIP001 IMPL_LINK ( SvxHpLinkDlg, ClickCloseHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|* Set Page
|*
|************************************************************************/

//STRIP001 USHORT SvxHpLinkDlg::SetPage ( SvxHyperlinkItem* pItem )
//STRIP001 {
//STRIP001 	USHORT nPageId = RID_SVXPAGE_HYPERLINK_INTERNET;
//STRIP001 
//STRIP001 	String aStrURL ( pItem->GetURL() );
//STRIP001 	INetURLObject aURL ( aStrURL );
//STRIP001 	INetProtocol eProtocolTyp = aURL.GetProtocol();
//STRIP001 
//STRIP001 	switch ( eProtocolTyp )
//STRIP001 	{
//STRIP001 		case INET_PROT_HTTP :
//STRIP001 		case INET_PROT_FTP :
//STRIP001         case INET_PROT_TELNET :
//STRIP001 			nPageId = RID_SVXPAGE_HYPERLINK_INTERNET;
//STRIP001 			break;
//STRIP001 		case INET_PROT_FILE :
//STRIP001 		case INET_PROT_POP3 :
//STRIP001 		case INET_PROT_IMAP :
//STRIP001 			nPageId = RID_SVXPAGE_HYPERLINK_DOCUMENT;
//STRIP001 			break;
//STRIP001 		case INET_PROT_MAILTO :
//STRIP001 		case INET_PROT_NEWS :
//STRIP001 			nPageId = RID_SVXPAGE_HYPERLINK_MAIL;
//STRIP001 			break;
//STRIP001 		default :
//STRIP001 			sal_Char const sNewsSrvScheme[] = "news://";
//STRIP001                 // TODO news:// is nonsense
//STRIP001 
//STRIP001             if ( aStrURL.SearchAscii( sNewsSrvScheme ) == 0 )
//STRIP001 				nPageId = RID_SVXPAGE_HYPERLINK_DOCUMENT;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				sal_Char const sHash[] = "#";
//STRIP001 				if( aStrURL.SearchAscii( sHash ) == 0 )
//STRIP001 					nPageId = RID_SVXPAGE_HYPERLINK_DOCUMENT;
//STRIP001 				else
//STRIP001 				{
//STRIP001 					eProtocolTyp = INET_PROT_NOT_VALID;
//STRIP001 					nPageId = GetCurPageId();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	ShowPage (nPageId);
//STRIP001 
//STRIP001 	SvxHyperlinkTabPageBase* pCurrentPage = (SvxHyperlinkTabPageBase*)GetTabPage( nPageId );
//STRIP001 
//STRIP001 	mbIsHTMLDoc = BOOL( pItem->GetInsertMode() & HLINK_HTMLMODE );
//STRIP001 
//STRIP001 	SfxItemSet& aPageSet =  (SfxItemSet&)GetTabPage (nPageId)->GetItemSet ();
//STRIP001 	aPageSet.Put ( *pItem );
//STRIP001 
//STRIP001 	pCurrentPage->Reset( aPageSet );
//STRIP001     if ( mbGrabFocus )
//STRIP001     {
//STRIP001     	pCurrentPage->SetInitFocus();   // #92535# grab the focus only once at initialization
//STRIP001         mbGrabFocus = sal_False;
//STRIP001     }
//STRIP001 	return nPageId;
//STRIP001 }

/*************************************************************************
|*
|* Enable/Disable to browse targets in a html-doc
|*
|************************************************************************/

//STRIP001 void SvxHpLinkDlg::EnableInetBrowse( sal_Bool bEnable )
//STRIP001 {
//STRIP001 	SvxHyperlinkTabPageBase* pCurrentPage = ( SvxHyperlinkTabPageBase* )
//STRIP001 		                                    GetTabPage ( GetCurPageId() );
//STRIP001 	pCurrentPage->SetOnlineMode( bEnable );
//STRIP001 }

/*************************************************************************
|*
|* Enable/Disable ReadOnly mode
|*
|************************************************************************/

//STRIP001 void SvxHpLinkDlg::SetReadOnlyMode( sal_Bool bRdOnly )
//STRIP001 {
//STRIP001     mbReadOnly = bRdOnly;
//STRIP001     if ( bRdOnly )
//STRIP001         GetOKButton().Disable();
//STRIP001     else
//STRIP001         GetOKButton().Enable();
//STRIP001 }

}
