/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_stbitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:44:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#pragma hdrstop

#include "stbitem.hxx"
#include "sfxtypes.hxx"
#include "stbmgr.hxx"
// auto strip #include "msg.hxx"
#include "arrdecl.hxx"
// auto strip #include "bindings.hxx"
// auto strip #include "msgdescr.hxx"
#include "msgpool.hxx"
#include "module.hxx"
#include "dispatch.hxx"

#include "sfx.hrc"
namespace binfilter {

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl::SfxStatusBarControl
/*N*/ (
/*N*/ 	USHORT		nId,				/* Slot-Id, mit der diese Instanz
									   verbunden wird. Wurde bei der
									   Registrierung eine Slot-Id != 0
									   angegeben, ist dies immer die dort
									   angegebene. */

/*N*/ 	StatusBar&	rBar,				/* Referenz auf die StatusBar, f"ur die
									   dieses Control erzeugt wurde. */
/*N*/ 	SfxBindings& rBindings			// Die Bindings dieses Controls
/*N*/ )

/*	[Beschreibung]

	Konstruktor der Klasse SfxStatusBarControl. Die Subclasses werden
	bei Bedarf per Factory vom SFx erzeugt.

	Instanzen dieser Basisklasse werden f"ur alle StatusBar-Felder
	erzeugt, f"ur die keine speziellen registriert wurden.
*/

/*N*/ :	SfxControllerItem(nId, rBindings),
/*N*/ 	pBar(&rBar)
/*N*/ {
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_STATUSBARCONFIG) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl::~SfxStatusBarControl()

/*	[Beschreibung]

	Destruktor der Klasse SfxStatusBarControl. Die Instanzen dieser
	Klasse und deren Subklassen werden vom SFx zerst"ort.
*/

/*N*/ {}

//--------------------------------------------------------------------

/*N*/ void SfxStatusBarControl::StateChanged
/*N*/ (
/*N*/ 	USHORT				nSID,
/*N*/ 	SfxItemState		eState,
/*N*/ 	const SfxPoolItem* 	pState	/* Zeiger auf ein SfxPoolItem, welches nur
								   innerhalb dieses Methodenaufrufs g"ultig
								   ist. Es kann ein 0-Pointer, ein Pointer
								   auf ein SfxVoidItem oder auf den Typ, f"ur
								   den die Subclass von SfxStatusBarControl
								   registriert ist vorkommen. */
/*N*/ )

/*	[Beschreibung]

	Die Basisimplementation versteht Items vom Type SfxStringItem, bei
	denen der Text in das Status-Zeilen-Feld eingetragen wird und
	SfxVoidItem, bei denen das Feld geleert wird. Die Basisimplementierng
	sollte in "uberladenen Methoden nicht gerufen werden.
*/

/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( pBar != 0, "setting state to dangling StatusBar" );
/*N*/ 
/*N*/ 	const SfxStringItem* pStr = PTR_CAST( SfxStringItem, pState );
/*N*/ 	if ( eState == SFX_ITEM_AVAILABLE && pStr )
/*N*/ 		pBar->SetItemText( nSID, pStr->GetValue() );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		DBG_ASSERT( eState != SFX_ITEM_AVAILABLE || pState->ISA(SfxVoidItem),
/*N*/ 					"wrong SfxPoolItem subclass in SfxStatusBarControl" );
/*N*/ 		pBar->SetItemText( nSID, String() );
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 BOOL SfxStatusBarControl::MouseButtonDown( const MouseEvent & )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode ist eine Weiterleitung des Events
//STRIP001 	MouseButtonDown() der StatusBar, falls die Maus-Position innerhalb
//STRIP001 	des Bereichs des betreffenden Items ist, oder die Maus von diesem
//STRIP001 	Control mit <SfxStatusBarControl::CaptureMouse()> gecaptured wurde.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer und gibt FALSE zur"uck.
//STRIP001 
//STRIP001 
//STRIP001 	[Rckgabewert]
//STRIP001 
//STRIP001 	BOOL				TRUE
//STRIP001 						das Event wurde bearbeitet und soll nicht an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 
//STRIP001 						FALSE
//STRIP001 						das Event wurde nicht bearbeitet und soll an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxStatusBarControl::MouseMove( const MouseEvent & )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode ist eine Weiterleitung des Events
//STRIP001 	MouseMove() der StatusBar, falls die Maus-Position innerhalb
//STRIP001 	des Bereichs des betreffenden Items ist, oder die Maus von diesem
//STRIP001 	Control mit <SfxStatusBarControl::CaptureMouse()> gecaptured wurde.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer und gibt FALSE zur"uck.
//STRIP001 
//STRIP001 
//STRIP001 	[Rckgabewert]
//STRIP001 
//STRIP001 	BOOL				TRUE
//STRIP001 						das Event wurde bearbeitet und soll nicht an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 
//STRIP001 						FALSE
//STRIP001 						das Event wurde nicht bearbeitet und soll an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxStatusBarControl::MouseButtonUp( const MouseEvent & )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode ist eine Weiterleitung des Events
//STRIP001 	MouseButtonUp() der StatusBar, falls die Maus-Position innerhalb
//STRIP001 	des Bereichs des betreffenden Items ist, oder die Maus von diesem
//STRIP001 	Control mit <SfxStatusBarControl::CaptureMouse()> gecaptured wurde.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer und gibt FALSE zur"uck.
//STRIP001 
//STRIP001 
//STRIP001 	[Rckgabewert]
//STRIP001 
//STRIP001 	BOOL				TRUE
//STRIP001 						das Event wurde bearbeitet und soll nicht an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 
//STRIP001 						FALSE
//STRIP001 						das Event wurde nicht bearbeitet und soll an
//STRIP001 						die StatusBar weitergeleitet werden
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxStatusBarControl::Command( const CommandEvent &rEvt )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode wird gerufen, wenn f"ur dieses SfxStatusBarControl
//STRIP001 	ein CommandEvent f"ur erkannt wurde.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxStatusBarControl::Click()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode wird gerufen, wenn der Anwender mit der Maus
//STRIP001 	in das zu diesem Control geh"orige Feld der Statuszeile klickt.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxStatusBarControl::DoubleClick()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode wird gerufen, wenn der Anwender mit der Maus
//STRIP001 	in das zu diesem Control geh"orige Feld der Statuszeile doppel-klickt.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	GetBindings().Execute( GetId() );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxStatusBarControl::Paint
//STRIP001 (
//STRIP001 	const UserDrawEvent& rUDEvt  /* Referenz auf einen UserDrawEvent */
//STRIP001 )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese virtuelle Methode wird gerufen, falls das betreffende Feld
//STRIP001 	mit SIB_USERDRAW gekennzeichnet ist, um den Inhalt zu zeichnen.
//STRIP001 	Die Ausgabe mu"s auf dem in durch rUDEvt.GetDevice() erh"altlichen
//STRIP001 	OutputDevice innerhalb des durch rUDEvt.GetRect() angegebenenen
//STRIP001 	Rechtecks erfolgen.
//STRIP001 
//STRIP001 	Die Defaultimplementierung ist leer.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl* SfxStatusBarControl::CreateControl
/*N*/ (
/*N*/ 	USHORT			nId,
/*N*/ 	StatusBar*		pBar,
/*N*/ 	SfxBindings&	rBindings,
/*N*/ 	SfxModule*		pMod
/*N*/ )
/*N*/ {
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	SfxSlotPool *pSlotPool;
/*N*/ 	if ( pMod )
/*N*/ 		pSlotPool = pMod->GetSlotPool();
/*N*/ 	else
/*N*/ 		pSlotPool = &pApp->GetSlotPool();
/*N*/ 	TypeId aSlotType = pSlotPool->GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxStbCtrlFactArr_Impl *pFactories = pMod->GetStbCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxStbCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 				if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 					 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 					 ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 					return rFactories[nFactory]->pCtor( nId, *pBar, rBindings );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxStbCtrlFactArr_Impl &rFactories = pApp->GetStbCtrlFactories_Impl();
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*?*/ 		if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*?*/ 			 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*?*/ 			 ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 			return rFactories[nFactory]->pCtor( nId, *pBar, rBindings );
/*N*/ 	}
/*N*/ 	return new SfxStatusBarControl( nId, *pBar, rBindings );
/*N*/ }
																														//--------------------------------------------------------------------

}
