/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cfgtreelstbox.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:23:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXCFGTREELSTBOX_HXX
#define _SFXCFGTREELSTBOX_HXX

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SVTABBX_HXX //autogen
#include <svtools/svtabbx.hxx>
#endif
#ifndef _SVTREEBOX_HXX //autogen
#include <svtools/svtreebx.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#define _SVSTDARR_USHORTS
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>		// SvUShorts
// auto strip #include "minarray.hxx"
namespace binfilter {

#define SFX_CFGGROUP_FUNCTION 1
#define SFX_CFGGROUP_BASICMGR 2
#define SFX_CFGGROUP_DOCBASICMGR 3
#define SFX_CFGGROUP_BASICLIB 4
#define SFX_CFGGROUP_BASICMOD 5
#define SFX_CFGFUNCTION_MACRO 6
#define SFX_CFGFUNCTION_SLOT  7
#define SFX_CFGFUNCTION_SEPARATOR 8
#define SFX_CFGFUNCTION_SPACE 9

#define IBX_FUNCTION_ALREADY_IN_TOOLBOX	(RID_SFX_DIALOG_START + 104 )

class SfxMacroInfoArr_Impl;
class SfxMacroInfoItem;
class SfxMacroInfo;
class SfxConfigManager;

struct SfxCfgGroupInfo_Impl
{
	USHORT 		nKind;
	USHORT 		nOrd;
	void*		pObject;
	BOOL		bWasOpened;

				SfxCfgGroupInfo_Impl( USHORT n, USHORT nr, void* pObj = 0 ) :
					nKind( n ), nOrd( nr ), pObject( pObj ), bWasOpened(FALSE) {}
};

typedef SfxCfgGroupInfo_Impl* SfxCfgGroupInfoPtr;
//STRIP001 SV_DECL_PTRARR_DEL(SfxCfgGroupInfoArr_Impl, SfxCfgGroupInfoPtr, 5, 5)//STRIP008 ;

class SfxSlotPool;
class SfxBindings;
//STRIP001 class SfxConfigTreeListBox_Impl : public SvTreeListBox
//STRIP001 {
//STRIP001 	Timer							aTimer;
//STRIP001 	SvLBoxEntry*					pCurEntry;
//STRIP001 	SfxCfgGroupInfoArr_Impl			aArr;
//STRIP001 	ULONG							nMode;
//STRIP001 	String							aScriptType;
//STRIP001 	SfxSlotPool*					pSlotPool;
//STRIP001 	SfxBindings*					pBindings;
//STRIP001 	BOOL							bDragInProgress;
//STRIP001 	BOOL							bHiContrastMode;
//STRIP001 	String							aSeparatorStr;
//STRIP001 	String							aSpaceStr;
//STRIP001 	IntlWrapper*					pIntlWrapper;
//STRIP001 
//STRIP001 	DECL_LINK(						TimerHdl, Timer* );
//STRIP001 	virtual void 					MouseMove( const MouseEvent& rMEvt );
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void    				RequestingChilds( SvLBoxEntry *pEntry);
//STRIP001 	virtual BOOL    				Expand( SvLBoxEntry* pParent );
//STRIP001 	virtual void					DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 
//STRIP001 	// new d&d
//STRIP001 	virtual DragDropMode			NotifyStartDrag( TransferDataContainer&, SvLBoxEntry* );
//STRIP001 	virtual BOOL					NotifyAcceptDrop( SvLBoxEntry* );
//STRIP001 	virtual sal_Int8				AcceptDrop( const AcceptDropEvent& rEvt );
//STRIP001 	virtual sal_Int8				ExecuteDrop( const ExecuteDropEvent& rEvt );
//STRIP001 	virtual void					DragFinished( sal_Int8 nDropAction );
//STRIP001 
//STRIP001 public:
//STRIP001 									SfxConfigTreeListBox_Impl ( Window* pParent,
//STRIP001 										const ResId&, 
//STRIP001 										SfxBindings* pBindings, 
//STRIP001 										ULONG nConfigMode = 0 );
//STRIP001 									~SfxConfigTreeListBox_Impl();
//STRIP001 
//STRIP001 	void							Init( SvStringsDtor *pArr = 0, SfxSlotPool* pSlotPool = 0 );
//STRIP001 	void							ClearAll();
//STRIP001 
//STRIP001 	void							Open( SvLBoxEntry*, BOOL );
//STRIP001 	void							GroupSelected();
//STRIP001 	String							GetGroup();
//STRIP001 	void							SetScriptType( const String& rScriptType );
//STRIP001 
//STRIP001 	SvLBoxEntry*					GetEntry_Impl( SvLBoxEntry* pParentEntry, USHORT nId );
//STRIP001 	SvLBoxEntry*					GetEntry_Impl( SvLBoxEntry* pParentEntry, const String& );
//STRIP001 
//STRIP001 	SvLBoxEntry*					GetEntry_Impl( USHORT nId );
//STRIP001 	SvLBoxEntry*					GetEntry_Impl( const String& );
//STRIP001 
//STRIP001 	USHORT							GetId( SvLBoxEntry *pEntry );
//STRIP001 	String							GetHelpText( SvLBoxEntry *pEntry );
//STRIP001 	USHORT							GetCurId()
//STRIP001 									{ return GetId( FirstSelected() ); }
//STRIP001 	SfxMacroInfo*					GetMacroInfo();
//STRIP001 	void							FunctionSelected();
//STRIP001 
//STRIP001 	DECL_LINK( SpecialCompare, SvSortData* );
//STRIP001 };

struct SfxToolbarEntryInfo_Impl
{
	BOOL			bVisible;
	USHORT 			nId;
	ToolBoxItemType	nKind;
	SfxMacroInfo*	pMacroInfo;

	SfxToolbarEntryInfo_Impl( ToolBoxItemType n, USHORT nID, BOOL bVis = TRUE, SfxMacroInfo* pInfo = 0 ) : 
		nKind( n ), nId( nID ), bVisible( bVis ), pMacroInfo( pInfo ) {}
};

typedef SfxToolbarEntryInfo_Impl* SfxToolbarEntryInfoPtr;
SV_DECL_PTRARR_DEL(SfxToolbarEntryInfoArr_Impl, SfxToolbarEntryInfoPtr, 5, 5)//STRIP008 ;

class SfxToolBoxManager;
class SfxBindings;
class SfxInterface;
class SfxToolbarTreeListBox_Impl : public SvTreeListBox
{
	Timer							m_aTimer;
	SvLBox*							m_pSVLBoxFunctions;
	SvLBoxEntry*					m_pCurEntry;
	SfxToolbarEntryInfoArr_Impl		m_aArr;
	SfxToolBoxManager*				m_pTbxMgr;
	SfxBindings*					m_pBindings;
	SfxInterface*					m_pIFace;
	BOOL							m_bDragSource;
	Size							m_aCheckBoxImageSizePixel;
	String							m_aSeparator;
	String							m_aSpace;
	Link							m_aChangedListener;
	SvLBoxButtonData*				m_pButtonData;
	BOOL							m_bHiContrastMode;

	DECL_LINK(						TimerHdl, Timer* );
	DECL_LINK(						AsyncInfoMsg, String* );

	virtual void 					MouseMove( const MouseEvent& rMEvt );
	virtual void					KeyInput( const KeyEvent& rKEvt );
	void							CommitChanges();
	USHORT							FindToolBoxPosition( const ToolBox& rToolBox, ULONG nPos );

protected:
	// new d&d
	virtual DragDropMode			NotifyStartDrag( TransferDataContainer&, SvLBoxEntry* );
	virtual BOOL					NotifyAcceptDrop( SvLBoxEntry* );
	virtual sal_Int8				AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8				ExecuteDrop( const ExecuteDropEvent& rEvt );
	virtual void					DragFinished( sal_Int8 nDropAction );
	virtual BOOL					NotifyMoving( SvLBoxEntry*  pTarget,
												  SvLBoxEntry*  pEntry,
												  SvLBoxEntry*& rpNewParent,
												  ULONG&		rNewChildPos );
	virtual BOOL					NotifyCopying( SvLBoxEntry*  pTarget,		 
												   SvLBoxEntry*  pEntry,		 
												   SvLBoxEntry*& rpNewParent,   
												   ULONG&        rNewChildPos );
	virtual void					CheckButtonHdl();
	virtual void					InitEntry( SvLBoxEntry*, const XubString&, const Image&, const Image& );
	virtual void					DataChanged( const DataChangedEvent& rDCEvt );
	void							BuildCheckBoxButtonImages( SvLBoxButtonData* );
	Image							GetSizedImage( VirtualDevice& aDev, const Size& aNewSize, const Image& aImage );

public:
									SfxToolbarTreeListBox_Impl ( Window* pParent, const ResId&, SfxBindings* pBindings );
									~SfxToolbarTreeListBox_Impl();
	
	void							Init( SfxToolBoxManager*, SfxInterface* pIFace, SfxSlotPool* pSlotPool = 0 );
	void							SetChangedListener( const Link& aChangedListener ) { m_aChangedListener = aChangedListener; }
	const Link&						GetChangedListener() const { return m_aChangedListener; }
	void							SetDragSourcePartner( SvLBox* pDragSourcePartner ) { m_pSVLBoxFunctions = pDragSourcePartner; }
	void							ClearAll();

	Size							GetCheckBoxPixelSize() const { return m_aCheckBoxImageSizePixel; }
	BOOL							RemoveItem( SvLBoxEntry* pEntry );
	BOOL							AddFunction( SvLBoxEntry* pEntry, USHORT nKind, USHORT nId, SfxMacroInfo* pMacroInfo, BOOL bFront = FALSE);
	void							AddSeparator( SvLBoxEntry* pEntry, ToolBoxItemType nType, BOOL bFront = FALSE );
	void							MoveUpCurEntry();
	void							MoveDownCurEntry();

	BOOL							GetPos( ULONG& nPos, SvLBoxEntry* pEntry );
	USHORT							GetId( SvLBoxEntry *pEntry );
	String							GetHelpText( SvLBoxEntry *pEntry );
	USHORT							GetCurId()
									{ return GetId( FirstSelected() ); }
};


}//end of namespace binfilter
#endif // _SFXCFGTREELSTBOX_HXX
