/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_schview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:16:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SOT_EXCHANGE_HXX //autogen
// auto strip #include <sot/exchange.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SOT_FORMATS_HXX //autogen
// auto strip #include <sot/formats.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XLNCLIT_HXX //autogen
// auto strip #include <bf_svx/xlnclit.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XFLCLIT_HXX //autogen
// auto strip #include <bf_svx/xflclit.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOOLE2_HXX //autogen
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
// auto strip #include <svtools/zforlist.hxx>
#endif
// auto strip #ifndef _SV_GRAPH_HXX //autogen
// auto strip #include <vcl/graph.hxx>
// auto strip #endif
// auto strip #ifndef _STRING_HXX //autogen wg. String
// auto strip #include <tools/string.hxx>
// auto strip #endif
// header for class INetURLObject
// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// header for class Svx3DChildWindow
// auto strip #ifndef _SVX_F3DCHILD_HXX
// auto strip #include <bf_svx/f3dchild.hxx>
// auto strip #endif

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "schview.hxx"
#include "schmod.hxx"
#include "schresid.hxx"
#include "chwindow.hxx"
// auto strip #include "docshell.hxx"
#include "objid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
// auto strip #include "uninstit.hxx"
// auto strip #include "uninsleg.hxx"
// auto strip #include "unmultdp.hxx"
// auto strip #include "viewshel.hxx"
#include "strings.hrc"
#include "glob.hrc"
// auto strip #include "schgroup.hxx"
// auto strip #include "eetext.hxx"
// auto strip #include "docshell.hxx"
#include "viewshel.hxx"
// auto strip #include "chaxis.hxx"
// auto strip #include "axisobj.hxx"
#include "memchrt.hxx"
#include "SchTransferable.hxx"
// auto strip #include "guiutil.hxx"
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

/*************************************************************************
|*
|* Konstruktor 1
|*
\************************************************************************/

/*N*/ SchView::SchView(SchChartDocShell* pDocShell,
/*N*/ 				 OutputDevice* pOutDev,
/*N*/ 				 SchViewShell* pViewShell)
/*N*/   : E3dView(&pDocShell->GetDoc(), pOutDev),
/*N*/ 	pDoc(&pDocShell->GetDoc()),
/*N*/ 	pDocSh(pDocShell),
/*N*/ 	pViewSh(pViewShell),
/*N*/ 	bDragActive (FALSE),
/*N*/ 	nLogicalMarked(FALSE),
/*N*/ 	nLogicalEntered(FALSE)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

/*************************************************************************
|*
|* Konstruktor 2
|*
\************************************************************************/

//STRIP001 SchView::SchView(ChartModel* pDocument,
//STRIP001 				 OutputDevice* pOutDev)
//STRIP001   : E3dView(pDocument, pOutDev),
//STRIP001 	pDoc(pDocument),
//STRIP001 	pDocSh(NULL),
//STRIP001 	pViewSh(NULL),
//STRIP001 	bDragActive (FALSE),
//STRIP001 	nLogicalMarked(FALSE),
//STRIP001 	nLogicalEntered(FALSE)
//STRIP001 {
//STRIP001 	Construct();
//STRIP001 }

/*************************************************************************
|*
|* Construct
|*
\************************************************************************/

/*N*/ void SchView::Construct()
/*N*/ {
/*N*/ 	SetUseIncompatiblePathCreateInterface(TRUE);
/*N*/ 
/*N*/ 	OutputDevice* pOut = GetWin(0);
/*N*/ 
/*N*/ 	if( pOut )
/*N*/ 		SetMinMoveDistancePixel( (USHORT)pOut->PixelToLogic( Size( 2, 0 )).Width());
/*N*/ 
/*N*/ 	SetHitTolerancePixel (2);
/*N*/ 	EnableExtendedKeyInputDispatcher (FALSE);
/*N*/ 	EnableExtendedMouseEventDispatcher (FALSE);
/*N*/ 	EnableExtendedCommandEventDispatcher (FALSE);
/*N*/ 	bBordVisible = FALSE;
/*N*/ 
/*N*/ 	if (pDocSh && pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED)
/*N*/ 		bPageVisible = FALSE;
/*N*/ 
/*N*/ 	bGlueVisible  =
/*N*/ 	bGlueVisible2 =
/*N*/ 	bGlueVisible3 = TRUE;
/*N*/ 	SetCurrentObj(OBJ_RECT, SdrInventor);
/*N*/ 
/*N*/ 	if (pDoc->GetPageCount() == 0L)
/*N*/ 	{
/*N*/ 		// Seite einfuegen
/*?*/ 		BOOL bChanged = pDoc->IsChanged();
/*?*/ 		SdrPage* pPage = pDoc->AllocPage(FALSE);
/*?*/ 
/*?*/ 		if (pDocSh)
/*?*/ 			pPage->SetSize(pDocSh->GetVisArea(ASPECT_CONTENT).GetSize());
/*?*/ 
/*?*/ 		pDoc->InsertPage(pPage);
/*?*/ 		pDoc->BuildChart(FALSE);
/*?*/ 		pDoc->SetChanged(bChanged);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchView::~SchView()
/*N*/ {
/*N*/     // release content of selection clipboard, if we own the content
/*N*/     UpdateSelectionClipboard( TRUE );
/*N*/ 
/*N*/ 	aTimer.Stop();
/*N*/ 	for (USHORT nWin = 0; nWin < GetWinCount(); nWin++)
/*N*/ 	{
/*N*/ 		OutputDevice* pOutDev = GetWin(nWin);
/*N*/ 
/*N*/ 		if (pOutDev->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 			DelWin((SchWindow*)pOutDev);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, der die anfallenden Undo-Aktionen
|* uebergeben werden
|*
\************************************************************************/

//STRIP001 BOOL SchView::NotifyNewUndoAction()
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

/*N*/ void SchView::MarkListHasChanged()
/*N*/ {
/*N*/ 	E3dView::MarkListHasChanged();
/*N*/ 	if ( pViewSh )
/*N*/ 		pViewSh->SelectionHasChanged();
/*N*/ 
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SchView, NotifySelection) );
/*N*/ 	// Timer reset
/*N*/ 	aTimer.SetTimeout(100);
/*N*/ 	aTimer.Start();
/*N*/ }

/*************************************************************************
|*
|* Entfernt Chart-Userdaten
|*
\************************************************************************/

//STRIP001 void SchView::DeleteChartUserData(ChartModel& rDoc)
//STRIP001 {
//STRIP001 	SdrPage* pPage = rDoc.GetPage(0);
//STRIP001 	DBG_ASSERT(pPage, "Keine Seite vorhanden!");
//STRIP001 
//STRIP001 	SdrObjListIter aIterator(*pPage, IM_DEEPWITHGROUPS);
//STRIP001 	while (aIterator.IsMore())
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aIterator.Next();
//STRIP001 
//STRIP001 		USHORT nPos = 0;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			SdrObjUserData *pData = pObj->GetUserData(nPos);
//STRIP001 
//STRIP001 			if (pData)
//STRIP001 				switch (pData->GetId())
//STRIP001 				{
//STRIP001 					case SCH_LIGHTFACTOR_ID:
//STRIP001 						DBG_ERROR("SCH_LIGHTFACTOR_ID ist im Chart abgeschafft!");
//STRIP001 					case SCH_OBJECTID_ID:
//STRIP001 					case SCH_OBJECTADJUST_ID:
//STRIP001 					case SCH_DATAROW_ID:
//STRIP001 					case SCH_DATAPOINT_ID:
//STRIP001 						pObj->DeleteUserData(nPos);
//STRIP001 						break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						nPos++;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				nPos++;
//STRIP001 		}
//STRIP001 		while (nPos < pObj->GetUserDataCount());
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

//STRIP001 BOOL SchView::DoCut(Window* pWindow)
//STRIP001 {
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pDocSh->IsReadOnly())
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 		((OutlinerView*)pOLV)->Cut();
//STRIP001 	else if( HasMarkedObj() && CanDeleteMarkedObjects())
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 
//STRIP001 		DoCopy();
//STRIP001 		DeleteMarkedObjects( String( SchResId( STR_UNDO_CUT )));
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

//STRIP001 void SchView::DoCopy(Window* pWindow)
//STRIP001 {
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 		( (OutlinerView*) pOLV)->Copy();
//STRIP001 	else if( HasMarkedObj())
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 		CreateClipboardDataObject();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

//STRIP001 void SchView::DoPaste(Window* pWindow)
//STRIP001 {
//STRIP001 	if( pDocSh->IsReadOnly())
//STRIP001 		return;
//STRIP001 
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 	{
//STRIP001 		((OutlinerView*)pOLV)->PasteSpecial();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Point aPos;
//STRIP001 		SchTransferable* pTransferClip = SCH_MOD1()->GetClipboardTransferable();
//STRIP001 
//STRIP001 		if( pWindow )
//STRIP001 			aPos = pWindow->PixelToLogic( Rectangle( aPos, pWindow->GetOutputSizePixel()).Center());
//STRIP001 
//STRIP001 		if( pTransferClip )
//STRIP001 		{
//STRIP001 			TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWindow ));
//STRIP001 
//STRIP001 			if( aDataHelper.GetTransferable().is())
//STRIP001 				InsertData( aDataHelper, aPos, DND_ACTION_COPY, FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Texteingabe beginnen
|*
\************************************************************************/

//STRIP001 FASTBOOL SchView::BegTextEdit(SdrObject* pObj, SdrPageView* pPV, Window* pWin,
//STRIP001 							  FASTBOOL bIsNewObj, SdrOutliner* pGivenOutliner,
//STRIP001 							  OutlinerView* pGivenOutlinerView,
//STRIP001 							  FASTBOOL bDontDeleteOutliner,
//STRIP001 							  FASTBOOL bOnlyOneView)
//STRIP001 {
//STRIP001 	BOOL bReturn =
//STRIP001 				E3dView::BegTextEdit(pObj, pPV, pWin, bIsNewObj, pGivenOutliner,
//STRIP001 							 pGivenOutlinerView, bDontDeleteOutliner,
//STRIP001 							 bOnlyOneView);
//STRIP001 
//STRIP001 	if (bReturn)
//STRIP001 	{
//STRIP001 		// set undo manager at topmost shell ( SdDrawTextObjectBar )
//STRIP001 		SdrOutliner* pOutliner = GetTextEditOutliner();
//STRIP001 		if( pViewSh )
//STRIP001 			pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->
//STRIP001 				SetUndoManager(&pOutliner->GetUndoManager());
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* Texteingabe beenden
|*
\************************************************************************/

//STRIP001 SdrEndTextEditKind SchView::EndTextEdit()
//STRIP001 {
//STRIP001 	SdrEndTextEditKind eKind = E3dView::EndTextEdit( TRUE );
//STRIP001 
//STRIP001 	// UndoManager an der obersten Shell setzen
//STRIP001 	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
//STRIP001 	SfxUndoManager* pUndoMgr = pDocShell->GetUndoManager();
//STRIP001 
//STRIP001 	SfxShell* pTopMostShell = NULL;
//STRIP001 	if( pViewSh )
//STRIP001 		pTopMostShell = pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 );
//STRIP001 
//STRIP001 	if( pTopMostShell->ISA( SchViewShell ))
//STRIP001 	{
//STRIP001 		pTopMostShell->SetUndoManager( pUndoMgr );
//STRIP001 	}
//STRIP001 	Window& rWin = (Window&)(*GetWin( 0 ));
//STRIP001 	Rectangle aAll = Rectangle( 0, 0, 0, 0 );
//STRIP001 	aAll.SetSize( rWin.GetOutputSize() );
//STRIP001 	MakeVisible( aAll, rWin );
//STRIP001 
//STRIP001 	return eKind;
//STRIP001 }

/*************************************************************************
|*
|* Ermittelt, ob Chart-Objekt selektiert ist
|*
\************************************************************************/

//STRIP001 BOOL SchView::IsChartObjSelected()
//STRIP001 {
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 
//STRIP001 		for (ULONG i = 0; i < nCount; i++)
//STRIP001 			if (GetObjectId(*aMark.GetMark(i)->GetObj()))
//STRIP001 				return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* Prueft, ob Objekte geloescht werden koennen
|*
\************************************************************************/

//STRIP001 BOOL SchView::CanDeleteMarkedObjects()
//STRIP001 {
//STRIP001 
//STRIP001 	if(pDocSh->IsReadOnly())return FALSE;
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 
//STRIP001 		for (ULONG i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			SchObjectId* pId = GetObjectId(*aMark.GetMark(i)->GetObj());
//STRIP001 			if (pId)
//STRIP001 			{
//STRIP001 				if (nCount > 1)
//STRIP001 					return FALSE;
//STRIP001 
//STRIP001 				switch (pId->GetObjId())
//STRIP001 				{
//STRIP001 					case CHOBJID_TITLE_MAIN:
//STRIP001 					case CHOBJID_TITLE_SUB:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 					case CHOBJID_LEGEND:
//STRIP001 						return TRUE;
//STRIP001 
//STRIP001 					default:
//STRIP001 						return FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* Loescht ggf. markierte Objekte;
|* Liefert FALSE, wenn ein markiertes Chart-Objekt nicht geloescht
|* werden konnte.
|*
\************************************************************************/

//STRIP001 BOOL SchView::DeleteMarkedObjects(const String& rUndoStr)
//STRIP001 {
//STRIP001 	if(pDocSh->IsReadOnly())return FALSE;
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 
//STRIP001 		for (ULONG i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			SchObjectId* pId = GetObjectId(*aMark.GetMark(i)->GetObj());
//STRIP001 			if (pId)
//STRIP001 			{
//STRIP001 				if (nCount > 1)
//STRIP001 					return FALSE;
//STRIP001 
//STRIP001 				UINT16 nId = pId->GetObjId();
//STRIP001 
//STRIP001 				switch (nId)
//STRIP001 				{
//STRIP001 					case CHOBJID_TITLE_MAIN:
//STRIP001 					case CHOBJID_TITLE_SUB:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 					{
//STRIP001 						BOOL bOldShowMain   = pDoc->ShowMainTitle();
//STRIP001 						String aOldMain     = pDoc->MainTitle();
//STRIP001 						BOOL bOldShowSub    = pDoc->ShowSubTitle();
//STRIP001 						String aOldSub      = pDoc->SubTitle();
//STRIP001 						BOOL bOldShowXAxis  = pDoc->ShowXAxisTitle();
//STRIP001 						String aOldXAxis    = pDoc->XAxisTitle();
//STRIP001 						BOOL bOldShowYAxis  = pDoc->ShowYAxisTitle();
//STRIP001 						String aOldYAxis    = pDoc->YAxisTitle();
//STRIP001 						BOOL bOldShowZAxis  = pDoc->ShowZAxisTitle();
//STRIP001 						String aOldZAxis    = pDoc->ZAxisTitle();
//STRIP001 
//STRIP001 						BOOL bNewShowMain	= (nId == CHOBJID_TITLE_MAIN) ?
//STRIP001 											  FALSE : bOldShowMain;
//STRIP001 						BOOL bNewShowSub	= (nId == CHOBJID_TITLE_SUB) ?
//STRIP001 											  FALSE : bOldShowSub;
//STRIP001 						BOOL bNewShowXAxis	= (nId == CHOBJID_DIAGRAM_TITLE_X_AXIS) ?
//STRIP001 											  FALSE : bOldShowXAxis;
//STRIP001 						BOOL bNewShowYAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Y_AXIS) ?
//STRIP001 											  FALSE : bOldShowYAxis;
//STRIP001 						BOOL bNewShowZAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Z_AXIS) ?
//STRIP001 											  FALSE : bOldShowZAxis;
//STRIP001 
//STRIP001 						pDoc->ChangeTitle(bNewShowMain, aOldMain,
//STRIP001 											bNewShowSub, aOldSub,
//STRIP001 											bNewShowXAxis, aOldXAxis,
//STRIP001 											bNewShowYAxis, aOldYAxis,
//STRIP001 											bNewShowZAxis, aOldZAxis);
//STRIP001 
//STRIP001 						SchUndoInsertTitle* pUndo =
//STRIP001 							new SchUndoInsertTitle(*pDoc, bOldShowMain,
//STRIP001 												   aOldMain, bOldShowSub,
//STRIP001 												   aOldSub, bOldShowXAxis,
//STRIP001 												   aOldXAxis, bOldShowYAxis,
//STRIP001 												   aOldYAxis, bOldShowZAxis,
//STRIP001 												   aOldZAxis,
//STRIP001 												   bNewShowMain, aOldMain,
//STRIP001 												   bNewShowSub, aOldSub,
//STRIP001 												   bNewShowXAxis, aOldXAxis,
//STRIP001 												   bNewShowYAxis, aOldYAxis,
//STRIP001 												   bNewShowZAxis, aOldZAxis);
//STRIP001 						pUndo->SetComment(rUndoStr);
//STRIP001 
//STRIP001 						pDoc->GetObjectShell()->
//STRIP001 							GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 						return TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					case CHOBJID_LEGEND:
//STRIP001 					{
//STRIP001 						SfxItemSet aAttr = pDoc->GetLegendAttr();
//STRIP001 						const SfxPoolItem *pPoolItem = NULL;
//STRIP001 						BOOL bVisible = pDoc->GetShowLegend ();
//STRIP001 						SvxChartLegendPos eOldPos =	(aAttr.GetItemState(SCHATTR_LEGEND_POS,
//STRIP001 																		TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 														? ((const SvxChartLegendPosItem*)pPoolItem)->GetValue()
//STRIP001 														: CHLEGEND_NONE;
//STRIP001 						aAttr.Put(SvxChartLegendPosItem(CHLEGEND_NONE));
//STRIP001 						pDoc->SetShowLegend (FALSE);
//STRIP001 						pDoc->ChangeLegendAttr(aAttr);//, TRUE);
//STRIP001 						SchUndoInsertLegend* pUndo = new SchUndoInsertLegend(*pDoc, eOldPos, CHLEGEND_NONE,
//STRIP001 																			 bVisible, FALSE);
//STRIP001 						pUndo->SetComment(rUndoStr);
//STRIP001 
//STRIP001 						pDoc->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 						return TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					default:
//STRIP001 						return FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		DeleteMarked();
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* Ermittelt, ob Daten-Reihen/Punkt-Attribute gesetzt werden koennen
|*
\************************************************************************/

//STRIP001 BOOL SchView::CanSetDataAttr()
//STRIP001 {
//STRIP001 	if (HasMarkedObj() && aMark.GetMarkCount() == 1)
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aMark.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 		return GetDataRow(*pObj) || GetDataPoint(*pObj);
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* Verschiebt die markierten Objekte an den angegebenen Objekt-Index
|*
\************************************************************************/

//STRIP001 void SchView::PutMarkedToPos(ULONG nObjPos)
//STRIP001 {
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 
//STRIP001 		for (ULONG i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			SdrObject*	pObj = aMark.GetMark(i)->GetObj();
//STRIP001 			SdrObjList* pList = pObj->GetObjList();
//STRIP001 			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
//STRIP001 			pList->SetObjectOrdNum(pObj->GetOrdNum(), nObjPos++);
//STRIP001 			MarkListHasChanged();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Verschiebt die markierten Objekte um eine Indexposition zum
|* angegebenen Objekt-Index
|*
\************************************************************************/

//STRIP001 void SchView::MovMarkedToPos(ULONG nObjPos)
//STRIP001 {
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 
//STRIP001 		for (ULONG i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			SdrObject*	pObj = aMark.GetMark(i)->GetObj();
//STRIP001 			SdrObjList* pList = pObj->GetObjList();
//STRIP001 			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
//STRIP001 			ULONG nIndex = pObj->GetOrdNum();
//STRIP001 			if (nIndex	> nObjPos)
//STRIP001 			{
//STRIP001 				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex - 1);
//STRIP001 				MarkListHasChanged();
//STRIP001 			}
//STRIP001 			else if (nIndex < nObjPos)
//STRIP001 			{
//STRIP001 				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex + 1);
//STRIP001 				MarkListHasChanged();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Kontext-String fuer Statusbar
|*
\************************************************************************/

/*?*/ String SchView::GetContext()
/*?*/ {{DBG_BF_ASSERT(0, "STRIP"); String aResult; return aResult;}//STRIP001 
//STRIP001 	SdrObject	 *pObj  = NULL;
//STRIP001 	SchDataRow	 *pRow  = NULL;
//STRIP001 	SchDataPoint *pPoint= NULL;
//STRIP001 
//STRIP001 	long nSubRow=-1;
//STRIP001 	String aResult( SchResId( STR_MARKED ));
//STRIP001 
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		ULONG nCount = aMark.GetMarkCount();
//STRIP001 		if (nCount >= 1)//>=, da im 3D alle Unterobjekte markiert
//STRIP001 		{
//STRIP001 			pObj=aMark.GetMark(0)->GetObj();
//STRIP001 			SchObjectId* pId = GetObjectId(*pObj);
//STRIP001 			if (pId)
//STRIP001 			{
//STRIP001 				USHORT nId = GuiUtilities::GetObjectNameResId(pId->GetObjId(), *pDoc);
//STRIP001 
//STRIP001 				if(STR_DIAGRAM_ROW == nId)
//STRIP001 				{
//STRIP001 					pRow = GetDataRow(*pObj);
//STRIP001 					if(!pRow)
//STRIP001 					{
//STRIP001 						pPoint  = GetDataPoint(*pObj);
//STRIP001 						nSubRow = pPoint->GetRow();
//STRIP001 						pPoint  = NULL;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if(STR_STATUS_DATAPOINT_MARKED==nId)
//STRIP001 					pPoint = GetDataPoint(*pObj);
//STRIP001 
//STRIP001 				if (nId != 0)
//STRIP001 				{
//STRIP001 					if(pRow)
//STRIP001 					{
//STRIP001 						SchResId aSchResId(nId);
//STRIP001 						String aStrObj( aSchResId );
//STRIP001 						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( pRow->GetRow() + 1 ));
//STRIP001 						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
//STRIP001 						return aResult;
//STRIP001 					}
//STRIP001 					else if(nSubRow!=-1) //3D-Unterobjekte
//STRIP001 					{
//STRIP001 						SchResId aSchResId(nId);
//STRIP001 						String aStrObj( aSchResId );
//STRIP001 						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( nSubRow + 1 ));
//STRIP001 						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
//STRIP001 						return aResult;
//STRIP001 					}
//STRIP001 					if(pPoint)
//STRIP001 					{
//STRIP001 						long nCol=pPoint->GetCol();
//STRIP001 						long nRow=pPoint->GetRow();
//STRIP001 						String aText;
//STRIP001 						long nUId=((const SfxInt32Item&)pDoc->GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue();
//STRIP001 						ChartAxis *pAxis=pDoc->GetAxisByUID(nUId);
//STRIP001 						long nNumf=pAxis->GetNumFormat(FALSE);
//STRIP001 
//STRIP001 						Color* pDummy = NULL;
//STRIP001 						pDoc->GetNumFormatter()->GetOutputString(
//STRIP001 							pDoc->GetData(nCol,nRow),nNumf,aText,&pDummy);
//STRIP001 
//STRIP001 						aResult = String( SchResId( STR_STATUS_DATAPOINT_MARKED ));
//STRIP001 						aResult.SearchAndReplaceAscii( "$(PT_NUM)",  String::CreateFromInt32( nCol + 1 ) );
//STRIP001 						aResult.SearchAndReplaceAscii( "$(ROW_NUM)", String::CreateFromInt32( nRow + 1 ) );
//STRIP001 						aResult.SearchAndReplaceAscii( "$(VALUE)",   aText );
//STRIP001 
//STRIP001 						return  aResult;
//STRIP001 					}
//STRIP001 
//STRIP001 					aResult.SearchAndReplaceAscii( "$(OBJ)", String( SchResId( nId )) );
//STRIP001 					return  aResult;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return E3dView::GetStatusText();
/*?*/ }

/*************************************************************************
|*
|* Kontext-Typ-String fuer Statusbar
|*
\************************************************************************/

/*N*/ String SchView::GetContextType()
/*N*/ {
/*N*/ 	USHORT nDimId, nTypeId, nVariantId;
/*N*/ 	String aString;
/*N*/ 
/*N*/ 	switch (pDoc->ChartStyle())
/*N*/ 	{
/*N*/ 		case CHSTYLE_2D_LINE:
/*N*/ 			nDimId		= STR_2D;
/*N*/ 			nTypeId		= STR_LINES;
/*N*/ 			nVariantId	= STR_NORMAL;
/*N*/ 			break;
/*N*/ 
/*?*/ 		case CHSTYLE_2D_STACKEDLINE:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_LINES;
/*?*/ 			nVariantId	= STR_STACKED;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_PERCENTLINE:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_LINES;
/*?*/ 			nVariantId	= STR_PERCENT;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_COLUMN:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_NORMAL;
/*?*/ 			break;

/*?*/ 		case CHSTYLE_2D_STACKEDCOLUMN:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_STACKED;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_PERCENTCOLUMN:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_PERCENT;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_BAR:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_BARS;
/*?*/ 			nVariantId	= STR_NORMAL;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_STACKEDBAR:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_BARS;
/*?*/ 			nVariantId	= STR_STACKED;
/*?*/ 			break;
/*?*/ 
/*?*/ 		case CHSTYLE_2D_PERCENTBAR:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_BARS;
/*?*/ 			nVariantId	= STR_PERCENT;
/*?*/ 			break;

/*N*/ 		case CHSTYLE_2D_AREA:
/*N*/ 			nDimId		= STR_2D;
/*N*/ 			nTypeId		= STR_AREAS;
/*N*/ 			nVariantId	= STR_NORMAL;
/*N*/ 			break;

/*?*/ 		case CHSTYLE_2D_STACKEDAREA:
/*?*/ 			nDimId		= STR_2D;
/*?*/ 			nTypeId		= STR_AREAS;
/*?*/ 			nVariantId	= STR_STACKED;
/*?*/ 			break;

/*N*/ 		case CHSTYLE_2D_PERCENTAREA:
/*N*/ 			nDimId		= STR_2D;
/*N*/ 			nTypeId		= STR_AREAS;
/*N*/ 			nVariantId	= STR_PERCENT;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case CHSTYLE_2D_PIE:
/*N*/ 			nDimId		= STR_2D;
/*N*/ 			nTypeId		= STR_CIRCLES;
/*N*/ 			nVariantId	= STR_NORMAL;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case CHSTYLE_3D_STRIPE:
/*N*/ 			nDimId		= STR_3D;
/*N*/ 			nTypeId		= STR_LINES;
/*N*/ 			nVariantId	= STR_DEEP;
/*N*/ 			break;

/*?*/ 		case CHSTYLE_3D_COLUMN:
/*?*/ 			nDimId		= STR_3D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_DEEP;
/*?*/ 			break;

/*N*/ 		case CHSTYLE_3D_FLATCOLUMN:
/*N*/ 			nDimId		= STR_3D;
/*N*/ 			nTypeId		= STR_COLUMNS;
/*N*/ 			nVariantId	= STR_NORMAL;
/*N*/ 			break;

/*?*/ 		case CHSTYLE_3D_STACKEDFLATCOLUMN:
/*?*/ 			nDimId		= STR_3D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_STACKED;
/*?*/ 			break;

/*?*/ 		case CHSTYLE_3D_PERCENTFLATCOLUMN:
/*?*/ 			nDimId		= STR_3D;
/*?*/ 			nTypeId		= STR_COLUMNS;
/*?*/ 			nVariantId	= STR_PERCENT;
/*?*/ 			break;

/*N*/ 		case CHSTYLE_3D_AREA:
/*N*/ 			nDimId		= STR_3D;
/*N*/ 			nTypeId		= STR_AREAS;
/*N*/ 			nVariantId	= STR_DEEP;
/*N*/ 			break;

/*N*/ 		case CHSTYLE_3D_STACKEDAREA:
/*N*/ 			nDimId		= STR_3D;
/*N*/ 			nTypeId		= STR_AREAS;
/*N*/ 			nVariantId	= STR_STACKED;
/*N*/ 			break;

/*?*/ 		case CHSTYLE_3D_PERCENTAREA:
/*?*/ 			nDimId		= STR_3D;
/*?*/ 			nTypeId		= STR_AREAS;
/*?*/ 			nVariantId	= STR_PERCENT;
/*?*/ 			break;

/*N*/ 		case CHSTYLE_3D_PIE:
/*N*/ 			nDimId		= STR_3D;
/*N*/ 			nTypeId		= STR_CIRCLES;
/*N*/ 			nVariantId	= STR_NORMAL;
/*N*/ 			break;
/*N*/ 
/*N*/ 		default:
/*N*/ 			return aString;
/*N*/ 	}
/*N*/ 
/*N*/ 	aString += String(SchResId(nDimId));
/*N*/ 	aString += String(SchResId(nTypeId));
/*N*/ 	aString += sal_Unicode( ' ' );
/*N*/ 	aString += String(SchResId(nVariantId));
/*N*/ 
/*N*/ 	return aString;
/*N*/ }

/*************************************************************************
|*
|* DragServer starten
|*
\************************************************************************/

//STRIP001 BOOL SchView::BeginDrag( Window* pWindow, Point aStartPos )
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if( HasMarkedObj())
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 
//STRIP001 		SdrMarkList aMarkList( GetMarkList());
//STRIP001 
//STRIP001 		CreateDragDropDataObject( this, *pWindow, aStartPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

//STRIP001 BOOL SchView::InsertGraphic( const Graphic& rGraphic, const Point& rPos )
//STRIP001 {
//STRIP001 	/**********************************************************************
//STRIP001 	* Es wird ein neues Objekt erzeugt
//STRIP001 	**********************************************************************/
//STRIP001 	const SdrPage*	pPage = GetPageViewPvNum( 0 )->GetPage();
//STRIP001 	const MapMode	aMap100( MAP_100TH_MM );
//STRIP001 	Size			aPageSize( pPage->GetSize() );
//STRIP001 	Size			aSize;
//STRIP001 
//STRIP001 	// Falls der PrefMapMode der Graphic MAP_PIXEL ist,
//STRIP001 	// machen wir die logische Umrechnung ueber das Fenster,
//STRIP001 	// um eine 1:1-Abbildung auf Pixel zu erreichen
//STRIP001 	OutputDevice* pOut = GetWin( 0 );
//STRIP001 	if( pOut && rGraphic.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
//STRIP001 		aSize = pOut->PixelToLogic( rGraphic.GetPrefSize(), aMap100 );	// #67730#
//STRIP001 	else
//STRIP001 		aSize = OutputDevice::LogicToLogic( rGraphic.GetPrefSize(), rGraphic.GetPrefMapMode(), aMap100 );
//STRIP001 
//STRIP001 	// Groesse ggf. auf Seitengroesse begrenzen
//STRIP001 	aPageSize.Width() -= pPage->GetLftBorder() + pPage->GetRgtBorder();
//STRIP001 	aPageSize.Height() -= pPage->GetUppBorder() + pPage->GetLwrBorder();
//STRIP001 
//STRIP001 	// Falls Grafik zu gross, wird die Grafik
//STRIP001 	// in die Seite eingepasst
//STRIP001 	if ( aSize.Height() && aPageSize.Height() &&
//STRIP001 		( aSize.Height() > aPageSize.Height() ) || ( aSize.Width()	> aPageSize.Width() ) )
//STRIP001 	{
//STRIP001 		double fGrfWH =	(double) aSize.Width() / aSize.Height();
//STRIP001 		double fWinWH =	(double) aPageSize.Width() / aPageSize.Height();
//STRIP001 
//STRIP001 		// Grafik an Pagesize anpassen (skaliert)
//STRIP001 		if ( fGrfWH < fWinWH )
//STRIP001 		{
//STRIP001 			aSize.Width() = (long) ( aPageSize.Height() * fGrfWH );
//STRIP001 			aSize.Height()= aPageSize.Height();
//STRIP001 		}
//STRIP001 		else if ( fGrfWH > 0. )
//STRIP001 		{
//STRIP001 			aSize.Width() = aPageSize.Width();
//STRIP001 			aSize.Height()= (long) ( aPageSize.Width() / fGrfWH );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const Point	aPos( rPos.X() - ( aSize.Width() >> 1 ), rPos.Y() - ( aSize.Height() >> 1 ) );
//STRIP001 
//STRIP001     LeaveAllGroup();
//STRIP001 	InsertObject( new SdrGrafObj( rGraphic, Rectangle( aPos, aSize ) ),
//STRIP001 				  *GetPageViewPvNum( 0 ), SDRINSERT_SETDEFLAYER );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 void SchView::InvalidateOneWin(Window& rWin, const Rectangle& rRect)
//STRIP001 {
//STRIP001 	rWin.Invalidate(rRect);
//STRIP001 }

/*N*/ long SchView::GetSelectedRow() const
/*N*/ {
/*N*/ 	long nRow=-1;
/*N*/ 
/*N*/ 	if (HasMarkedObj())
/*N*/ 	{
/*?*/ 		const SdrMarkList& rMarkList = GetMarkList();
/*?*/ 
/*?*/ 		for (USHORT nMark = 0;
/*?*/ 			 nMark < rMarkList.GetMarkCount();// && bResult;
/*?*/ 			 nMark++)
/*?*/ 		{
/*?*/ 			SdrMark* pMark = rMarkList.GetMark( 0 );
/*?*/ 			SdrObject* pObj = pMark->GetObj();
/*?*/ 			SchDataRow *pRow=GetDataRow(*pObj);
/*?*/ 			if(pRow)
/*?*/ 				nRow=pRow->GetRow();
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return nRow;
/*N*/ }

/*************************************************************************
|*
|* SetDefault, die Datenpunktattribute der selektierten Datenreihe(n) loeschen
|*
\************************************************************************/

//STRIP001 void SchView::SetDefault()
//STRIP001 {
//STRIP001 	CHART_TRACE( "Chart SchView::SetDefault Datenpunktattribute der selektierten Datenreihe(n) loeschen" );
//STRIP001 	const SdrMarkList& rMarkList = GetMarkList();
//STRIP001 
//STRIP001 	for (USHORT nMark = 0; nMark < rMarkList.GetMarkCount(); nMark++)
//STRIP001 	{
//STRIP001 		SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 		SdrObject* pObj = pMark->GetObj();
//STRIP001 		SchObjectId* pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 		UINT16 nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001 		if (nObjId == CHOBJID_DIAGRAM_ROWGROUP)
//STRIP001 		{
//STRIP001 			// das MUSS eine Gruppe sein
//STRIP001 			SchObjGroup* pGroup = (SchObjGroup*)pObj;
//STRIP001 			SdrObjList* pSubList = pObj->GetSubList();
//STRIP001 
//STRIP001 			USHORT nSubCount = (USHORT)pSubList->GetObjCount();
//STRIP001 
//STRIP001 
//STRIP001 			if (nSubCount)
//STRIP001 			{
//STRIP001 				// UndoAction erzeugen
//STRIP001 				SchUndoMultipleDataPoints* pUndoAction =
//STRIP001 					new SchUndoMultipleDataPoints(*pDoc);
//STRIP001 
//STRIP001 				SvxChartStyle aStyle = GetDoc().ChartStyle();
//STRIP001 
//STRIP001 				// keine Datenpunkt-Objekte im Drawing-Layer?
//STRIP001 				if (aStyle == CHSTYLE_2D_LINE           ||
//STRIP001 					aStyle == CHSTYLE_2D_STACKEDLINE    ||
//STRIP001 					aStyle == CHSTYLE_2D_PERCENTLINE    ||
//STRIP001 					aStyle == CHSTYLE_2D_AREA           ||
//STRIP001 					aStyle == CHSTYLE_2D_STACKEDAREA    ||
//STRIP001 					aStyle == CHSTYLE_2D_PERCENTAREA    ||
//STRIP001 					aStyle == CHSTYLE_3D_STRIPE         ||
//STRIP001 					aStyle == CHSTYLE_3D_AREA           ||
//STRIP001 					aStyle == CHSTYLE_3D_STACKEDAREA    ||
//STRIP001 					aStyle == CHSTYLE_3D_PERCENTAREA    ||
//STRIP001 					aStyle == CHSTYLE_3D_SURFACE        ||
//STRIP001 					aStyle == CHSTYLE_2D_NET            ||
//STRIP001 					aStyle == CHSTYLE_2D_NET_STACK      ||
//STRIP001 					aStyle == CHSTYLE_2D_NET_PERCENT    ||
//STRIP001 					aStyle == CHSTYLE_2D_CUBIC_SPLINE   ||
//STRIP001 					aStyle == CHSTYLE_2D_B_SPLINE       ||
//STRIP001 					aStyle == CHSTYLE_2D_CUBIC_SPLINE_XY ||
//STRIP001 					aStyle == CHSTYLE_2D_B_SPLINE_XY    ||
//STRIP001 					aStyle == CHSTYLE_3D_COLUMN         ||
//STRIP001 					aStyle == CHSTYLE_3D_BAR)
//STRIP001 				{
//STRIP001 					SdrObject* pRow = pSubList->GetObj(0);
//STRIP001 					SchDataRow* pDataRow = GetDataRow(*pRow);
//STRIP001 					short nRow = pDataRow->GetRow();
//STRIP001 
//STRIP001 					long nColCount = GetDoc().GetColCount();
//STRIP001 					for( long nCol = 0; nCol < nColCount; nCol++ )
//STRIP001 					{
//STRIP001 						// an der UndoAction registrieren
//STRIP001 						pUndoAction->AddPoint((short)nCol, (short)nRow);
//STRIP001 
//STRIP001 						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
//STRIP001 						aSet.ClearItem();
//STRIP001 						GetDoc().PutDataPointAttr(nCol, nRow, aSet,FALSE);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					for (USHORT nObj = 0; nObj < nSubCount; nObj++)
//STRIP001 					{
//STRIP001 						SdrObject* pPoint = pSubList->GetObj(nObj);
//STRIP001 						SchDataPoint* pDataPoint = GetDataPoint(*pPoint);
//STRIP001 						short nCol = pDataPoint->GetCol();
//STRIP001 						short nRow = pDataPoint->GetRow();
//STRIP001 
//STRIP001 						// an der UndoAction registrieren
//STRIP001 						pUndoAction->AddPoint(nCol, nRow);
//STRIP001 
//STRIP001 						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
//STRIP001 						aSet.ClearItem();
//STRIP001 							// nicht mergen, nicht BuildChart rufen
//STRIP001 						GetDoc().ChangeDataPointAttr(aSet, *pPoint, FALSE, FALSE);
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				// die neuen Attribute in der UndoAction speichern und die
//STRIP001 				// Action dem UndoManager uebergeben
//STRIP001 				pUndoAction->CopyNewAttributes();
//STRIP001 
//STRIP001 				// get undo manager from topmost shell
//STRIP001 				if( pViewSh )
//STRIP001 				{
//STRIP001 					SfxUndoManager* pUndoMgr =
//STRIP001 						pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->GetUndoManager();
//STRIP001 
//STRIP001 					pUndoMgr->AddUndoAction( pUndoAction );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Markierungs-Handles setzen, ggf. logische 3D-Gruppen beruecksichtigen
|*
\************************************************************************/

/*N*/ void SchView::SetMarkHandles()
/*N*/ {
/*N*/ 	SdrView::SetMarkHandles();
/*N*/ 
/*N*/ 	SdrMark* pMark = aMark.GetMark(0);
/*N*/ 	if( pMark )
/*N*/ 	{
/*?*/ 		SdrPageView* pPageView = pMark->GetPageView();
/*?*/ 		if( pPageView )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrObject* pObj = pMark->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( pObj->ISA( Sch3dAxisObj ) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				aHdl.Clear();
//STRIP001 /*?*/ 				pObj->AddToHdlList( aHdl );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			if( ( nLogicalMarked != 0 && aMark.GetMarkCount() == 1 ) && pObj->ISA(E3dObject) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				E3dObject* p3DObj = (E3dObject*) pObj;
//STRIP001 /*?*/ 				USHORT nGroup = p3DObj->GetLogicalGroup();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( nGroup > 0 )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
//STRIP001 /*?*/ 											   IM_DEEPWITHGROUPS);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					while ( a3DIterator.IsMore() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						p3DObj = (E3dObject*) a3DIterator.Next();
//STRIP001 /*?*/ 						DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");
//STRIP001 /*?*/ 						
//STRIP001 /*?*/ 						if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
//STRIP001 /*?*/ 							p3DObj->AddToHdlList(aHdl);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* logische Gruppe betreten
|*
\************************************************************************/

//STRIP001 FASTBOOL SchView::EnterMarkedGroup()
//STRIP001 {
//STRIP001 	if ( nLogicalMarked != 0 )
//STRIP001 	{
//STRIP001 		nLogicalEntered = nLogicalMarked;
//STRIP001 		nLogicalMarked = 0;
//STRIP001 		UnmarkAll();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nLogicalEntered = 0;
//STRIP001 		return SdrView::EnterMarkedGroup();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* logische Gruppe verlassen
|*
\************************************************************************/

//STRIP001 void SchView::LeaveOneGroup()
//STRIP001 {
//STRIP001 	nLogicalMarked = 0;
//STRIP001 
//STRIP001 	if ( nLogicalEntered != 0 )
//STRIP001 		nLogicalEntered = 0;
//STRIP001 	else
//STRIP001 		SdrView::LeaveOneGroup();
//STRIP001 }

/*************************************************************************
|*
|* alle Gruppen verlassen
|*
\************************************************************************/

//STRIP001 void SchView::LeaveAllGroup()
//STRIP001 {
//STRIP001 	nLogicalMarked = 0;
//STRIP001 	nLogicalEntered = 0;
//STRIP001 	SdrView::LeaveAllGroup();
//STRIP001 }


/*************************************************************************
|*
|* logische Gruppe markieren
|*
\************************************************************************/

//STRIP001 void SchView::MarkLogicalGroup()
//STRIP001 {
//STRIP001 	if ( nLogicalEntered == 0 && aMark.GetMarkCount() == 1 )
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aMark.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 		if ( pObj->ISA(E3dObject) )
//STRIP001 			nLogicalMarked = ((E3dObject*) pObj)->GetLogicalGroup();
//STRIP001 
//STRIP001 		if ( nLogicalMarked )
//STRIP001 		{
//STRIP001 			FASTBOOL bVis = bHdlShown;
//STRIP001 			if ( bVis ) HideMarkHdl(NULL);
//STRIP001 			CheckMarked();
//STRIP001 			SetMarkRects();
//STRIP001 			SetMarkHandles();
//STRIP001 			if ( bVis ) ShowMarkHdl(NULL);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nLogicalMarked = 0;
//STRIP001 }

/*************************************************************************
|*
|* Objekt an Position vorhanden?
|*
\************************************************************************/

//STRIP001 FASTBOOL SchView::PickObj(const Point& rPnt, short nTol, SdrObject*& prObj,
//STRIP001 					 SdrPageView*& prPV,ULONG nOptions) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet = SdrView::PickObj(rPnt, nTol, prObj, prPV, nOptions);
//STRIP001 
//STRIP001 	if ( bRet && nLogicalEntered != 0 && prObj->ISA(E3dObject) )
//STRIP001 	{
//STRIP001 		E3dObject* p3DObj = (E3dObject*&) prObj;
//STRIP001 		E3dObject* pParent = p3DObj->GetParentObj();
//STRIP001 
//STRIP001 		if ( p3DObj->GetLogicalGroup() != nLogicalEntered && pParent &&
//STRIP001 			 pParent->GetLogicalGroup() != nLogicalEntered )
//STRIP001 		{
//STRIP001 			bRet = FALSE;
//STRIP001 			prObj = NULL;
//STRIP001 			prPV = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

/*************************************************************************
|*
|* markiertes Objekt (auch von logischer Gruppe) getroffen?
|*
\************************************************************************/

//STRIP001 FASTBOOL SchView::IsMarkedHit(const Point& rPnt, short nTol) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet = SdrView::IsMarkedHit(rPnt, nTol);
//STRIP001 
//STRIP001 	// falls SvDraw kein Objekt gefunden hat, ggf. auch logische Gruppe pruefen
//STRIP001 	if ( !bRet && nLogicalMarked != 0 )
//STRIP001 	{
//STRIP001 		SdrObject*	 pObj;
//STRIP001 		SdrPageView* pPV;
//STRIP001 
//STRIP001 		// wenn Objekt vorhanden und Gruppe uebereinstimmt -> TRUE
//STRIP001 		if ( PickObj(rPnt, nTol, pObj, pPV) && pObj->ISA(E3dObject) &&
//STRIP001 			((E3dObject*) pObj)->GetLogicalGroup() == nLogicalMarked )
//STRIP001 			bRet = TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

/*************************************************************************
|*
|* Liste der markierten Objekte einer logischen Gruppe zurueckgeben
|*
\************************************************************************/

//STRIP001 E3dLogicalObjList SchView::GetLogicalObjList()
//STRIP001 {
//STRIP001 	E3dLogicalObjList aObjList;
//STRIP001 
//STRIP001 	if ( nLogicalMarked != 0 && aMark.GetMarkCount() == 1 )
//STRIP001 	{
//STRIP001 		SdrMark*	pMark = aMark.GetMark(0);
//STRIP001 		SdrObject*	pObj = pMark->GetObj();
//STRIP001 
//STRIP001 		if ( pObj->ISA(E3dObject) )
//STRIP001 		{
//STRIP001 			E3dObject* p3DObj = (E3dObject*) pObj;
//STRIP001 			USHORT nGroup = p3DObj->GetLogicalGroup();
//STRIP001 
//STRIP001 			if ( nGroup > 0 )
//STRIP001 			{
//STRIP001 				SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
//STRIP001 											IM_DEEPWITHGROUPS);
//STRIP001 
//STRIP001 				while ( a3DIterator.IsMore() )
//STRIP001 				{
//STRIP001 					p3DObj = (E3dObject*) a3DIterator.Next();
//STRIP001 					DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");
//STRIP001 
//STRIP001 					if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
//STRIP001 						aObjList.Insert(p3DObj, LIST_APPEND);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aObjList;
//STRIP001 }

/*N*/ IMPL_LINK(SchView,NotifySelection ,void*, EMPTYARG)
/*N*/ //void ::NotifySelection()
/*N*/ {
/*N*/ 	SchMemChart* pMemChart = (SchMemChart*)pDoc->GetMemChart();
/*N*/ 	if( pMemChart == NULL )
/*?*/ 		return 0;
/*N*/ 
/*N*/ 	ChartSelectionInfo aInfo;
/*N*/ 
/*N*/ 	SdrObject	 *pObj  = NULL;
/*N*/ 	SchDataRow	 *pRow  = NULL;
/*N*/ 	SchDataPoint *pPoint= NULL;
/*N*/ 
/*N*/ 	aInfo.nSelection=CHART_SEL_NONE;
/*N*/ 
/*N*/ 	if (HasMarkedObj())
/*N*/ 	{
/*?*/ 		ULONG nCount = aMark.GetMarkCount();
/*?*/ 		if (nCount == 1)
/*?*/ 		{
/*?*/ 			pObj=aMark.GetMark(0)->GetObj();
/*?*/ 			SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 			if (pId)
/*?*/ 			{
/*?*/ 				switch (pId->GetObjId())
/*?*/ 				{
/*?*/ 					case CHOBJID_DIAGRAM_AREA:
/*?*/ 					case CHOBJID_DIAGRAM:
/*?*/ 						aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ALL;
/*?*/ 						break;
/*?*/ 
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_ROW:
/*?*/ 					case CHOBJID_DIAGRAM_ROWGROUP:
/*?*/ 					case CHOBJID_DIAGRAM_ROWS:
/*?*/ 					case CHOBJID_DIAGRAM_ROWSLINE:
/*?*/ 					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
/*?*/ 						{
/*?*/ 							pRow=GetDataRow(*pObj);
/*?*/ 							if(pRow)
/*?*/ 							{
/*?*/ 								if(!pDoc->IsDataSwitched())
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ROW;
/*?*/ 									aInfo.nRow=pRow->GetRow();
/*?*/ 								}
/*?*/ 								else
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_COL;
/*?*/ 									aInfo.nCol=pRow->GetRow();
/*?*/ 								}
/*?*/ 							}
/*?*/ 						}
/*?*/ 						break;
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_COL:
/*?*/ 					case CHOBJID_DIAGRAM_DATA:
/*?*/ 						{
/*?*/ 							pPoint=GetDataPoint(*pObj);
/*?*/ 							if(pPoint)
/*?*/ 							{
							/*	SfxItemSet aAttr=pDoc->GetDataRowAttr(pPoint->GetRow());
								aAttr.Put(pDoc->GetDataPointAttr(pPoint->GetCol(),pPoint->GetRow()));	*/
/*?*/ 								if(!pDoc->IsDataSwitched())
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
/*?*/ 									aInfo.nCol=pPoint->GetCol();
/*?*/ 									aInfo.nRow=pPoint->GetRow();
/*?*/ 								}
/*?*/ 								else
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
/*?*/ 									aInfo.nCol=pPoint->GetRow();
/*?*/ 									aInfo.nRow=pPoint->GetCol();
/*?*/ 								}
/*?*/ 							}
/*?*/ 						}
/*?*/ 						break;
/*?*/ 
/*					case CHOBJID_DIAGRAM_DESCRGROUP:
					case CHOBJID_DIAGRAM_DESCR_ROW:
					case CHOBJID_DIAGRAM_DESCR_COL:
					case CHOBJID_LEGEND:

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_WALL:
					case CHOBJID_DIAGRAM_FLOOR:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_DIAGRAM_X_AXIS:
					case CHOBJID_DIAGRAM_Y_AXIS:       sowie auch A,B,C:
					case CHOBJID_DIAGRAM_Z_AXIS:
					case CHOBJID_DIAGRAM_X_GRID_MAIN:
					case CHOBJID_DIAGRAM_Y_GRID_MAIN:
					case CHOBJID_DIAGRAM_Z_GRID_MAIN:
					case CHOBJID_DIAGRAM_X_GRID_HELP:
					case CHOBJID_DIAGRAM_Y_GRID_HELP:
					case CHOBJID_DIAGRAM_Z_GRID_HELP:*/
/*?*/ 					default:
/*?*/ 						break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 	pMemChart->SubmitSelection(aInfo);
/*N*/ 	return 0;
/*N*/ }


// ********************************************************************************
//
//  Drag and Drop / Clipboard
//
// ********************************************************************************

// ========================================
// create transferable for drag&drop
// ========================================

//STRIP001 Reference< datatransfer::XTransferable > SchView::CreateDragDropDataObject(
//STRIP001 	SchView* pView, Window& rWindow, const Point& rDragPos )
//STRIP001 {
//STRIP001 	// create descriptor
//STRIP001 	TransferableObjectDescriptor aObjDesc;
//STRIP001 
//STRIP001 	aObjDesc.maSize = GetAllMarkedRect().GetSize();
//STRIP001 	aObjDesc.maDragStartPos = rDragPos;
//STRIP001 	aObjDesc.mbCanLink = FALSE;
//STRIP001 
//STRIP001 	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
//STRIP001 	if( pDocShell )
//STRIP001     {
//STRIP001         pDocShell->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 		aObjDesc.maDisplayName = pDocShell->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001     }
//STRIP001 
//STRIP001 	SchTransferable* pTransferable = new SchTransferable( NULL, pView, aObjDesc, sal_False );
//STRIP001 	Reference< datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 
//STRIP001 	SCH_MOD1()->SetDragTransferable( pTransferable );
//STRIP001 
//STRIP001 	pTransferable->StartDrag( &rWindow, DND_ACTION_COPYMOVE | DND_ACTION_LINK );
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

// ========================================
// create transferable for clipboard
// ========================================

//STRIP001 Reference< datatransfer::XTransferable > SchView::CreateClipboardDataObject()
//STRIP001 {
//STRIP001 	// create descriptor
//STRIP001 	TransferableObjectDescriptor aObjDesc;
//STRIP001 	const Rectangle aMarkRect = GetAllMarkedRect();
//STRIP001 
//STRIP001 	aObjDesc.maSize = aMarkRect.GetSize();
//STRIP001 	aObjDesc.mbCanLink = FALSE;
//STRIP001 
//STRIP001     SdrModel* pModel = GetMarkedObjModel();
//STRIP001 
//STRIP001 	SchTransferable* pTransferable = new SchTransferable( pModel, NULL, aObjDesc, sal_False );
//STRIP001 	Reference< datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 
//STRIP001 	SCH_MOD1()->SetClipboardTransferable( pTransferable );
//STRIP001 
//STRIP001 	pTransferable->CopyToClipboard( GetWindow());
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

// ========================================
// create transferable for selection clipboard
// ========================================

//STRIP001 Reference< datatransfer::XTransferable > SchView::CreateSelectionDataObject( SchView* pWorkView, Window& rWindow )
//STRIP001 {
//STRIP001 	// create descriptor
//STRIP001 	TransferableObjectDescriptor aObjDesc;
//STRIP001 	const Rectangle aMarkRect = GetAllMarkedRect();
//STRIP001 
//STRIP001 	aObjDesc.maSize = aMarkRect.GetSize();
//STRIP001 	aObjDesc.mbCanLink = FALSE;
//STRIP001 
//STRIP001 //    SdrModel* pModel = GetMarkedObjModel();
//STRIP001 
//STRIP001 	SchTransferable* pTransferable = new SchTransferable( NULL, pWorkView, aObjDesc, sal_True );
//STRIP001 	Reference< datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 	
//STRIP001 	SCH_MOD1()->SetSelectionClipboardTransferable( pTransferable );
//STRIP001 
//STRIP001     pTransferable->CopyToSelection( &rWindow );
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

/*N*/ void SchView::UpdateSelectionClipboard( BOOL bForceDeselect )
/*N*/ {
/*N*/     if( pViewSh && pViewSh->GetWindow() )
/*N*/     {
/*N*/         if( ! bForceDeselect && GetMarkList().GetMarkCount() )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001             CreateSelectionDataObject( this, *pViewSh->GetWindow() );
/*N*/         else if( SCH_MOD1()->GetSelectionClipboardTransferable() &&
/*N*/ 				 ( SCH_MOD1()->GetSelectionClipboardTransferable()->GetView() == this ) )
/*N*/         {
/*?*/             TransferableHelper::ClearSelection( pViewSh->GetWindow() );
/*?*/             SCH_MOD1()->SetSelectionClipboardTransferable( NULL );
/*N*/         }
/*N*/     }
/*N*/ }

// ========================================
// drag action requested for this view
// ========================================

//STRIP001 sal_Int8 SchView::AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pDocSh->IsReadOnly())
//STRIP001 		return nRet;
//STRIP001 
//STRIP001 	SdrPageView* pPV = GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 	if( ! pPV->IsLayerLocked( GetActiveLayer()) )
//STRIP001 	{
//STRIP001 		sal_Bool bIsInsideOutlinerView = sal_False;
//STRIP001 
//STRIP001 		const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 		if( pOLV && pWin )
//STRIP001 		{
//STRIP001 			Rectangle aRect( pOLV->GetOutputArea() );
//STRIP001 
//STRIP001 			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );
//STRIP001 
//STRIP001 			if( aRect.IsInside( aPos ))
//STRIP001 			{
//STRIP001 				bIsInsideOutlinerView = sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( ! bIsInsideOutlinerView )
//STRIP001 		{
//STRIP001 			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();
//STRIP001 
//STRIP001 			if( pDragTransferable )
//STRIP001 			{
//STRIP001 //  				const SchView* pSourceView = pDragTransferable->GetView();
//STRIP001 
//STRIP001 //  				if( pSourceView )
//STRIP001 //  				{
//STRIP001 //  					if( !( rEvt.maDragEvent.DropAction & DND_ACTION_LINK ) ||
//STRIP001 //  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//STRIP001 //  						nRet = rEvt.maDragEvent.DropAction;
//STRIP001 //  				}
//STRIP001 			}
//STRIP001 			// else: support of alien formats
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// ========================================
// drop an object into this view
// ========================================

//STRIP001 sal_Int8 SchView::ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pDocSh->IsReadOnly())
//STRIP001 		return nRet;
//STRIP001 
//STRIP001 	sal_Int8 nDropAction = rEvt.mnAction;
//STRIP001 	SdrPageView* pPV = GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 	if( ! pPV->IsLayerLocked( GetActiveLayer()))
//STRIP001 	{
//STRIP001 		const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 		sal_Bool bIsInsideOutlinerView = sal_False;
//STRIP001 
//STRIP001 		if( pOLV && pWin )
//STRIP001 		{
//STRIP001 			Rectangle aRect( pOLV->GetOutputArea());
//STRIP001 			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );
//STRIP001 
//STRIP001 			if( aRect.IsInside( aPos ))
//STRIP001 			{
//STRIP001 				bIsInsideOutlinerView = sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( ! bIsInsideOutlinerView )
//STRIP001 		{
//STRIP001 			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();
//STRIP001 
//STRIP001 			if( pDragTransferable )
//STRIP001 			{
//STRIP001 //  				const SchView* pSourceView = pDragTransferable->GetView();
//STRIP001 
//STRIP001 //  				if( pSourceView )
//STRIP001 //  				{
//STRIP001 //  					if( !( nDropAction & DND_ACTION_LINK ) ||
//STRIP001 //  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//STRIP001 //  						nRet = nDropAction;
//STRIP001 //  				}
//STRIP001 			}
//STRIP001 			// else: support of alien formats
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// ========================================
// insert object into document
// ========================================

//STRIP001 sal_Bool SchView::InsertData( TransferableDataHelper& rDataHelper, const Point& rPos, BOOL bCopy, ULONG nFormat )
//STRIP001 {
//STRIP001     sal_Bool     bReturn  = sal_False;
//STRIP001     SdrPage*     pPage    = GetDoc().GetPage( 0 );
//STRIP001 
//STRIP001 //      Reference< XInterface > xInterface( rDataHelper.GetTransferable(), UNO_QUERY );
//STRIP001 //      SchTransferable* pOwnData = SchTransferable::getImplementation( xInterface );
//STRIP001 
//STRIP001 //      if( pOwnData &&
//STRIP001 //          ! ( pOwnData == SCH_MOD1()->GetDragTransferable() ||
//STRIP001 //              pOwnData == SCH_MOD1()->GetClipboardTransferable()))
//STRIP001 //          pOwnData = NULL;
//STRIP001         
//STRIP001 //  	if( pOwnData && nFormat == 0 )
//STRIP001 //  	{
//STRIP001         // own data
//STRIP001 //  		const SchView* pSourceView = pOwnData->GetView();
//STRIP001 
//STRIP001 //  		if( pSourceView )
//STRIP001 //  		{
//STRIP001 //  			if( pSourceView == this )
//STRIP001 //  			{
//STRIP001 //                  // same view
//STRIP001 //                  TransferableObjectDescriptor aDescr;
//STRIP001 //                  if( rDataHelper.GetTransferableObjectDescriptor( SOT_FORMAT_PRIVATE, aDescr ))
//STRIP001 //                  {
//STRIP001                     
//STRIP001 //                      Size aVector( rPos.X() - aDescr.maDragStartPos.X(),
//STRIP001 //                                    rPos.Y() - aDescr.maDragStartPos.Y());
//STRIP001 //                      MoveAllMarked( aVector, bCopy );
//STRIP001 //                  }
//STRIP001 //  			}
//STRIP001 //  			else
//STRIP001 //  			{
//STRIP001 //                  // different views
//STRIP001 
//STRIP001                 // insert selected objects in current page
//STRIP001 //  				ChartModel* pDoc = SAL_STATIC_CAST( ChartModel*, pSourceView->GetAllMarkedModel() );
//STRIP001 //  				DeleteChartUserData( *pDoc );
//STRIP001 //  				bReturn = Paste( *pDoc, rPos, pPage );
//STRIP001 //  				delete pDoc;
//STRIP001 //  			}
//STRIP001 //  		}
//STRIP001 //  		else
//STRIP001 //  		{
//STRIP001 //  			// internal paste
//STRIP001 
//STRIP001 //  			ChartModel* pDoc = pOwnData->GetWorkDocument();
//STRIP001 //  			DeleteChartUserData( *pDoc );
//STRIP001 //  			bReturn = Paste( *pDoc, rPos, pPage );
//STRIP001 //  		}
//STRIP001 //  	}
//STRIP001 //  	else
//STRIP001     if( ( nFormat == SOT_FORMATSTR_ID_SVXB || nFormat == 0 )&&
//STRIP001         rDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ))
//STRIP001     {
//STRIP001         // graphic exchange format
//STRIP001 
//STRIP001 		SotStorageStreamRef xStm;
//STRIP001 
//STRIP001 		if( rDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_SVXB, xStm ) )
//STRIP001 		{
//STRIP001 			Graphic aGraphic;
//STRIP001             *xStm >> aGraphic;
//STRIP001 
//STRIP001             InsertGraphic( aGraphic, rPos );
//STRIP001             bReturn = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 	else if( ( nFormat == FORMAT_GDIMETAFILE || nFormat == 0 )&&
//STRIP001              rDataHelper.HasFormat( FORMAT_GDIMETAFILE ))
//STRIP001     {
//STRIP001 		GDIMetaFile aMtf;
//STRIP001 
//STRIP001 		if( rDataHelper.GetGDIMetaFile( FORMAT_GDIMETAFILE, aMtf ) )
//STRIP001 		{
//STRIP001 			InsertGraphic( aMtf, rPos );
//STRIP001 			bReturn = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 	else if( ( nFormat == FORMAT_BITMAP || nFormat == 0 )&&
//STRIP001              rDataHelper.HasFormat( FORMAT_BITMAP ))
//STRIP001     {
//STRIP001         Bitmap aBmp;
//STRIP001 
//STRIP001         if( rDataHelper.GetBitmap( FORMAT_BITMAP, aBmp ) )
//STRIP001 		{
//STRIP001             InsertGraphic( aBmp, rPos );
//STRIP001             bReturn = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 	else if( ( nFormat == FORMAT_STRING || nFormat == 0 )&&
//STRIP001              rDataHelper.HasFormat( FORMAT_STRING ))
//STRIP001 	{
//STRIP001         String aString;
//STRIP001 
//STRIP001         if( rDataHelper.GetString( FORMAT_STRING, aString ) )
//STRIP001             bReturn = SdrExchangeView::Paste( aString, rPos, pPage );
//STRIP001 	}
//STRIP001 
//STRIP001 	MarkListHasChanged();
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

//STRIP001 Window* SchView::GetWindow() const
//STRIP001 {
//STRIP001     if( pViewSh )
//STRIP001         return pViewSh->GetWindow();
//STRIP001     return NULL;
//STRIP001 }

/// SfxListener::Notify
/*N*/ void SchView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     if( rHint.ISA( SfxSimpleHint ) &&
/*N*/         SAL_STATIC_CAST( const SfxSimpleHint&, rHint ).GetId() == SFX_HINT_MODECHANGED &&
/*N*/         rBC.ISA( ChartModel ))
/*N*/     {
/*N*/         if( pViewSh )
/*N*/             pViewSh->UIFeatureChanged();
/*N*/     }
/*N*/     else
/*N*/         E3dView::Notify( rBC, rHint );
/*N*/ }
}
