/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeIterator;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class SortedList
extends TransformedList {
    public static final int STRICT_SORT_ORDER = 0;
    public static final int AVOID_MOVING_ELEMENTS = 1;
    private IndexedTree unsorted = null;
    private IndexedTree sorted = null;
    private Comparator comparator = null;
    private int mode = 0;

    public SortedList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public SortedList(EventList source, Comparator comparator) {
        super(source);
        this.setComparator(comparator);
        source.addListEventListener(this);
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Mode must be either SortedList.STRICT_SORT_ORDER or SortedList.AVOID_MOVING_ELEMENTS");
        }
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        if (this.mode == 0) {
            this.setComparator(this.getComparator());
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void listChanged(ListEvent listChanges) {
        if (listChanges.isReordering()) {
            IndexedTreeNode unsortedNode;
            int[] reorderMap = listChanges.getReorderMap();
            IndexedTreeNode[] sortedNodes = new IndexedTreeNode[this.sorted.size()];
            int index = 0;
            IndexedTreeIterator i = this.unsorted.iterator(0);
            while (i.hasNext()) {
                unsortedNode = i.next();
                sortedNodes[index] = (IndexedTreeNode)unsortedNode.getValue();
                ++index;
            }
            index = 0;
            i = this.unsorted.iterator(0);
            while (i.hasNext()) {
                unsortedNode = i.next();
                unsortedNode.setValue(sortedNodes[reorderMap[index]]);
                sortedNodes[reorderMap[index]].setValue(unsortedNode);
                ++index;
            }
            return;
        }
        this.updates.beginEvent();
        LinkedList<IndexedTreeNode> insertNodes = new LinkedList<IndexedTreeNode>();
        ArrayList<IndexedTreeNode> updateNodes = new ArrayList<IndexedTreeNode>();
        while (listChanges.next()) {
            IndexedTreeNode unsortedNode;
            int unsortedIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                unsortedNode = this.unsorted.addByNode(unsortedIndex, IndexedTreeNode.EMPTY_NODE);
                insertNodes.addLast(unsortedNode);
                continue;
            }
            if (changeType == 1) {
                unsortedNode = this.unsorted.getNode(unsortedIndex);
                IndexedTreeNode sortedNode = (IndexedTreeNode)unsortedNode.getValue();
                sortedNode.setSorted(false);
                updateNodes.add(sortedNode);
                continue;
            }
            if (changeType != 0) continue;
            unsortedNode = this.unsorted.getNode(unsortedIndex);
            unsortedNode.removeFromTree(this.unsorted);
            int deleteSortedIndex = this.deleteByUnsortedNode(unsortedNode);
            this.updates.addDelete(deleteSortedIndex);
        }
        Iterator i = updateNodes.iterator();
        while (i.hasNext()) {
            IndexedTreeNode sortedNode = (IndexedTreeNode)i.next();
            int originalIndex = sortedNode.getIndex();
            if (this.isNodeInSortedOrder(sortedNode)) {
                sortedNode.setSorted(true);
                this.updates.addUpdate(originalIndex);
                continue;
            }
            if (this.mode == 1) {
                this.updates.addUpdate(originalIndex);
                continue;
            }
            sortedNode.removeFromTree(this.sorted);
            this.updates.addDelete(originalIndex);
            int insertedIndex = this.insertByUnsortedNode((IndexedTreeNode)sortedNode.getValue());
            this.updates.addInsert(insertedIndex);
        }
        while (!insertNodes.isEmpty()) {
            IndexedTreeNode insertNode = (IndexedTreeNode)insertNodes.removeFirst();
            int insertedIndex = this.insertByUnsortedNode(insertNode);
            this.updates.addInsert(insertedIndex);
        }
        this.updates.commitEvent();
    }

    private boolean isNodeInSortedOrder(IndexedTreeNode sortedNode) {
        for (IndexedTreeNode leftNeighbour = sortedNode.previous(); leftNeighbour != null; leftNeighbour = leftNeighbour.previous()) {
            if (!leftNeighbour.isSorted()) continue;
            if (this.sorted.getComparator().compare(leftNeighbour.getValue(), sortedNode.getValue()) <= 0) break;
            return false;
        }
        for (IndexedTreeNode rightNeighbour = sortedNode.next(); rightNeighbour != null; rightNeighbour = rightNeighbour.next()) {
            if (!rightNeighbour.isSorted()) continue;
            if (this.sorted.getComparator().compare(sortedNode.getValue(), rightNeighbour.getValue()) <= 0) break;
            return false;
        }
        return true;
    }

    private int insertByUnsortedNode(IndexedTreeNode unsortedNode) {
        IndexedTreeNode sortedNode = this.sorted.addByNode(unsortedNode);
        unsortedNode.setValue(sortedNode);
        return sortedNode.getIndex();
    }

    private int deleteByUnsortedNode(IndexedTreeNode unsortedNode) {
        IndexedTreeNode sortedNode = (IndexedTreeNode)unsortedNode.getValue();
        int sortedIndex = sortedNode.getIndex();
        sortedNode.removeFromTree(this.sorted);
        return sortedIndex;
    }

    protected int getSourceIndex(int mutationIndex) {
        IndexedTreeNode sortedNode = this.sorted.getNode(mutationIndex);
        IndexedTreeNode unsortedNode = (IndexedTreeNode)sortedNode.getValue();
        return unsortedNode.getIndex();
    }

    protected boolean isWritable() {
        return true;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        IndexedTree previousSorted = this.sorted;
        Comparator treeComparator = null;
        treeComparator = comparator != null ? new IndexedTreeNodeComparator(comparator) : new IndexedTreeNodeRawOrderComparator();
        this.sorted = new IndexedTree(treeComparator);
        if (previousSorted == null && this.unsorted == null) {
            this.unsorted = new IndexedTree();
            for (int i = 0; i < this.source.size(); ++i) {
                IndexedTreeNode unsortedNode = this.unsorted.addByNode(i, IndexedTreeNode.EMPTY_NODE);
                this.insertByUnsortedNode(unsortedNode);
            }
            return;
        }
        if (this.source.size() == 0) {
            return;
        }
        IndexedTreeIterator i = this.unsorted.iterator(0);
        while (i.hasNext()) {
            IndexedTreeNode unsortedNode = i.next();
            this.insertByUnsortedNode(unsortedNode);
        }
        int[] reorderMap = new int[this.size()];
        int oldSortedIndex = 0;
        IndexedTreeIterator i2 = previousSorted.iterator(0);
        while (i2.hasNext()) {
            IndexedTreeNode oldSortedNode = i2.next();
            IndexedTreeNode unsortedNode = (IndexedTreeNode)oldSortedNode.getValue();
            IndexedTreeNode newSortedNode = (IndexedTreeNode)unsortedNode.getValue();
            int newSortedIndex = newSortedNode.getIndex();
            reorderMap[newSortedIndex] = oldSortedIndex++;
        }
        this.updates.beginEvent();
        this.updates.reorder(reorderMap);
        this.updates.commitEvent();
    }

    public int indexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.indexOf(object);
        }
        int index = this.sorted.indexOf(object);
        if (index == -1) {
            return -1;
        }
        while (index < this.size()) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.lastIndexOf(object);
        }
        int index = this.sorted.lastIndexOf(object);
        if (index == -1) {
            return -1;
        }
        while (index > -1) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public int sortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        int sortIndex = this.sorted.indexOf(object);
        return sortIndex == -1 ? this.sorted.indexOfSimulated(object) : sortIndex;
    }

    public int lastSortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        int lastSortIndex = this.sorted.lastIndexOf(object);
        return lastSortIndex == -1 ? this.sorted.indexOfSimulated(object) : lastSortIndex;
    }

    public int indexOfSimulated(Object object) {
        return this.comparator != null ? this.sorted.indexOfSimulated(object) : this.size();
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public Iterator iterator() {
        return new SortedListIterator();
    }

    private class SortedListIterator
    implements Iterator {
        private IndexedTreeIterator treeIterator;

        private SortedListIterator() {
            this.treeIterator = SortedList.this.sorted.iterator(0);
        }

        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        public Object next() {
            IndexedTreeNode sortedNode = this.treeIterator.next();
            IndexedTreeNode unsortedNode = (IndexedTreeNode)sortedNode.getValue();
            return SortedList.this.source.get(unsortedNode.getIndex());
        }

        public void remove() {
            int indexToRemove = this.treeIterator.previousIndex();
            SortedList.this.source.remove(SortedList.this.getSourceIndex(indexToRemove));
            this.treeIterator = SortedList.this.sorted.iterator(indexToRemove);
        }
    }

    private static class IndexedTreeNodeRawOrderComparator
    implements Comparator {
        private IndexedTreeNodeRawOrderComparator() {
        }

        public int compare(Object alpha, Object beta) {
            try {
                IndexedTreeNode alphaTreeNode = (IndexedTreeNode)alpha;
                IndexedTreeNode betaTreeNode = (IndexedTreeNode)beta;
                int alphaIndex = alphaTreeNode.getIndex();
                int betaIndex = betaTreeNode.getIndex();
                return alphaIndex - betaIndex;
            }
            catch (ClassCastException e) {
                System.out.println(alpha.getClass());
                System.out.println(beta.getClass());
                throw e;
            }
        }
    }

    private class IndexedTreeNodeComparator
    implements Comparator {
        private Comparator comparator;

        public IndexedTreeNodeComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object alpha, Object beta) {
            int result;
            Object alphaObject = alpha;
            Object betaObject = beta;
            int alphaIndex = -1;
            int betaIndex = -1;
            if (alpha instanceof IndexedTreeNode) {
                IndexedTreeNode alphaTreeNode = (IndexedTreeNode)alpha;
                alphaIndex = alphaTreeNode.getIndex();
                alphaObject = SortedList.this.source.get(alphaIndex);
            }
            if (beta instanceof IndexedTreeNode) {
                IndexedTreeNode betaTreeNode = (IndexedTreeNode)beta;
                betaIndex = betaTreeNode.getIndex();
                betaObject = SortedList.this.source.get(betaIndex);
            }
            if ((result = this.comparator.compare(alphaObject, betaObject)) != 0) {
                return result;
            }
            if (alphaIndex != -1 && betaIndex != -1) {
                return alphaIndex - betaIndex;
            }
            return 0;
        }
    }
}

