##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
Plone Article core classes for images and attachments and layout models
"""

from AccessControl import ClassSecurityInfo
import string
import random
import os
import Acquisition
from global_symbols import *
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder, Image, ObjectManager
from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.utils import format_stx
from Products.CMFDefault.utils import html_headcheck
from DocumentTemplate.DT_Util import html_quote

from ArticleModel import ArticleModel
from ArticleAttachments import ArticleAttachments
from ArticleImages import ArticleImages
from ArticleLock import ArticleLock

class ArticleCore(Acquisition.Implicit):

    # Standard security settings
    security = ClassSecurityInfo()
    security.declareObjectProtected(CMFCorePermissions.View)            # $$$ Is this clever ? Isn't it better to make the object private ?
                                                                        # This method makes all class properties & methods protected by View by default
    # Init method
    security.declarePrivate('__init__')
    def __init__(self, id, title = ''):
        """
        __init__ method
        """
        # Basic initalisation
        self.id = id
        self.title = title
        self.description = ""
        self.text = ""                  # Default text
        self.cooked_text = ""
        self.text_format = "html"

    security.declarePrivate('_post_init')
    def _post_init(self):
        """
        _post_init(self) => Post-init method (that is, method that is called AFTER the class has been set into the ZODB)
        """
        ArticleLock._post_init(self)



    #                                                                           #
    #                           CONTENT EDITING METHODS                         #
    #                                                                           #

    security.declareProtected(PloneArticle_editPermission, 'edit')
    def edit(self, text_format, text):
        """
        edit(self, text_format, text) => object modification method
        """
        return self.editArticle(text_format, text)

    # This edit method should only change attributes that are neither 'id' or metadatas.
    security.declareProtected(PloneArticle_editPermission, "editArticle")
    def editArticle(self, text_format, text):
        """
        edit(self, text_format, text) => object modification method
        """
        # Check lock status
        if not self.hasLockToken():
            raise RuntimeError, "You cannot edit a locked article"

        # ....
        if html_headcheck(text):
            text=bodyfinder(text)
        self.text = text
        article_tool = getToolByName(self, 'portal_article')
        site_text_formats = article_tool.getSiteTextFormats()

        if len(site_text_formats)==1:
            text_format=site_text_formats[0]  # Has to be the one choice
        elif len(site_text_formats)==0:
            text_format='html'               # Default
        else:
            if not text_format in site_text_formats:
                raise "Text format not allowed"

        self.text_format = text_format

        if text_format == 'html':
            self.text = self.cooked_text = text
        elif text_format == 'plain':
            self.text = text
            self.cooked_text = html_quote(text).replace('\n','<br />')
        elif text_format == 'structured-text':
            self.text = text
            self.cooked_text = format_stx(text)

        # Reindex
        self.reindexObject()

    security.declareProtected(CMFCorePermissions.View, 'CookedBody')
    def CookedBody(self):
        """
        The prepared basic rendering of an object. For Documents, this
        means pre-rendered structured text, plain text, or what was between the
        <BODY> tags of HTML.
        """
        if hasattr(self, 'cooked_text'):
            return self.cooked_text
        else:
            return self.text # PloneArticle 1.x did not cook the text

    security.declareProtected(CMFCorePermissions.View, 'TextFormat')
    def TextFormat(self):
        """
        Returns the text format set for this Plone Article
        """
        if hasattr(self, 'text_format'):
            if self.text_format in ['html','plain','structured-text']:
                return self.text_format
            else:
                return 'html' # Need a fallback
        else:
            return 'html' # PloneArticle 1.x expected HTML

    #                                                                           #
    #                             CMF CATALOG SUPPORT                           #
    #                                                                           #

    security.declareProtected(CMFCorePermissions.View, 'SearchableText')
    def SearchableText(self):
        "Returns a concatination of all searchable text"
        ret = "%s %s %s %s" % (
            self.Title(),
            self.Description(),
            self.text,
            string.join(map(lambda x: x.SearchableText(), self.listAttachments()), " ") +
            string.join(map(lambda x: x.title_or_id(), self.listImages()), " ") 
            )
        return ret

    #                                                                           #
    #                                MISC. METHODS                              #
    #                                                                           #

    security.declarePublic("getArticleURL")
    def getArticleURL(self,):
        """
        getArticleURL(self,) => Return article's absolute URL
        """
        return self.absolute_url()



    #                                                                           #
    #                           Lock support (core part)                        #
    #                                                                           #

    security.declareProtected(CMFCorePermissions.View, 'isLocked')
    def isLocked(self):
        """Returns 1 if the article is locked otherwise 0"""
        if not getToolByName(self, "portal_article").hasLockSupport():
            return 0
        locked = getattr(self, '_article_locked', 0)
        return locked


    security.declarePublic("checkLockStatus")
    def checkLockStatus(self,):
        """
        checkLockStatus(self,) => raise an exception if the user cannot edit
        things because the article is locked.
        """
        # No lock support => we ignore
        if not getToolByName(self, "portal_article").hasLockSupport():
            return
        if not self.hasLockToken():
            raise RuntimeError, "You cannot modify a locked article"


    security.declareProtected(CMFCorePermissions.View, 'hasLockToken')
    def hasLockToken(self,):
        """
        hasLockToken(self,) => Return 1 if and only if the document is locked by the current user.
        If lock support is not enabled, return 1 anyway.
        This method won't perform more in-depth security checks.

        Each and every editing method must call this method first to ensure that the user
        has the right to edit things.
        """
        # If no lock support => return true anyway
        if not getToolByName(self, "portal_article").hasLockSupport():
            return 1
        if not getattr(self, '_has_lock_support', None):
            return 1

        # If not locked => return false anyway
        if not self.isLocked():
            return 0

        # Check current user's id against locked user's id
        portal_membership = getToolByName(self, 'portal_membership')
        username = portal_membership.getAuthenticatedMember().getUserName()
        Log(LOG_DEBUG, username, self.getLockUser())
        return username == self.getLockUser()

