#####################################################################
#
# PloneLDAPMembershipTool       LDAP-enabled Plone Membership Tool
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
#
#####################################################################
__version__='$Revision: 1.2 $'[11:-2]

from AccessControl import ClassSecurityInfo
from Products.CMFCore.CMFCorePermissions import View
from Products.CMFCore.utils import getToolByName
from Globals import InitializeClass
from Products.CMFPlone.MembershipTool import MembershipTool as PloneMembership
from LDAPMembershipTool import LDAPMembershipTool as LDAPMembership


class PloneLDAPMembershipTool(LDAPMembership, PloneMembership):
    """ LDAP-enabled Plone Membership Tool """
    security = ClassSecurityInfo()
    meta_type = 'Plone LDAP Membership Tool'
    title = 'Plone LDAP Membership Tool'

    security.declareProtected(View, 'searchForMembers')
    def searchForMembers(self, REQUEST=None, **kw):
        """ """
        if REQUEST:
            dict = REQUEST
        else:
            dict = kw

        name = dict.get('name', '').strip().lower()
        email = dict.get('email', '').strip().lower()
        roles = dict.get('roles', None)
        last_login_time = dict.get('last_login_time', None)
        is_manager = self.checkPermission('Manage portal', self)
        md = self.portal_memberdata
        res = []
        matches = []
        acl = self.acl_users
        known_attrs = acl.getSchemaConfig().keys()
        login_attr = acl.getProperty('_login_attr')
        memberdata_tool = getToolByName(self, 'portal_memberdata')
        known_members = memberdata_tool._members.keys()

        if name:
            matches.extend(acl.findUser(login_attr, name))

        if email:
            if name:
                # Got name matches, have to weed out stuff
                new_matches = []

                for rec in matches:
                    if rec.get('mail', '').find(email) != -1:
                        new_matches.append(rec)

                matches = new_matches
            else:
                matches.extend(acl.findUser('mail', email))

        for match in matches:
            member_id = match.get(login_attr)

            if member_id in known_members:
                res.append(self.getMemberById(member_id))

        if last_login_time:
            new_res = []

            for member in res:
                if member.getProperty('last_login_time') > last_login_time:
                    new_res.append(member)

            res = new_res

        if roles:
            new_res = []

            for member in res:
                member_roles = member.getRoles()

                for r in roles:
                    if r in member_roles:
                        new_res.append(member)
                        break

            res = new_res

        if not is_manager:
            new_res = []

            for member in res:
                if member.getProperty('listed'):
                    new_res.append(member)

            res = new_res


        return res


InitializeClass(PloneLDAPMembershipTool)


def manage_addPloneLDAPMembershipTool(self, REQUEST=None):
    """ Add an LDAP-based Plone Membership Tool """
    tool_obj = PloneLDAPMembershipTool()
    self._setObject(tool_obj.getId(), tool_obj)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST)

