/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void probe_external_fwhois __P((void));

__END_DECLS

void
probe_external_fwhois(void)
{
  FILE *fp;
  char *c_domain, cmd[BUFSIZE];
  int len;

  c_domain = gtk_entry_get_text (GTK_ENTRY(history_combo->entry));
  write_history(c_domain);

  sprintf(cmd, "%s %s@%s", "fwhois", c_domain, server);

#ifdef DEBUG
  fprintf(stderr, "(net_ext_fwhois : char cmd[%d] %d): %s\n",
	  sizeof(cmd), strlen(cmd), cmd);
#endif /* DEBUG */

  fp = popen(cmd, "r");
  len = fread(text_buffer[0], 1, sizeof(text_buffer[0]), fp);
  fclose(fp);

  set_text_list(text_buffer[0]);
}
