/**
 * A client-side 802.1x implementation 
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * File: cardif_linux_wpa.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: cardif_linux_wpa.c,v 1.3 2004/08/20 04:42:28 chessing Exp $
 * $Date: 2004/08/20 04:42:28 $
 * $Log: cardif_linux_wpa.c,v $
 * Revision 1.3  2004/08/20 04:42:28  chessing
 * Set all of the new scanning and WPA code to be disabled by default, so that a 1.0.1 release can be made.  Added additional error message output to AKA code.  Fixed a few memory leaks in the AKA code.
 *
 * Revision 1.2  2004/08/19 02:33:31  chessing
 * A few follow-ups from the last patch.
 *
 * Revision 1.1  2004/08/19 02:28:07  chessing
 * First piece of WPA patch.  (The patch is growing fast, and this commit is to save what is done so far.)
 *
 *
 *******************************************************************/

#include "../xsup_debug.h"
#include "../profile.h"
#include "../config.h"

#include "linux/wpa_hostap_driver.h"
//#include "linux/ieee80211_crypto.h"
//#include "linux/ieee80211_ioctl.h"

int cardif_linux_wpa_set_wpa_ie(struct interface_data *intdata, char *wpa_ie, 
				int wpa_ie_len)
{
#ifdef EXPERIMENTAL
  debug_printf(DEBUG_NORMAL, "Called %s!\n", __FUNCTION__);
  return wpa_hostap_driver_set_wpa_ie(intdata->intName, wpa_ie, wpa_ie_len);
#else
  return 0;
#endif
}

int cardif_linux_wpa_enable(struct interface_data *intdata)
{
#ifdef EXPERIMENTAL
  debug_printf(DEBUG_NORMAL, "Called %s!\n", __FUNCTION__);
  return wpa_hostap_driver_wpa_enable(intdata->intName);
#else
  return 0;
#endif
}

int cardif_linux_wpa_disable(struct interface_data *intdata)
{
#ifdef EXPERIMENTAL
  debug_printf(DEBUG_NORMAL, "Called %s!\n", __FUNCTION__);
  return wpa_hostap_driver_wpa_disable(intdata->intName);
#else
  return 0;
#endif
}
