/*-
# X-BASED HEXAGONS
#
#  HexagonsP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Hexagons */

#ifndef _HexagonsP_h
#define _HexagonsP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Hexagons.h"

#ifndef BUMPSOUND
#define BUMPSOUND "c:/windows/bump.wav"
#endif 

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->hexagons.memDC)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w,x1,y1,NULL); \
  (void)LineTo(w,x2,y2)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) \
  if (dr) w->hexagons.hOldBitmap = \
  (HBITMAP) SelectObject(w->hexagons.memDC,dr); \
  w->hexagons.hPen = CreatePen(PS_SOLID, 1, c); \
  w->hexagons.hOldPen = (HPEN) SelectObject(DC(w,dr), w->hexagons.hPen); \
  LINE(DC(w,dr),x1,y1,x2,y2); \
  (void) SelectObject(DC(w,dr), w->hexagons.hOldPen); \
  (void) DeleteObject(w->hexagons.hPen); \
  if (dr) (void) SelectObject(w->hexagons.memDC,w->hexagons.hOldBitmap)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->hexagons.hOldBitmap = \
  (HBITMAP) SelectObject(w->hexagons.memDC,dr); \
  w->hexagons.hPen = CreatePen(PS_SOLID, 1, c); \
  w->hexagons.hOldPen = (HPEN) SelectObject(DC(w,dr), w->hexagons.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr), w->hexagons.hOldPen); \
  (void) DeleteObject(w->hexagons.hPen) \
  if (dr) (void) SelectObject(w->hexagons.memDC,w->hexagons.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->hexagons.hOldBitmap = \
  (HBITMAP) SelectObject(w->hexagons.memDC, dr); \
  w->hexagons.hPen = CreatePen(PS_SOLID, 1, c); \
  w->hexagons.hOldPen = (HPEN) SelectObject(DC(w,dr), w->hexagons.hPen); \
  w->hexagons.hBrush = CreateSolidBrush(c); \
  w->hexagons.hOldBrush = (HBRUSH) SelectObject(DC(w,dr), \
  w->hexagons.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr), w->hexagons.hOldBrush); \
  (void) DeleteObject(w->hexagons.hBrush); \
  (void) SelectObject(DC(w,dr), w->hexagons.hOldPen); \
  (void) DeleteObject(w->hexagons.hPen); \
  if (dr) (void) SelectObject(w->hexagons.memDC,w->hexagons.hOldBitmap)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->hexagons.hOldBitmap = \
  (HBITMAP) SelectObject(w->hexagons.memDC,dr); \
  (void) SetTextColor(DC(w,dr), c); \
  (void) SetBkMode(DC(w,dr), TRANSPARENT); \
  (void) TextOut(DC(w,dr), (x)-3, (y)-11, (LPCSTR) s, l); \
  if (dr) (void) SelectObject(w->hexagons.memDC,w->hexagons.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND hWnd;
	HDC hDC;
	HINSTANCE hInstance;
	POS width, height;
} CorePart;

extern void DestroyHexagons(HBRUSH brush);
extern void ResizeHexagons(HexagonsWidget w);
extern void SizeHexagons(HexagonsWidget w);
extern void InitializeHexagons(HexagonsWidget w, HBRUSH brush);
extern void ExposeHexagons(const HexagonsWidget w);
extern void HideHexagons(const HexagonsWidget w);
extern void SelectHexagons(HexagonsWidget w, const int x, const int y);
extern void ReleaseHexagons(HexagonsWidget w, const int x, const int y);
extern void RandomizeHexagons(HexagonsWidget w);
extern void RandomizeHexagonsMaybe(HexagonsWidget w);
extern void RandomizeHexagons2(HexagonsWidget w);
extern void ClearHexagons(HexagonsWidget w);
extern void GetHexagons(HexagonsWidget w);
extern void WriteHexagons(HexagonsWidget w);
extern void UndoHexagons(HexagonsWidget w);
extern void SolveHexagons(HexagonsWidget w);
extern void ModeHexagons(HexagonsWidget w);
extern void SpeedHexagons(HexagonsWidget w);
extern void SlowHexagons(HexagonsWidget w);
extern void SoundHexagons(HexagonsWidget w);
extern void EnterHexagons(HexagonsWidget w);
extern void LeaveHexagons(HexagonsWidget w);
extern int MoveHexagons(HexagonsWidget w, const int direction,
	const int control);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Hexagons.h"

#ifdef VMS
#ifndef BUMPSOUND
#define BUMPSOUND "[.]bump.wav"
#endif
#else
#ifndef BUMPSOUND
#if 0
#define BUMPSOUND "/usr/share/games/xpuzzles/bump.au"
#endif
#define BUMPSOUND "/usr/local/share/games/xpuzzles/bump.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif

#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) XDrawLine(XtDisplay(w),DR(w,dr),\
  c,x1,y1,x2,y2)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)
#define POLYGON(w,dr,c,lc,l,n,o) XFillPolygon(XtDisplay(w), DR(w,dr), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), DR(w,dr), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,dr,c,l,n,o) XDrawLines(XtDisplay(w), DR(w,dr), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _HexagonsClassPart {
	int ignore;
} HexagonsClassPart;

typedef struct _HexagonsClassRec {
	CoreClassPart core_class;
	HexagonsClassPart hexagons_class;
} HexagonsClassRec;

extern HexagonsClassRec hexagonsClassRec;
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TOP 6
#define BOTTOM 9
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROWTYPES 3
#define LOW 0
#define HIGH 1
#define SPACES 2

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND lrandom
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND lrand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _HexagonsPart {
	int        *tileOfPosition, spacePosition[SPACES];
	int         spaceRow[ROWTYPES];
	int         currentPosition, currentRow[ROWTYPES];
	Boolean     started, cheat, sound;
	Boolean     corners, mono, reverse, focus;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeSize, sizeCenter;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
#ifdef WINVER
	long        oldTime;
	char        username[81], bumpSound[81], picture[81];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	int         menu, graphicsFormat;
	char       *username, *bumpSound, *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	XtCallbackList select;
#endif
} HexagonsPart;

typedef struct _HexagonsRec {
	CorePart core;
	HexagonsPart hexagons;
} HexagonsRec;

extern int *startPosition;
extern void SetHexagons(HexagonsWidget w, int reason);
extern int MoveHexagonsDir(HexagonsWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(HexagonsWidget w);
#endif
extern void DrawAllTiles(const HexagonsWidget w);
extern Boolean CheckSolved(const HexagonsWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int MadeMoves(void);
extern void FlushMoves(HexagonsWidget w);
extern int NumMoves(void);
extern void ScanMoves(FILE * fp, HexagonsWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, HexagonsWidget w);
extern void PrintStartPosition(FILE * fp, HexagonsWidget w);
extern void SetStartPosition(HexagonsWidget w);
extern int Row(HexagonsWidget w, const int pos);
extern int TrBl(HexagonsWidget w, const int pos, const int posRow);
extern int TlBr(HexagonsWidget w, const int pos, const int posRow);

#endif /* _HexagonsP_h */
