/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __MPEG_HEADER_INFO_H__
#define __MPEG_HEADER_INFO_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_MPEG_HEADER_INFO            (mpeg_header_info_get_type ())
#define MPEG_HEADER_INFO(obj)            (GTK_CHECK_CAST ((obj), TYPE_MPEG_HEADER_INFO, InputTimeDialog))
#define MPEG_HEADER_INFO_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_MPEG_HEADER_INFO, InputTimeDialog))
#define IS_MPEG_HEADER_INFO(obj)         (GTK_CHECK_TYPE ((obj), TYPE_MPEG_HEADER_INFO))
#define IS_MPEG_HEADER_INFO_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_MPEG_HEADER_INFO))

typedef struct _MPEGHeaderInfo       MPEGHeaderInfo;
typedef struct _MPEGHeaderInfoClass  MPEGHeaderInfoClass;

struct _MPEGHeaderInfo {

	GtkObject  object;

	gchar *filename;

	gint   frames;
	gint   filesize;
	gint   length;

	gboolean mpeg_25;
	gint     mpeg_version;
	gint     mpeg_layer;

	gboolean bitrate_variable;
	gint bitrate;
	gint samplerate;
	gint channel_mode;
	gint emphasis;

	gboolean error_protection;
	gboolean copyright;
	gboolean original;
};

struct _MPEGHeaderInfoClass {

	GtkObjectClass parent_class;
};

enum {
	MPG_MD_STEREO = 0,
	MPG_MD_JOINT_STEREO,
	MPG_MD_DUAL_CHANNEL,
	MPG_MD_MONO
};

GtkType          mpeg_header_info_get_type (void);
MPEGHeaderInfo*  mpeg_header_info_new      (gchar *filename);
void             mpeg_header_info_free     (MPEGHeaderInfo* header);

gboolean         mpeg_header_info_detect_by_content(gchar *filename);

#endif // __MPEG_HEADER_INFO_H__
