/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __LTDL_WRAPPER_H__
#define __LTDL_WRAPPER_H__

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined (__STDC__) || defined (_AIX) || (defined (__mips) && defined (_SYSTYPE_SVR4)) || defined(WIN32) || defined(__cplusplus)
# define lt_ptr		void*
#else
# define lt_ptr		char*
#endif

typedef	struct lt_dlhandle_struct *lt_dlhandle;	// * A loaded module *

// * Initialisation and finalisation functions. *
extern	int	    wrp_dlinit		(void);
extern	int	    wrp_dlexit		(void);

// * Portable  versions of the system dlopen() API. *
extern	lt_dlhandle wrp_dlopen		(const char *filename);
extern	lt_ptr	    wrp_dlsym		(lt_dlhandle handle,
					 const char *name);
extern	const char* wrp_dlerror		(void);
extern	int	    wrp_dlclose		(lt_dlhandle handle);

extern  int         wrp_is_libname      (const char *filename);
extern  int         wrp_is_same_libname (lt_dlhandle handle, const char *filename);
extern  const char* wrp_get_libname     (lt_dlhandle h);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __LTDL_WRAPPER_H__
