/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2003 Nicolas Adenis-Lamarre (aspegic500@free.fr)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <gtk/gtksignal.h>
#include <gtk/gtkmain.h>

#include "singit/macros.h"
#include "singit/displayer_plugin.h"
#include "singit/wgt_karaoke.h"

#include "displayer_xosd_status.h"
#include "displayer_xosd_config.h"

#include "dlg_config.h"
#include "dlg_about.h"

static void displayer_xosd_init(void);
static void displayer_xosd_finish(void);
static void displayer_xosd_set_time(guint time, GList *real_next);
static void displayer_xosd_config_update(void);
static void displayer_xosd_configure(void);
static void displayer_xosd_set_song(SingitSong *new_song);

DisplayerPlugin xosd_dp =
{
	NULL,
	NULL,
	0,
	0,
	NULL,

	"Xosd displayer",

	displayer_xosd_init,
	displayer_xosd_finish,
	displayer_xosd_config_update,

	displayer_xosd_set_song,
	displayer_xosd_set_time,

	dlg_about,
	displayer_xosd_configure,
	NULL,
	NULL,

	NULL,
	NULL
};

DIPSPLAYER_SYMBOL(libdisplayer_xosd, xosd_dp)

static gint displayer_xosd_disable_func(gpointer data)
{
	GDK_THREADS_ENTER();
	xosd_dp.disable(&xosd_dp);
	GDK_THREADS_LEAVE();
	return (FALSE);
}

static void displayer_xosd_init(void)
{
	if (xosd_status_ref() == NULL) {
		gtk_idle_add (displayer_xosd_disable_func, NULL);
		return;
	}
}

static void displayer_xosd_set_time(guint time, GList *real_next)
{
	if (xosd_status_ref() == NULL)
		{ return; }

	if (displayer_xosd_status_update(STATUS) != 0)
		fprintf(stderr, "Singit : string can't be displayed\n");

	xosd_status_unref(NULL);
}

static void displayer_xosd_finish(void)
{
	xosd_status_unref(NULL);
}

static void displayer_xosd_config_update(void)
{
	singit_config_gen_emit_update(STATUS->m_config);
}

static void displayer_xosd_configure(void) {

	dlg_config_main();
}

static void displayer_xosd_set_song(SingitSong *new_song)
{
	SingitSong *tmp_song;

	g_return_if_fail(STATUS != NULL);

	tmp_song = displayer_xosd_status_get_song(STATUS);
	displayer_xosd_status_set_song(STATUS, singit_song_attach(new_song));
	singit_song_detach(&tmp_song);

	if (new_song && singit_song_lyrics_found(new_song)) {
		displayer_xosd_status_show(STATUS);
	}
	else { displayer_xosd_status_hide(STATUS); }
}
