#ifndef __TimeBasedScript_H
#define __TimeBasedScript_H

#include "UtilStr.h"
#include "CEgIFile.h"
#include "nodeClass.h"

#include "MirroredFileSys.h"

class CEgFileSpec;

class TimeBasedScript : public nodeClass {



	public:
		
								TimeBasedScript();
								
								
		// Returns false if failed to load the script file
		bool					Assign( const CEgFileSpec* inSpec );
		bool					Assign( MirroredFileSys* inFileSys, FileObj inFileID );
		void					Assign( const UtilStr& inCmdLine );
			
		void					Start( float inTime );
		
		bool					GetNextCmd( float inTime, UtilStr& outCmd );

		bool					Done()						{ return mIsDone;		}

	protected:
	
		float					mNextCmdTime, mStartTime;
		CEgIStream				mScript;
		UtilStr					mScriptBuf;
		UtilStr					mTemp, mTemp2;		
		bool					mIsDone;		
		
		void					PopNextEvent();				

};

#endif

