/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xmlresume.filter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.xmlresume.filter.FileWriterHandler;
import net.sourceforge.xmlresume.filter.TargetFilter;

public class Filter {
    public static void main(String[] argv) throws Throwable {
        FileWriterHandler writer;
        int debugLevel = 9;
        int i = 0;
        Vector<String> targetList = new Vector<String>();
        File in = null;
        File outfile = null;
        PrintStream out = System.out;
        while (i < argv.length) {
            if ("-v".equals(argv[i]) || "--verbose".equals(argv[i])) {
                debugLevel = 0;
                ++i;
                continue;
            }
            if ("-in".equals(argv[i])) {
                in = new File(argv[i + 1]);
                i += 2;
                continue;
            }
            if ("-out".equals(argv[i])) {
                outfile = new File(argv[i + 1]);
                outfile.createNewFile();
                if (!outfile.canWrite()) {
                    throw new Error("Error: can't open file " + outfile + " for writing.");
                }
                i += 2;
                out = new PrintStream(new FileOutputStream(outfile), false);
                continue;
            }
            StringTokenizer stTarget = new StringTokenizer(argv[i], " \t\n\r\f,");
            while (stTarget.hasMoreTokens()) {
                targetList.addElement(stTarget.nextToken());
            }
            ++i;
        }
        if (in == null || argv.length < 2 || "-h".equals(argv[0]) || "--help".equals(argv[0])) {
            throw new Error("Filter -- preprocess an XMLResume to select for elements in a given target\nUsage: java Filter [-v|--verbose] -in <in_file> [-out <out_file>] [target1 [target2 [...]]\nIf -out <out_file> is not specified, output will be printed on STDOUT.");
        }
        if (!in.canRead()) {
            throw new Error("Error: can't open file " + in + " for reading.");
        }
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        TargetFilter filter = new TargetFilter(parser.getXMLReader(), ((AbstractList)targetList).iterator(), debugLevel);
        try {
            writer = new FileWriterHandler(out, debugLevel, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Your platform does not support the UTF-8 encoding, which is required for using Filter\n");
        }
        filter.parse(in, writer);
    }
}

