#ifndef INC_NETIO_H
#define INC_NETIO_H

#include "lcp3.h"

/* netio_handle_data
	will read on sock, send acks as needed and return a newly
	allocated buffer containing the received command.
	The buffer has to be free()d when not needed anymore.
	the socket must be a blocking socket!
	The returned buffer contains a lcp3 packet and has
	the appropriate size [int get_lcp3_pack_size(int cmd);].
	The buffer is only valid (allocated) if != 0 gets returned.
*/
int netio_handle_data(int sock, struct t_lcp3_cmd ** recv_data);

/* netio_initiate_tcp_connection
	creates a socket ( which gets returned or -1 on error )
	and establishes a tcp connection to the specified server.
	hostname might be an IP address or a fully qualified hostname.
*/
int netio_initiate_tcp_connection(const char * hostname, unsigned short port);

/* netio_cmd_send
	tries to queue cmd, returns 1 on success and 0 else.
	info has to be freed... netio_cmd_queue doesn't do this
*/
int netio_cmd_queue(int cmd, const void * info, int infosize);

/* netio_set_line_id
	you have to call netio_set_line_id
	before any lineselection (CMD3_LINESEL)
*/
void netio_set_line_id(int id);

/* either you call netio_initiate_tcp_connection or netio_set_socket !
	sock will be used for sending and receiving commands
*/
void netio_set_socket(int sock);

/* netio_proc_queue()
	call it every 3 or so seconds as long as it returns 1
	if it returned 0 you may stop (continueing is ok) calling it
	until you queued the next command.
*/
int netio_proc_queue();

#endif
