/*
 * Supporting functions for Xdialog.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#ifdef STDC_HEADERS
#	include <stdlib.h>
#	include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif

#include "support.h"
#include "interface.h"

/* Global structures and variables */
extern Xdialog_data Xdialog;
extern gboolean dialog_compat;

/* Two useful functions to avoid buffer overflows... */

void strcpysafe(char *dest, char *source, int destsize)
{
	if (strlen(source) < destsize)
		strcpy(dest, source);
	else {
		strncpy(dest, source, destsize-1);
		dest[destsize-1] = 0;
	}
}

void strcatsafe(char *dest, char *source, int destsize)
{
	if (strlen(source)+strlen(dest) < destsize)
		strcat(dest, source);
	else {
		strncat(dest, source, destsize-strlen(dest)-1);
		dest[destsize-1] = 0;
	}
}

#ifdef HAVE_STRSTR
/* "\n" to linefeed translation */

void backslash_n_to_linefeed(char *s0, char *s, int max_len)
{
	char *tmp;

	strcpysafe(s, s0, max_len);

	while (strstr(s, "\\n") != NULL) {
		tmp = strstr(s, "\\n");
		strcpy(tmp, tmp+1);
		*tmp = '\n';
	}

}

/*
 * This function was borrowed from cdialog-0.9a "util.c" (and sligthly changed)...
 *
 * Change embedded "\n" substrings to '\n' characters and tabs to single
 * spaces.  If there are no "\n"s, it will strip all extra spaces, for
 * justification.  If it has "\n"'s, it will preserve extra spaces.  If cr_wrap
 * is set, it will preserve '\n's.
 */
void trim_string(char *s0, char *s, int max_len)
{
	char *p1;
	char *p = s;
	int has_newlines = 0;

	strcpysafe(s, s0, max_len);

	if (strstr(s, "\\n"))
		has_newlines = 1;

	while (*p != '\0') {
		if (*p == '\t')
			*p = ' ';

		if (*p == '\\' && *(p + 1) == 'n') {
			*s++ = '\n';
			p += 2;
			p1 = p;
			/*
			 * Handle end of lines intelligently.  If '\n' follows "\n" then
			 * ignore the '\n'.  This eliminates the need escape the '\n'
			 * character (no need to use "\n\").
			 */
			while (*p1 == ' ')
				p1++;
			if (*p1 == '\n')
				p = p1 + 1;
		} else {
			if (has_newlines) {	/* If prompt contains "\n" strings */
				if (*p == '\n') {
					if (Xdialog.cr_wrap)
						*s++ = *p++;
					else {
						/* Replace the '\n' with a space if cr_wrap is not set */
						if (*(s - 1) != ' ')
							*s++ = ' ';
						p++;
					}
				} else		/* If *p != '\n' */
					*s++ = *p++;
			} else {		/* If there are no "\n" strings */
				if (*p == ' ') {
					if (*(s - 1) != ' ') {
						*s++ = ' ';
						p++;
					} else
						p++;
				} else if (*p == '\n') {
					if (Xdialog.cr_wrap)
						*s++ = *p++;
					else if (*(s - 1) != ' ') {
						/* Strip '\n's if cr_wrap is not set. */
						*s++ = ' ';
						p++;
					} else
						p++;
				} else
					*s++ = *p++;
			}
		}
	}

	*s = '\0';
}
#else
#error strstr() function is needed by Xdialog !
#endif

/* Array allocation function */

void Xdialog_array(gint elements)
{
	Xdialog.array = g_malloc0((elements+1)*sizeof(listname));
	if (Xdialog.array == NULL) {
		fprintf(stderr,
		 	XDIALOG": problem while allocating memory, exiting !\n");
			exit(255);
	}
	Xdialog.array[elements].state = -1;
}
