/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.number.NumberFormatter;
import com.icl.saxon.number.Numberer;
import com.icl.saxon.number.Numberer_en;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.StyleElement;
import java.util.Vector;
import org.xml.sax.SAXException;

public class XSLNumber
extends StyleElement {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression expr = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private static Numberer defaultNumberer = new Numberer_en();

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String[] stringArray = new String[]{"value", "count", "from", "level", "format", "grouping-size", "grouping-separator", "lang", "letter-value"};
        this.allowAttributes(stringArray);
        String string6 = this.getAttributeValue("value");
        if (string6 != null) {
            this.expr = Expression.make(string6, this);
        }
        if ((string5 = this.getAttributeValue("count")) != null) {
            this.count = Pattern.make(string5, this);
        }
        if ((string4 = this.getAttributeValue("from")) != null) {
            this.from = Pattern.make(string4, this);
        }
        if ((string3 = this.getAttributeValue("level")) == null) {
            this.level = 0;
        } else if (string3.equals("single")) {
            this.level = 0;
        } else if (string3.equals("multiple")) {
            this.level = 1;
        } else if (string3.equals("any")) {
            this.level = 2;
        } else {
            throw this.styleError("Invalid value for level attribute");
        }
        if (this.level == 0 && this.from == null && this.count == null) {
            this.level = 3;
        }
        if ((string2 = this.getAttributeValue("format")) != null) {
            this.format = AttributeValueTemplate.make(string2, this);
            if (this.format instanceof StringValue) {
                this.formatter = new NumberFormatter();
                this.formatter.prepare(((StringValue)this.format).asString());
            }
        } else {
            this.formatter = new NumberFormatter();
            this.formatter.prepare("1");
        }
        String string7 = this.getAttributeValue("grouping-size");
        String string8 = this.getAttributeValue("grouping-separator");
        if (string8 != null && string7 != null) {
            this.groupSize = AttributeValueTemplate.make(string7, this);
            this.groupSeparator = AttributeValueTemplate.make(string8, this);
        }
        if ((string = this.getAttributeValue("lang")) == null) {
            this.numberer = defaultNumberer;
        } else {
            this.lang = AttributeValueTemplate.make(string, this);
            if (this.lang instanceof StringValue) {
                this.numberer = XSLNumber.makeNumberer(((StringValue)this.lang).asString());
            }
        }
        String string9 = this.getAttributeValue("letter-value");
        if (string9 != null) {
            this.letterValue = AttributeValueTemplate.make(string9, this);
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public void process(Context context) throws SAXException {
        String string;
        Object object;
        NodeInfo nodeInfo = context.getCurrentNode();
        int n = -1;
        Vector<Integer> vector = null;
        if (this.expr != null) {
            n = (int)this.expr.evaluateAsNumber(context);
        } else if (this.level == 3) {
            n = nodeInfo.getNumberSimple(context);
        } else if (this.level == 0) {
            n = nodeInfo.getNumberSingle(this.count, this.from, context);
        } else if (this.level == 2) {
            n = nodeInfo.getNumberAny(this.count, this.from, context);
        } else if (this.level == 1) {
            vector = nodeInfo.getNumberMulti(this.count, this.from, context);
        }
        int n2 = 0;
        String string2 = "";
        if (this.groupSize != null) {
            object = this.groupSize.evaluateAsString(context);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("group-size must be numeric");
            }
        }
        if (this.groupSeparator != null) {
            string2 = this.groupSeparator.evaluateAsString(context);
        }
        if (vector == null && this.format == null && n2 == 0 && this.lang == null) {
            context.getOutputter().writeContent("" + n);
            return;
        }
        if (this.numberer == null) {
            this.numberer = XSLNumber.makeNumberer(this.lang.evaluateAsString(context));
        }
        if (this.letterValue == null) {
            string = "";
        } else {
            string = this.letterValue.evaluateAsString(context);
            if (!string.equals("alphabetic") && !string.equals("traditional")) {
                throw this.styleError("letter-value must be \"traditional\" or \"alphabetic\"");
            }
        }
        if (vector == null) {
            vector = new Vector<Integer>();
            vector.addElement(new Integer(n));
        }
        if (this.formatter == null) {
            object = new NumberFormatter();
            ((NumberFormatter)object).prepare(this.format.evaluateAsString(context));
        } else {
            object = this.formatter;
        }
        String string3 = ((NumberFormatter)object).format(vector, n2, string2, string, this.numberer);
        context.getOutputter().writeContent(string3);
    }

    protected static Numberer makeNumberer(String string) throws SAXException {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "com.icl.saxon.number.Numberer_";
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            try {
                numberer = (Numberer)Loader.getInstance(string2);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

