/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.ProxyEmitter;
import org.xml.sax.SAXException;

public class XMLIndenter
extends ProxyEmitter {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameline = false;
    private boolean afterTag = true;
    private boolean allWhite = true;

    public void startDocument() throws SAXException {
        super.startDocument();
        this.indentSpaces = this.outputDetails.getIndentSpaces();
        String string = this.outputDetails.getOmitDeclaration();
        this.afterTag = string == null || !string.equals("yes") || this.outputDetails.getDoctypeSystem() != null;
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(name, attributeCollection);
        ++this.level;
        this.sameline = true;
        this.afterTag = true;
        this.allWhite = true;
    }

    public void endElement(Name name) throws SAXException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement(name);
        this.sameline = false;
        this.afterTag = true;
        this.allWhite = true;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
        this.afterTag = true;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        while (n3 < n2) {
            if (cArray[n3] == '\n') {
                this.sameline = false;
            }
            if (!Character.isWhitespace(cArray[n3])) {
                this.allWhite = false;
            }
            ++n3;
        }
        super.characters(cArray, n, n2);
        if (!this.allWhite) {
            this.afterTag = false;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        super.comment(cArray, n, n2);
        this.afterTag = true;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    private void indent() throws SAXException {
        int n = this.level * this.indentSpaces;
        while (n > this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        char[] cArray = new char[n + 1];
        cArray[0] = 10;
        this.indentChars.getChars(0, n, cArray, 1);
        super.characters(cArray, 0, n + 1);
        this.sameline = false;
    }
}

