/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Decoder_H
#define	FSK441Decoder_H

#include <wx/string.h>

#include "common/Average.h"

#include "fsk441/FSK441Defs.h"
#include "fsk441/FSK441BurstData.h"

class CFSK441Decoder {

    public:
	CFSK441Decoder(const wxString& fileName, double startRatio, double endRatio);
	~CFSK441Decoder();

	void run();

    private:
	wxString         m_fileName;
	double           m_startRatio;
	double           m_endRatio;
	CAverage         m_noise;
	int              m_DF;
	double*          m_audioData;
	int              m_audioLen;
	CFSK441BurstData m_burstData;

	int  seekBurst(double* bins);
	int  storeBurst(double* bins);
	void decodeBurst();
};

#endif
