/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441CardReceive.h"
#include "FSK441Defs.h"

#include "FSK441App.h"

#include "common/SoundFile.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/filename.h>
#include <wx/log.h>

CFSK441CardReceive::CFSK441CardReceive(const wxString& name, ISoundDev* soundDev, EWho who) :
CFSK441Receive(name, who),
m_soundDev(soundDev)
{
	wxASSERT(m_soundDev != NULL);
}

CFSK441CardReceive::~CFSK441CardReceive()
{
}

bool CFSK441CardReceive::getEndTime()
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 250);
}

void CFSK441CardReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openRead();
}

void CFSK441CardReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
}

void CFSK441CardReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);

	if (isRecording()) {
		wxString pathAudio, pathText;
		::wxGetApp().getPaths(pathAudio, pathText);

		wxFileName fileName(pathAudio, id, wxT("wav"));

		CSoundFile* file = new CSoundFile(fileName.GetFullPath(), FSK441_SAMPLE_RATE, 8);
		file->openWrite();

		file->write(audioData, length);

		file->close();

		delete file;
	}
}

wxString CFSK441CardReceive::createId()
{
	wxDateTime now = wxDateTime::Now();

	return now.Format(wxT("%Y%m%d_%H%M%S"), wxDateTime::UTC);
}

void CFSK441CardReceive::error(const wxString& text)
{
	::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
