/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	SoundFile_H
#define	SoundFile_H

#include "SoundDev.h"

#include <wx/wx.h>

#ifdef __WINDOWS__
#include <windows.h>
#include <mmsystem.h>
#else
#include <sndfile.h>
#endif

enum EReadWrite {
	SoundFile_Read,
	SoundFile_Write
};

class CSoundFile : public ISoundDev {

    public:
    	CSoundFile(const wxString& fileName, int sampleRate, int sampleWidth = 8);
	virtual ~CSoundFile();

	virtual void openWrite();
	virtual void openRead();

	virtual void read(double* sample, int& len);
	virtual void write(double* sample, int len);

	virtual void close();

    private:
	wxString   m_fileName;
	int        m_sampleRate;
	int        m_sampleWidth;
	EReadWrite m_direction;
#ifdef __WINDOWS__
	HMMIO      m_handle;
	MMCKINFO   m_parent;
	MMCKINFO   m_child;
#else
	SNDFILE*   m_file;
#endif
};

#endif
