// $Id: HeightFieldCommand.h,v 1.3 2002/10/08 09:12:56 zongo Exp $
#ifndef WE_HEIGHTFIELD_COMMAND_H
#define WE_HEIGHTFIELD_COMMAND_H

#include <string>
#include <deque>
#include <utility>

#include "World.h"
#include "Command.h"


class HeightFieldCommand : public Command
{
  // State information for undo/redo
  protected:
    // HF to operate on
    Ark::HeightField* m_World;
  
    // Data typedef
    typedef unsigned int IndexType;
    typedef short DataType;
    typedef std::pair<IndexType, DataType> HFCPair;
    
    // List type and iterator defs
    typedef std::deque< HFCPair > HFCList;
    typedef HFCList::iterator HFCIterator;

    // State data
    HFCList m_State;

    // Corners of changes for invalidation of HF
    Ark::BBox m_ChangeBox;

    // Type of command
    std::string m_Type;
    
  public:
    HeightFieldCommand(World* hf, const std::string& type);
    virtual ~HeightFieldCommand();

    virtual std::string Type() const { return m_Type; }

    /// Execute this command.
    virtual void Execute() { ExchangeState(); }

    /// Undo the action done by this command.
    virtual void Unexecute() { ExchangeState(); }

    /// Push a new change in the state
    void AddState(IndexType, DataType);

  protected:
    virtual void ExchangeState() = 0;

};


class HFEHCommand : public HeightFieldCommand
{
    public:
	inline HFEHCommand(World* hf, const std::string& type)
	    : HeightFieldCommand(hf, type) {}

    protected:
	virtual void ExchangeState();
};


class HFCGCommand : public HeightFieldCommand
{
    public:
	inline HFCGCommand(World* hf, const std::string& type)
	    : HeightFieldCommand(hf, type) {}

    protected:
	virtual void ExchangeState();
};


#endif // WE_HEIGHTFIELD_COMMAND_H
