

#ifndef _MINIWINDOW_H_
#define _MINIWINDOW_H_

#include <qwidget.h>
#include "QSimpleTextBrowser.h" //KDE3 ???

class QString;
//class QSimpleTextBrowser;
class QConfig;

class MiniWindow : public QWidget
{
	Q_OBJECT

public:
	MiniWindow();

	~MiniWindow();

	QSimpleTextBrowser *browser() { return _browser; };

	QString text();

	void save(QConfig *conf);
	void load(QConfig *conf);

	void save();
	void load();

	static MiniWindow *defaultWindow();
	static void setConf( QConfig * _conf );

public slots:
	void setText( const QString & texto );
	virtual void show();

protected:
	void mousePressEvent( QMouseEvent*) { hide(); };
	bool eventFilter( QObject *, QEvent *e );
	void keyPressEvent (QKeyEvent *e);

private:
	QSimpleTextBrowser * _browser;
	static MiniWindow *miniwindow;
	static QConfig * conf;
};


#endif
