/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "QSimpleTextBrowser.h"
#include "urlmanager.h"

#include <qapplication.h>
#include <qfile.h>
#include <qtextstream.h>
//#include <qfiledialog.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qmessagebox.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qcursor.h> //QT3
#include <qdragobject.h>

#include <qclipboard.h>
#include <qpixmap.h>
#include <qtextcodec.h>
#include "qdialogos.h"
#include "qfunciones.h"
//#include "tile.cpp" //Imagen de fondo
#include "intern.h"

//Pixmaps
#include "iconos.h"


QMimeSource *last_text;

MyMimeSourceFactory::MyMimeSourceFactory() : QMimeSourceFactory() {
	last_text = 0;

	//setText("default", _("Working...") );

	/*
	QPixmap fondo_presentacion;
	fondo_presentacion.loadFromData( tile_png, tile_png_len );
	setPixmap( "tile.png", fondo_presentacion );
	*/
}

MyMimeSourceFactory::~MyMimeSourceFactory() {
	if (last_text != 0 ) {
		//qDebug("MyMimeSourceFactory::~MyMimeSourceFactory: Destruyendo last_text");
		delete last_text;
	}
}


const QMimeSource* MyMimeSourceFactory::data( const QString & abs_name ) const {
	if ( (abs_name.left(5) == "dict:") || (abs_name.left(5) == "http:") || 
         (abs_name.left(6) == "about:") ) 
	{
		QMimeSource *r= new QTextDrag( url_manager->text(abs_name) );

		if (last_text != 0 ) {
			//qDebug("MyMimeSourceFactory::data: Destruyendo last_text");
			delete last_text;
		}
		last_text = r;
		return r;
	} else {
		return QMimeSourceFactory::data(abs_name);
	}

	//return QMimeSourceFactory::data("default");
	/*
	setText( abs_name, (const) url_manager->text(abs_name, true) );
	return QMimeSourceFactory::data(abs_name);

	return new QTextDrag( url_manager->text(abs_name, true) );
	*/

	/*
	//Se permite cargar grficos. Lo dems se considera que es el
	//texto a buscar.
	//Nota: si se busca algn texto que contenga alguna de las
	//extensiones para los grficos la hemos fastidiado...
	//debug("MyMimeSourceFactory::data: abs_name= %s", abs_name.latin1());
	if ( (abs_name.contains(".bmp") != 0) || 
         (abs_name.contains(".png") != 0) || 
		 (abs_name.contains(".xpm") != 0) )
		return QMimeSourceFactory::data(abs_name);
	else
		return QMimeSourceFactory::data("default");
	*/
}

MyStyleSheet::MyStyleSheet( 
	QObject * parent,
	const char * name ) : QStyleSheet( parent, name )
{
	//QStyleSheet::setDefaultSheet( this );
}

void MyStyleSheet::error( const QString & s ) const {
	debug( s.latin1() );
}


QSimpleTextBrowser::QSimpleTextBrowser(
	QWidget * parent, const char *name ) : QTextBrowser(parent,name)
{
	QMimeSourceFactory *f=new MyMimeSourceFactory();
	setMimeSourceFactory(f);

	setStyleSheet( new MyStyleSheet(this, "mystylesheet") );

	styleSheet()->item("p")->setMargin( QStyleSheetItem::MarginBottom, 0 );
	styleSheet()->item("p")->setMargin( QStyleSheetItem::MarginTop, 0 );

/*
	debug("Left: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginLeft ) );
	debug("Right: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginRight ) );
	debug("Top: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginTop ) );
	debug("Bottom: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginBottom ) );
	debug("All: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginAll ) );
	debug("Vertical: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginVertical ) );
	debug("Horizontal: %d", styleSheet()->item("p")->margin( QStyleSheetItem::MarginHorizontal ) );
*/

	menu = new QPopupMenu(this, "menu_qsimpletextbrowser");
#if QT_VERSION >= 210
	//menu->insertItem( _("Select all and copy"), this, SLOT( copia_texto() ) );
	menu->insertItem( icono_copiar(), _("&Copy"), this, SLOT( copy() ) );
	menu->insertItem( _("Select &all"), this, SLOT( selectAll() ) );
#else
	menu->insertItem( _("&Copy text to clipboard"), this, SLOT( copia_texto() ) );
#endif
	menu->insertSeparator();
	menu->insertItem( _("Change &font..."), this, SLOT( cambia_font() ) );
	menu->insertItem( _("Change &background color..."), this, SLOT( cambia_color() ) );
	menu->insertSeparator();
	menu->insertItem( icono_imprimir(), _("&Print..."), this, SLOT( imprimir() ) );
	menu->insertItem( icono_grabar(), _("&Save..."), this, SLOT( grabar() ) );

	name_of_last="";
	encoding_charset="ISO 8859-1";

#if QT_VERSION >= 300
	cambia_color( QColor("white") );
#endif
}


QSimpleTextBrowser::~QSimpleTextBrowser() {
	delete menu;
}

void QSimpleTextBrowser::setSource( const QString & name ) {
	if (name.isEmpty()) return;
	//debug("setSource: '%s'", name.latin1() );

	name_of_last= name;

//FIXME: las descripciones de los diccionarios no se refrescan con Qt 3
//#if QT_VERSION < 300
	//Mal truco para refrescar la vista.
	if (name == source() ) {
		qDebug("QSimpleTextBrowser::setSource: Reloading page...");
		if ( (name.left(5) == "dict:") || (name.left(5) == "http:") || 
             (name.left(6) == "about:") ) {
			setText( url_manager->text(name) );
			return;
		}
	}
//#endif

	QTextBrowser::setSource( name );
	//emit anchor_clicked( name );

	//setText( url_manager->text(name, true) );
}

void QSimpleTextBrowser::setText( const QString & text, const QString & context) {
	if (text.isNull()) { QTextBrowser::setText( this->text(), context ); return; }
	//if ( text == "wordtrans_dont_show" ) return;
	//debug("setText: '%s', context: '%s'", text.latin1(), context.latin1() );
	QTextBrowser::setText( text, context );
}

void QSimpleTextBrowser::activa_popupmenu() {
	menu->setFont( QApplication::font() ); // Para no usar el mismo font que el widget
	menu->popup( QCursor::pos() ); 
}


void QSimpleTextBrowser::copia_texto() {
//#if QT_VERSION >= 222
//	selectAll();
//	copy();
//#else
	QClipboard *cb = QApplication::clipboard();
	cb->setText( text() );
//#endif
}

void QSimpleTextBrowser::cambia_font() {
	setDefaultFont( QFontDialog::getFont( 0, font() ) );
	emit( fontCambiado( font() ) ); 
}

void QSimpleTextBrowser::cambia_color() {
	QColor c= QColorDialog::getColor( colorFondo(), this );
	cambia_color( c );	
}

void QSimpleTextBrowser::cambia_color(QColor c) {
	if (c.isValid() ) {
#if QT_VERSION < 300
		QColorGroup grp=paperColorGroup();
		grp.setColor( QColorGroup::Base, c );
		setPaperColorGroup( grp );
#else
		setPaper( QBrush( c ) );
#endif
	}
}

QColor QSimpleTextBrowser::colorFondo() {
#if QT_VERSION >=300
	return paper().color();
#else
	QColorGroup grp=paperColorGroup();
	return grp.base();
#endif
}

void QSimpleTextBrowser::setDefaultFont( const QFont & f) {
	default_font=f;
	emit( changedDefaultFont(f) );
	setFont( f );
	setText( text() );
}

QFont QSimpleTextBrowser::defaultFont() { 
	return default_font; 
}


void QSimpleTextBrowser::viewportMousePressEvent( QMouseEvent *e) {
	QTextBrowser::viewportMousePressEvent(e);

//Lo siguiente no es necesario en Qt 3
#if QT_VERSION < 300
	if ( e->button() == RightButton ) {
		activa_popupmenu();
	}
#endif
}

void QSimpleTextBrowser::imprimir() {
	imprimir_textview(this);
}

void QSimpleTextBrowser::grabar() {
	QString fichero( Dialogos::grabar() );
	if (!fichero.isNull()) {
		QTextCodec *codec = QTextCodec::codecForName( getCharset().latin1() );
		QFile f( fichero );
		if (f.exists()) {
			if ( QMessageBox::information(0, "wordtrans",
				 _("File %1 already exists.\nAre you sure you want to "
                 "overwrite it?").arg(fichero), _("&Yes"), _("&No"), 
                 QString::null, 0, 1) == 1 ) 
			{
				qDebug("Not saving '%s'", fichero.latin1());
				return;
			}
		}
        if (f.open( IO_WriteOnly ) ) {
			QTextStream t( &f );
			if (codec!=NULL) {
				qDebug("Saving using this codec: '%s'", getCharset().latin1());
				t.setCodec( codec );
			}
			t << text();
			f.close();
		}
	}
}

/*
void QSimpleTextBrowser::slot_linkClicked(const QString & link) {
//Esto es un poco chapucero
#if QT_VERSION >= 300
	emit anchor_clicked( link );
#endif
}
*/


#include "QSimpleTextBrowser.moc.cpp"

