/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFDNS_H
#define _WFDNS_H

#include <list>
#include <iostream>
#include <string>

#include "wfipaddr.h"

/* It is quite inefficient: change it for a container. RV@@7 */

/**
 * 
 */
class wf_dns_entry {
 public:
  wf_dns_entry() {}
  virtual ~wf_dns_entry() {}
  // wf_dns_entry(const wf_dns_entry&) implicit copy constructor

  ostream& print(ostream& os) const;
  friend ostream& operator<<(ostream& os, const wf_dns_entry& dns_entry);

 public:
  wf_ipaddr ipaddr;
  string name;
};

/**
 * 
 */
class wf_dns {
 public:
  wf_dns();
  wf_dns(unsigned char verb);
  virtual ~wf_dns() {}
  // wf_dns(const wf_dns&)  copy pointers? RV@@5

  wf_dns_entry* resolv(const wf_ipaddr& ipaddr);
  wf_dns_entry* resolv(const string& dnsname);

  void cache_add(const wf_dns_entry* dns_entry);
  wf_dns_entry* cache_get(const wf_ipaddr& ipaddr) const;
  wf_dns_entry* cache_get(const string& dnsname) const;
  ostream& cache_debugprint(ostream& os) const;

 public:
  list<wf_dns_entry*> cache;
  unsigned char verbose;
};

#endif
