#!/usr/local/bin/perl
# save_user.cgi
# Create, update or delete a password file user

require './htaccess-lib.pl';
&ReadParse();
&error_setup($text{'save_err'});
@dirs = &list_directories();
($dir) = grep { $_->[0] eq $in{'dir'} } @dirs;
&can_access_dir($dir->[0]) || &error($text{'dir_ecannot'});
&lock_file($dir->[1]);

&switch_user();
$users = &list_users($dir->[1]);
if (!$in{'new'}) {
	$user = $users->[$in{'idx'}];
	$loguser = $user->{'user'};
	}
else {
	$loguser = $in{'user'};
	}

if ($in{'delete'}) {
	# Just delete this user
	&delete_user($user);
	}
else {
	# Validate inputs
	$in{'user'} || &error($text{'save_euser1'});
	$in{'user'} =~ /:/ && &error($text{'save_euser2'});
	if ($in{'new'} || $user->{'user'} ne $in{'user'}) {
		($clash) = grep { $_->{'user'} eq $in{'user'} } @$users;
		$clash && &error($text{'save_eclash'});
		}
	!$in{'pass_def'} && $in{'pass'} =~ /:/ && &error($text{'save_epass'});

	# Actually save
	$user->{'user'} = $in{'user'};
	if (!$in{'pass_def'}) {
		$user->{'pass'} = &encrypt_password(
					$in{'pass'}, undef, $dir->[2]);
		}
	$user->{'enabled'} = $in{'enabled'};
	if ($in{'new'}) {
		&create_user($user, $dir->[1]);
		}
	else {
		&modify_user($user);
		}
	}
&switch_back();

&unlock_file($dir->[1]);
&webmin_log($in{'delete'} ? "delete" : $in{'new'} ? "create" : "modify",
	    "user", $loguser, $user);
&redirect("");

