#!/usr/local/bin/perl
# index.cgi
# Display a list of scheduled dumps

require './fsdump-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);

@fslist = &supported_filesystems();
if (!@fslist && !$supports_tar) {
	print "<p>",&text('index_ecommands', "<tt>dump</tt>"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

@alldumps = &list_dumps();
@dumps = grep { &can_edit_dir($_) } @alldumps;
&foreign_require("cron", "cron-lib.pl");
if (@dumps) {
	print "<h3>$text{'index_jobs'}</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'dump_dir'}</b></td>\n";
	print "<td><b>$text{'dump_fs'}</b></td>\n";
	print "<td><b>$text{'dump_level'}</b></td>\n";
	print "<td><b>$text{'dump_dest'}</b></td>\n";
	print "<td><b>$text{'dump_sched'}</b></td>\n";
	print "<td><b>$text{'dump_when'}</b></td>\n";
	print "<td><b>$text{'index_action'}</b></td> </tr>\n";
	foreach $d (@dumps) {
		print "<tr $cb>\n";
		@dirs = &dump_directories($d);
		$dirs = join("<br>", map { &html_escape($_) } @dirs);
		if ($access{'edit'}) {
			print "<td><a href='edit_dump.cgi?id=$d->{'id'}'><tt>",
			      $dirs,"</tt></a></td>\n";
			}
		else {
			print "<td><tt>",$dirs,"</tt></td>\n";
			}
		print "<td>",uc($d->{'fs'}),"</td>\n";
		print "<td>",$d->{'level'} eq "" ? "<br>" :
				&html_escape($d->{'level'}),"</td>\n";
		print "<td><tt>",&dump_dest($d),"</tt></td>\n";
		print "<td>",$d->{'enabled'} ? $text{'yes'} : $text{'no'},"</td>\n";
		if ($d->{'follow'}) {
			$f = &get_dump($d->{'follow'});
			print "<td>",&text('index_follow',
					   "<tt>$f->{'dir'}</tt>"),"</td>\n";
			}
		else {
			print "<td>",&cron::when_text($d, 1),"</td>\n";
			}
		print "<td><a href='backup.cgi?id=$d->{'id'}'>$text{'index_now'}</a></td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
elsif (!@alldumps) {
	print "<b>$text{'index_none'}</b><p>\n";
	}
else {
	print "<b>$text{'index_none2'}</b><p>\n";
	}
print "<form action=edit_dump.cgi>\n";
print "<input type=submit value='$text{'index_add'}'>\n";
print "<input name=dir size=20> ",&file_chooser_button("dir"),"\n";
if ($supports_tar && !$config{'always_tar'}) {
	print &ui_checkbox("forcetar", 1, $text{'index_forcetar'}, 0),"\n";
	}
print "</form>\n";

if ($access{'restore'}) {
	# Display restore button
	print "<hr>\n";
	print "<form action=restore_form.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td nowrap><input type=submit value='$text{'index_restore'}'>";
	print "<select name=fs>\n";
	foreach $f (&supported_filesystems(),
		    $supports_tar ? ( "tar" ) : ( )) {
		printf "<option value=%s>%s\n", $f, uc($f);
		}
	print "</select></td>\n";
	print "<td>$text{'index_restoremsg'}</td>\n";
	print "</tr></table></form>\n";
	}

# Display running backup jobs list, if any
&foreign_require("proc", "proc-lib.pl");
@procs = &proc::list_processes();
@running = grep { &can_edit_dir($_) } &running_dumps(\@procs);
if (@running) {
	print "<hr>\n";
	print "<h3>$text{'index_running'}</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'dump_dir'}</b></td>\n";
	print "<td><b>$text{'dump_dest'}</b></td>\n";
	print "<td><b>$text{'index_start'}</b></td>\n";
	print "<td><b>$text{'index_status'}</b></td>\n";
	print "<td><b>$text{'index_action'}</b></td> </tr>\n";
	foreach $d (@running) {
		@dirs = &dump_directories($d);
		$dirs = join("<br>", map { &html_escape($_) } @dirs);
		print "<tr $cb>\n";
		print "<td><tt>",$dirs,"</tt></td>\n";
		print "<td><tt>",&dump_dest($d),"</tt></td>\n";
		print "<td>",&make_date($d->{'status'}->{'start'}),"</td>\n";
		print "<td>",$text{'index_status_'.
				   $d->{'status'}->{'status'}},"</td>\n";
		print "<td>";
		if ($d->{'status'}->{'status'} eq 'running' ||
		    $d->{'status'}->{'status'} eq 'tape') {
			print "<a href='kill.cgi?id=$d->{'id'}&pid=$d->{'pid'}'>$text{'index_kill'}</a>\n";
			}
		if ($d->{'status'}->{'status'} eq 'tape') {
			print "&nbsp;|&nbsp;\n";
			print "<a href='newtape.cgi?id=$d->{'id'}&pid=$d->{'pid'}'>$text{'index_newtape'}</a>\n";
			}
		if ($d->{'status'}->{'status'} eq 'complete' ||
		    $d->{'status'}->{'status'} eq 'failed') {
			print $text{'index_noaction'};
			}
		print "</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}

&ui_print_footer("/", $text{'index'});

