#ifndef OUTPUT_MANAGER_IMPLEMENTATION_BASE_H
#define OUTPUT_MANAGER_IMPLEMENTATION_BASE_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <fstream>
#include <set>
#include <clutils/StringHashMap.h>
#include "warped.h"
#include "OutputEvents.h"
#include "OutputManager.h"

using std::ofstream;

class TimeWarpSimulationManager;

using std::multiset;

/** The OutputManagerImplementationBase class.

    This is the implementation base class from which all output
    manager implementations are derived from. This class contains all
    data common to the three support output managers: Aggressive,
    Lazy, and Adaptive.

*/
class OutputManagerImplementationBase : public OutputManager {
  friend class AggressiveOutputManagerTest;

public:

   /**@name Public Class Methods of OutputManagerImplementationBase. */
   //@{

   /** Constructor.
       @param simMgr Handle to the simulation manager.
   */
   OutputManagerImplementationBase( TimeWarpSimulationManager *simMgr );

   /// Destructor
   ~OutputManagerImplementationBase();
  
   /** Insert an event into the event set.

       @param event Ptr. to the event to be inserted.
       @param object Ptr. to the object who generated the output event. 
   */
  virtual void insert( const Event *event );
  
   /** Delete any unwanted (processed) elements.

       @param garbageCollectTime Time up to which to grbg-collect.
       @param object Simulation Object for which to grbg-collect 
   */
   virtual void garbageCollect(const VTime &garbageCollectTime,
                               SimulationObject *object);

   //@} // End of Public Class Methods of OutputManagerImplementationBase.
  
protected:
  /**@name Protected Class Methods of OutputManagerImplementationBase. */
  //@{
  OutputEvents &getOutputEventsFor( const string &objectName );
  
  TimeWarpSimulationManager *getSimulationManager(){
    return mySimulationManager;
  }

  //@} // End of Protected Class Methods of OutputManagerImplementationBase.

private:  
  /// Handle to the simulation manager.
  TimeWarpSimulationManager *mySimulationManager;

  /// Pointer to the event set.
  StringHashMap<OutputEvents *> myOutputEvents;
  
  /// Data structure used for the one-anti-message optimization.
  StringHashMap<bool> alreadySentAntiMessages;

  ofstream *myStream;
};

#endif
