/* X stream viewer by Justin Schoeman
Based on XJ module hacked from xqcam.c by Paul Chinn <loomer@svpal.org>
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include "XJ.h"

extern unsigned char *getframe(char *fname);

#define R(x) (unsigned char)(dbuf[x*3])
#define G(x) (unsigned char)(dbuf[(x*3)+1])
#define B(x) (unsigned char)(dbuf[(x*3)+2])

int width, height, dble; 
unsigned int maxframe;
char fstr[256];
unsigned char *sbuf;

void segfault(int foo)
{
 XJ_exit();
 fprintf(stderr, "AAAARRRGGGGHHHH - segfault\n");
 exit(-1);
}

void showit(unsigned int cfield)
{
 int i, j, k, temp;
 char fname[256];
 char *dbuf;
 
 sprintf(fname, fstr, cfield);
 dbuf=getframe(fname);
 if(dble==1)
 {
  k=0;
  switch(XJ_depth)
  {
   case 8:
    for(i=0; i<(2*height); i+=2)
     for(j=0; j<(2*width); j+=2)
     {
      sbuf[(i*2*width)+j]=sbuf[((i+1)*2*width)+j]=sbuf[((i+1)*2*width)+j+1]=sbuf[(i*2*width)+j+1]=
       XJ_greys[(unsigned char)((int)(R(k)+G(k)+B(k))/3)];
      k++;
     }
    break;
   case 16:
    for(i=0; i<(2*height); i+=2)
     for(j=0; j<(4*width); j+=4)
     {
      temp = R(k) >> 3;
      temp |= (int)(G(k) >> 2) << 5;
      temp |= (int)(B(k) >> 3) << 11;
      sbuf[(i*4*width)+j+1]=sbuf[((i+1)*4*width)+j+1]=sbuf[((i+1)*4*width)+j+3]=sbuf[(i*4*width)+j+3]=temp >> 8;
      sbuf[(i*4*width)+j+0]=sbuf[((i+1)*4*width)+j+0]=sbuf[((i+1)*4*width)+j+2]=sbuf[(i*4*width)+j+2]=temp & 0xff;
      k++;
     }
    break;
   case 24:
#ifndef FIX32
    for(i=0; i<(2*height); i+=2)
     for(j=0; j<(6*width); j+=6)
     {
      sbuf[(i*6*width)+j+2]=sbuf[((i+1)*6*width)+j+2]=sbuf[((i+1)*6*width)+j+5]=sbuf[(i*6*width)+j+5]=R(k);
      sbuf[(i*6*width)+j+1]=sbuf[((i+1)*6*width)+j+1]=sbuf[((i+1)*6*width)+j+4]=sbuf[(i*6*width)+j+4]=G(k);
      sbuf[(i*6*width)+j+0]=sbuf[((i+1)*6*width)+j+0]=sbuf[((i+1)*6*width)+j+3]=sbuf[(i*6*width)+j+3]=B(k);
      k++;
     }
    break;
#endif
   case 32:
    for(i=0; i<(2*height); i+=2)
     for(j=0; j<(8*width); j+=8)
     {
      sbuf[(i*8*width)+j+2]=sbuf[((i+1)*8*width)+j+2]=sbuf[((i+1)*8*width)+j+6]=sbuf[(i*8*width)+j+6]=R(k);
      sbuf[(i*8*width)+j+1]=sbuf[((i+1)*8*width)+j+1]=sbuf[((i+1)*8*width)+j+5]=sbuf[(i*8*width)+j+5]=G(k);
      sbuf[(i*8*width)+j+0]=sbuf[((i+1)*8*width)+j+0]=sbuf[((i+1)*8*width)+j+4]=sbuf[(i*8*width)+j+4]=B(k);
      k++;
     }
    break;
   default: break;
  }
 } else
 {
  switch(XJ_depth)
  {
   case 8:
    for(i=0; i<width*height; i++)
    {
     sbuf[i]=XJ_greys[(unsigned char)((int)(R(i)+G(i)+B(i))/3)];
    }
    break;
   case 16:
    for(i=0; i<(width*height); i++)
    {
     temp = R(i) >> 3;
     temp |= (int)(G(i) >> 2) << 5;
     temp |= (int)(B(i) >> 3) << 11;
     sbuf[2*i+1]=temp >> 8;
     sbuf[2*i]=temp & 0xff;
    }
    break;
   case 24:
#ifndef FIX32
    for(i=0; i<width*height; i++)
    {
     sbuf[(i*3)+2]=R(i);
     sbuf[(i*3)+1]=G(i);
     sbuf[(i*3)+0]=B(i);
    }
    break;
#endif
   case 32:
    for(i=0; i<width*height; i++)
    {
     sbuf[(i*4)+2]=R(i);
     sbuf[(i*4)+1]=G(i);
     sbuf[(i*4)+0]=B(i);
    }
    break;
   default: break;
  }
 }
 XJ_show();
}

void readpar(char *fname)
{
 FILE* par;
 char tmp[256];
 
 par=fopen(fname,"r");
 fgets(tmp, 256, par);
 fgets(fstr, 256, par);
 fstr[strlen(fstr)-1]='\0';
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &maxframe);
 maxframe--;
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &width);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &height);
 fclose(par);
}

void usage(void)
{
 printf("Usage:\n\n");
 printf(" xfv [-double] <parameter file>\n\n");
 exit(-1);
}

int main(int argc, char **argv)
{
  unsigned int cfield;
  int i;
  char k[256];

  for(i=1; (i<argc)&&(argv[i][0]=='-'); i++)
  {
    if(strcmp(argv[i],"-double")==0)
    {
     fprintf(stderr, "Displaying double size.\n");
     dble=1;
    } else usage();
  }
  
  if(argc>(i+1))usage();
  if(argc<(i+1))usage();
  fprintf(stderr, "Reading parameter file: %s .\n", argv[i]);
  readpar(argv[i]);

  /* Start X Display */
  if(dble==1)
  {
   if ((sbuf=XJ_init(2*width, 2*height, "X Stream Viewer", "XSV"))==NULL)
   {
    fprintf(stderr,"XJ_init failed, exiting\n");
    exit(1);
   }
  } else 
  {
   if ((sbuf=XJ_init(width, height, "X Stream Viewer", "XSV"))==NULL)
   {
    fprintf(stderr,"XJ_init failed, exiting\n");
    exit(1);
   }
  }
 signal(SIGSEGV, segfault);
 cfield=0;
 showit(cfield);
 fprintf(stderr, "Frame finder! (? for help)\n");

 do
 {
  fprintf(stderr, "\n%u of %u > ", cfield, maxframe);
  gets(k);
  switch(k[0])
  {
   case '\0':
   case 'f':
    cfield++;
    if(cfield>maxframe)cfield=maxframe;
    showit(cfield);
    break;
   case 'F':
    cfield+=10;
    if(cfield>maxframe)cfield=maxframe;
    showit(cfield);
    break;
   case 'b':
    if(cfield>0)cfield--;
    showit(cfield);
    break;
   case 'B':
    if(cfield>9)cfield-=10;
     else cfield=0;
    showit(cfield);
    break;
   case 'j':
    sscanf(k, "%s %d", k, &i);
    cfield+=i;
    if(cfield>maxframe)cfield=maxframe;
    showit(cfield);
    break;
   case 'g':
    sscanf(k, "%s %u", k, &cfield);
    if(cfield>maxframe)cfield=maxframe;
    showit(cfield);
    break;
   case '?':
    fprintf(stderr, "COMMANDS:\n=========\n\n");
    fprintf(stderr, "f : forward 1\n");
    fprintf(stderr, "F : forward 10\n");
    fprintf(stderr, "b : backward 1\n");
    fprintf(stderr, "B : Backward 10\n");
    fprintf(stderr, "j <offset> : Jump to current +<offset>\n");
    fprintf(stderr, "g <frame>  : Goto <frame>\n");
    fprintf(stderr, "[return]  : next\n\n");
    break;
   case 'q':
    break;
   default:
    fprintf(stderr, "Unknown command %c (? for help)\n", k[0]);
    break;
  }
 } while(k[0]!='q');

 XJ_exit();
 return 0;
}
