/* NCSA CCI for X Windows
** Software Development Group
** National Center for Supercomputing Applications
** University of Illinois at Urbana-Champaign
** 605 E. Springfield, Champaign, IL 61820
** mosaic@ncsa.uiuc.edu

** Copyright  (C)  1995 Board of Trustees of the University of Illinois
*/



char HyperGWhat[] = "@(#)[Hyper-G] [HGC-H] vrwebmc*\t1.0 [VRweb incl. Mosaic CCI] [Michael Pichler, Ed Grossman]";


#include "scenewin.h"
#include "hg3dopt.h"
#include "geomobj.h"
#include "srcanch.h"
#include "stranslate.h"

#include "imgview.h"
#include "txtview.h"

#include <hyperg/hyperg/message.h>
#include <hyperg/utils/verbose.h>
#include <hyperg/WWW/HTParse.h>
#include <InterViews/enter-scope.h>

#include <IV-look/kit.h>
#include <InterViews/display.h>
#include <InterViews/event.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>

#include <unistd.h>
#include <iostream.h>
#include <string.h>

#include "cciCaller.h"
#include "cciViewer.h"




int verbose = 0;  /* turn on/off DEBUG-messages */


/*** main ***/

int main (int argc, char* argv[]) {
  HgMessage::init ("3D Scene Viewer");

  Session* session = new Session ("Harmony", argc, argv, hg3d_options, hg3d_props);
  WidgetKit& kit = *WidgetKit::instance ();
  Style* style = new Style ("Scene", session->style ());
  kit.style (style);
  // hg3d style name: Harmony.Scene
  // always use kit.style -- session.style never changes!!!

  if (style->value_is_on ("verbose"))
    verbose = 1;

  CCISceneViewer scene(session);  // the scene

  CCICaller* caller = new SceneCCICaller(&scene);
  caller->connect(0, "");

  // read initial scene

  if (argc == 2)  // IV-options are already removed from argument list
    if (argv [1][0] == '-' && !argv [1][1])  // argument "-": stdin
    { scene.readSceneFILE (stdin);
      scene.setTitle ("<stdin>");
    }
    else                                    // argument filename
    { scene.readSceneFile (argv [1]);
      RString urlname = scene.filenameToURL(argv [1]);
      scene.setTitle (urlname);
    }
  else  // no filename on command line
  {
    RString filename;
    if (style->find_attribute ("initialDemo", filename))
    { scene.readSceneFile (filename.string ());
      scene.setTitle (filename.string ());
    }
  }

  Event ev;
  do {
    if (caller->poll())
      session->read(0, 500000, ev);
    else
      session->read(ev);
    ev.handle();
  } while (!session->done());

  return 0;

} // main

CCISceneViewer::CCISceneViewer(Session* session) :
SceneWindow(session, STranslate::VRWEBSCENEVIEWER /*"VRweb Scene Viewer"*/) {
  currentNode_ = NULL;
  currentURL_ = "";
}

void CCISceneViewer::requestInlineURL(QvWWWInline* node,                
				      const char* url,                  
				      const char* docurl) {
  char* wholeUrl =  HTParse(url, docurl,
			    PARSE_ACCESS | PARSE_HOST | PARSE_PATH |
			    PARSE_PUNCTUATION);
  DEBUGNL("CCISceneViewer: requestInlineURL " << wholeUrl);
  RString safeUrl = wholeUrl;
  currentNode_ = node;
  currentURL_ = safeUrl;
  CCICaller::instance()->follow(safeUrl);
  free(wholeUrl);  // this came from a C routine
  DEBUGNL("CCISceneViewer: return from requestInlineURL " << safeUrl);
}

void CCISceneViewer::handleLoad(char *data, int length, const RString& url) {
  static char tmpFile[100];
  tmpnam(tmpFile);
  FILE* f = fopen(tmpFile, "w");
  fwrite(data, 1, length, f);
  fclose(f);
  if (currentNode_ && (currentURL_ == url)) {
    readInlineVRMLFile (currentNode_, tmpFile);
    currentNode_ = NULL;
  }
  else {
    readSceneFile(tmpFile);
    setTitle(url.string());
    redraw();
  }
  unlink(tmpFile);
}

RString CCISceneViewer::filenameToURL(const char* filename) {
  RString url = CCICaller::instance()->matchName(filename);
  return url.string();
}

const char* CCISceneViewer::mostRecentURL () const
{ // mpi: pulled out from QvWWWInline (to separate parser and CCI interface)
  return ((SceneCCICaller*)CCICaller::instance())->lastAsked();
}
