/* ==================================================== ======== ======= *
 *
 *  uusymbol.cc
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:02] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uusymbol.cc	ubit:03.04.0"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <usymbol.hpp>
#include <ucontext.hpp>
#include <ugraph.hpp>
#include <uctrl.hpp>
#include <uview.hpp>
#include <ucolor.hpp>
#include <ubox.hpp>
#include <update.hpp>

// symbol margin
#define SM_GETSIZE 4
#define SM 0

USymbol USymbol::left(S_LEFT, UMode::UCONST);
USymbol USymbol::right(S_RIGHT, UMode::UCONST);
USymbol USymbol::up(S_UP, UMode::UCONST);
USymbol USymbol::down(S_DOWN, UMode::UCONST);
USymbol USymbol::check(S_CHECK, UMode::UCONST);
USymbol USymbol::radio(S_RADIO, UMode::UCONST);
USymbol USymbol::square(S_SQUARE, UMode::UCONST);
USymbol USymbol::circle(S_CIRCLE, UMode::UCONST);
USymbol USymbol::slider(S_SLIDER, UMode::UCONST);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

USymbol::USymbol(const USymbol &o) : UElem() {
  ix = o.ix;
  color = o.color;
  frontShadowColor = o.frontShadowColor;
  backShadowColor = o.backShadowColor;
}

USymbol::USymbol(int index, u_modes m) : UElem(m) {
  ix = index;
  color = null;
  frontShadowColor = null;
  backShadowColor = null;
}

void USymbol::set(const USymbol &o) {
  ix = o.ix;
  color = o.color;
  frontShadowColor = o.frontShadowColor;
  backShadowColor = o.backShadowColor;
  changed(true);
}

void USymbol::update() {
  parents.updateParents(UUpdate::all);
}

void USymbol::setColor(const UColor &c) {
  color = &c;
}
void USymbol::setFrontShadowColor(const UColor &c) {
  frontShadowColor = &c;
}
void USymbol::setBackShadowColor(const UColor &c) {
  backShadowColor = &c;
}

USymbol& usymbol(const USymbol &sy) {
  return *(new USymbol(sy));
}

void USymbol::getSize(UContext *props, u_dim *w, u_dim *h) const {

  // les tailles des symbols dependent de celles des fonts !
  // on enleve SM_GETSIZE pour eviter que ca aille du haut jusqu'en bas
  *h = props->winview->wg().getTextHeight(props->fontdesc) - SM_GETSIZE;

  // on rend le truc pair car c'est necessaire pour que les
  // fleches (et autres) tombent juste)
  if (*h % 2 != 0) (*h)--;

  // format carre
  *w = *h;
		//cerr << "USymbol::getSize " << ix<< " : " << *w <<"," << *h << endl;
}

void USymbol::paint(UWinGraph &g, UContext *props, const URegion &r) const {

  // xl, yl = length for obtaining the last point (= width-1, height-1)
  // dont't forget to remove the left and right margin (SM)
  int xl = r.width  - 2*SM - 1;
  int yl = r.height - 2*SM - 1;

  bool active;
  if (props->obj->isSelected())
    active = (props->obj->getState() != UOn::ARMED);
  else 
    active = (props->obj->getState() == UOn::ARMED);

  const UColor *back, *fore, *symcolor;
  symcolor = color ? color : &UColor::darkgrey;

  if (active) {
    fore = backShadowColor ? backShadowColor : &UColor::black;
    back = frontShadowColor ? frontShadowColor : &UColor::white;
  }
  else {
    back = backShadowColor ? backShadowColor : &UColor::black;
    fore = frontShadowColor ? frontShadowColor : &UColor::white;
  }

		//cerr << "USymbol::paint " << ix<< " : " << r.width <<"," << r.height << endl;

  int px[5];
  int py[5];

  switch (ix) {
  case S_DOWN:
    px[0] = r.x+SM,      py[0] = r.y+SM;
    px[1] = r.x+SM+xl/2, py[1] = r.y+SM+yl;
    px[2] = r.x+SM+xl,   py[2] = r.y+SM;
    // dans cet ordre
    g.setColor(symcolor);
    g.fillPolygon(px, py, 3);
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[1]);
    g.drawLine(px[0], py[0], px[2], py[2]);
    g.setColor(back);
    g.drawLine(px[1], py[1], px[2], py[2]); //etait en 2e
   break;

  case S_UP:
    px[0] = r.x+SM,      py[0] = r.y+SM+yl;
    px[1] = r.x+SM+xl/2, py[1] = r.y+SM;
    px[2] = r.x+SM+xl,   py[2] = r.y+SM+yl;

    // dans cet ordre!!
    g.setColor(symcolor);
    g.fillPolygon(px, py, 3);
    g.setColor(back);
    g.drawLine(px[1], py[1], px[2], py[2]);
    g.drawLine(px[0], py[0], px[2], py[2]);
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[1]);
    break;

  case S_RIGHT:
    px[0] = r.x+SM,     py[0] = r.y+SM;
    px[1] = r.x+SM+xl,  py[1] = r.y+SM+yl/2;
    px[2] = r.x+SM,     py[2] = r.y+SM+yl;

    g.setColor(symcolor);
    g.fillPolygon(px, py, 3);
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[2], py[2]);
    g.drawLine(px[0], py[0], px[1], py[1]);
    g.setColor(back);
    g.drawLine(px[1], py[1], px[2], py[2]); //etait en 2e
    break;

  case S_LEFT:
    px[0] = r.x+SM+xl,  py[0] = r.y+SM;
    px[1] = r.x+SM,     py[1] = r.y+SM+yl/2;
    px[2] = r.x+SM+xl,  py[2] = r.y+SM+yl;
    g.setColor(symcolor);
    g.fillPolygon(px, py, 3);
    g.setColor(back);
    g.drawLine(px[1], py[1], px[2], py[2]);
    g.drawLine(px[0], py[0], px[2], py[2]);
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[1]);
    break;

  case S_RADIO:	  // diamond
    {
    px[0] = r.x+SM+xl/2,  py[0] = r.y+SM;
    px[1] = r.x+SM,       py[1] = r.y+SM+yl/2;
    px[2] = r.x+SM+xl/2,  py[2] = r.y+yl;
    px[3] = r.x+xl,       py[3] = r.y+SM+yl/2;

    if (active) {
      g.setColor(symcolor);
      g.fillPolygon(px, py, 4);
    }
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[1]);
    g.drawLine(px[0], py[0], px[3], py[3]);

    g.setColor(back);
    g.drawLine(px[1], py[1], px[2], py[2]); // etait en 1er
    g.drawLine(px[2], py[2], px[3], py[3]);
    }
   break;

  case S_CHECK:
    px[0] = r.x+SM+1,     py[0] = r.y+SM+1;
    px[1] = r.x+ r.width-(SM+1),  py[1] = r.y + r.height-(SM+1);

    if (active) {
      g.setColor(symcolor);
      g.fillRect(px[0], py[0], px[1] - px[0], py[1] - py[0]);
    }
    // backShadow = bottom+right
    g.setColor(back);
    g.drawLine(px[0], py[1], px[1], py[1]); // bottom
    g.drawLine(px[1], py[0], px[1], py[1]); // right

    // frontShadow = top+left
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[0]); // top
    g.drawLine(px[0], py[0], px[0], py[1]); // left
    break;

  case S_SLIDER:
    px[0] = r.x+SM,    py[0] = r.y+SM;
    px[1] = r.x+xl,  py[1] = r.y+yl;

    if (active) {
      g.setColor(symcolor);
      g.fillRect(px[0], py[0], px[1] - px[0], py[1] - py[0]);
    }
    // backShadow = bottom+right
    g.setColor(back);
    g.drawLine(px[0], py[1], px[1], py[1]); // bottom
    g.drawLine(px[1], py[0], px[1], py[1]); // right

    // frontShadow = top+left
    g.setColor(fore);
    g.drawLine(px[0], py[0], px[1], py[0]); // top
    g.drawLine(px[0], py[0], px[0], py[1]); // left
    break;

  case S_SQUARE:
    g.setColor(fore);
    g.drawRect(r.x+SM+1, r.y+SM+1, xl-1, yl-1);
    g.setColor(back);
    g.drawRect(r.x+SM, r.y+SM, xl-1, yl-1);
   break;

  case S_CIRCLE:
    g.setColor(symcolor);
    g.fillArc(r.x+SM+1, r.y+SM+1, xl-1, yl-1, 0, 360);

    g.setColor(back);
    g.drawArc(r.x+SM+1, r.y+SM+1, xl-1, yl-1, 0, 360);

    g.setColor(fore);
    g.drawArc(r.x+SM, r.y+SM, xl-1, yl-1, 0, 360);

    break;
  }
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
