/* ==================================================== ======== ======= *
 *
 *  uelem.hh
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uelem_hh
#define	_uelem_hh
#include <ubit/ubrick.hpp>
#include <ubit/ucall.hpp>
//pragma ident	"@(#)uelem.hh	ubit:03.04.00"


/** Base class for Viewable Objects.
 * Notes: 
 * - the (inherited) onChange() method adds a callback that is activated
 *   when the object's value changes.
 * - the 'UOn::elemChange' callbacks of the object's parents are also 
 *   activated (but after the callbacks of this object)
 * - in addition, the 'UOn::strChange' callbacks of the object's parents
 *   are also activated if this UElem is an UStr (see class: UStr)
 */
class UElem: public UBrick {
public:
  UElem(u_modes b_modes = 0): UBrick(b_modes) {};

  virtual class UElem* elemCast()  {return this;}
  ///< dynamic cast

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // callbacks

  virtual void onChange(UCall&);
  ///< adds callbacks that are activated when the objects' value changes.

  virtual void changed(bool update_now);
  /**< called when object's content is changed.
   * This function:
   * - updates grahics (if arg is true)
   * - then fires object's UOn::change callbacks
   * - then fires parents' UOn::elemChange callbacks 
   */

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  virtual void update() = 0;
  ///< updates graphics.

#ifndef NO_DOC
  friend class UArgs;
  friend class UBox;
  virtual void getSize(UContext*, u_dim *w, u_dim *h) const = 0;
  virtual void paint(UWinGraph&, UContext*, const URegion &r) const = 0;
#endif
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
