namespace eval top {
    variable top

    # Define the top array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set top {
	list.reset ""
	list.clear ""
	entry.viewer ""
	entry.delay ""
	dialog ""
	viewer "xterm"
	refresh ""
	cumulative ""
	secure ""
	ignore ""
	command_line ""
    }
}

# top::create --
#
#   Method to create the dialog box for the top command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::create { } {
    global tkWorld
    variable top

    # Put the focus on the top dialog if it is already open.
    if [winfo exists $top(dialog)] {
	switch -- [wm state $top(dialog)] {
	    normal {
		raise $top(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $top(dialog)
	    }
	}
	focus $top(dialog)
	return
    } else {
	set top(dialog) [dialog::create .top Top]
    }

    # Now define the viewers a user can use for the top page.
    if [info exists top(viewer_list)] {
	# Do Nothing
    } else {
	foreach v [system::which "xterm nxterm rxvt"] {
	    lappend top(viewer_list) [file tail $v]
	}
    }

    # There is only 1 tab.
    set tab1 [tabnotebook::page [dialog::interior \
	    $top(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]
    label $f1.label_viewer \
	    -text "Viewer" \
	    -width 10 \
	    -anchor e
    set top(entry.viewer) [ddlistbox::create $f1 top::top(viewer) \
	    $top(viewer_list)]
    label $f1.label_delay \
	    -text "Delay" \
	    -width 10 \
	    -anchor e
    set top(entry.delay) [entry $f1.entry_delay \
	    -width 5 \
	    -textvariable top::top(delay)]
    grid $f1.label_viewer $top(entry.viewer) \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f1.label_delay $top(entry.delay) \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    set f2 [frame $tab1.f2 \
	    -class TabnotebookFrame]
    checkbutton $f2.refresh \
	    -text "Instant Refresh" \
	    -variable top::top(refresh) \
	    -onvalue "q" \
	    -offvalue ""
    checkbutton $f2.cumulative \
	    -text "Cumulative Display" \
	    -variable top::top(cumulative) \
	    -onvalue "S" \
	    -offvalue ""
    checkbutton $f2.secure \
	    -text "Secure Mode" \
	    -variable top::top(secure) \
	    -onvalue "s" \
	    -offvalue ""
    checkbutton $f2.ignore \
	    -text "Ignore Mode" \
	    -variable top::top(ignore) \
	    -onvalue "i" \
	    -offvalue ""
    checkbutton $f2.command_line \
	    -text "Command Line Display" \
	    -variable top::top(command_line) \
	    -onvalue "c" \
	    -offvalue ""
    grid $f2.refresh $f2.cumulative \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.secure $f2.ignore \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.command_line \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    # Build the only tab.
    pack $f1 $f2 \
	    -side top \
	    -fill x \
	    -padx 5 \
	    -pady 5 \
	    -ipadx 5 \
	    -ipady 5

    # Duhhhhhh......
    focus $top(entry.delay)

    # Define the lists for the reset and clear methods
    set top(list.reset) "refresh cumulative secure ignore command_line"
    set top(list.clear) "viewer delay"
}

# top::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::ok { } {
    global tkWorld
    variable top

    # Insert the Tcl command list in the Command Center with the
    # proper formatting of a space between each argument on the
    # command line.  If there are no options given by the user,
    # then don't display it in the CC.
    
    $tkWorld(cmd_center) insert insert "$top(viewer) -e top "

    # Build the command line argument.
    set cmd_arg ""
    foreach x $top(list.reset) {
	if [string length $top($x)] {
	    append cmd_arg $top($x)
	}
    }
    if [string length $cmd_arg] {
	$tkWorld(cmd_center) insert insert "-$cmd_arg "
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}

# top::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::reset { } {
    variable top

    # Reset all of the list elements.
    foreach x $top(list.reset) {
	set top($x) ""
    }
}

# top::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::clear { } {
    variable top

    # Reset the data structure elements and bg/fg.
    foreach x $top(list.clear) {
	set top($x) ""
	if {$x == "viewer"} {
	    set top($x) "xterm"
	} else {
	    $top(entry.$x) configure -bg #ffffff -fg #000000
	}
    }

    focus $top(entry.delay)
}

# top::help --
#
#   Method to invoke the Top Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::help { } {
    global tkWorld

    help::create "help/top.html" "Top Command Help"
}

# top::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc top::close { } {
    variable top
    
    balloonhelp::cancel
    destroy $top(dialog)
}
