/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LESSONSTATUSSIZER_H
#define LESSONSTATUSSIZER_H

#include "LEntry.H"
#include <wx/wx.h>

/* Klasse fr die Lektionsstatusanzeige
 */
class LessonStatusSizer : public wxFlexGridSizer {
 public:
  LessonStatusSizer(wxWindow* parent);
  void setStatus(LEntry& status);
  
 private:
  //do not delete any of those pointers in a destructor!
  wxStaticText* touchesText; //total touches
  wxTextCtrl* touchesField;
  wxStaticText* tpmText; //touches per minute
  wxTextCtrl* tpmField;
  wxStaticText* correctText; //total correct touches
  wxTextCtrl* correctField;
  wxStaticText* wrongText; //total wrong touches
  wxTextCtrl* wrongField;
  wxStaticText* rateText; //relative to thousands wrong touches
  wxTextCtrl* rateField;
  wxStaticText* timeText; //time
  wxTextCtrl* timeField;
};

#endif
