#!/usr/bin/ruby

require 'cgi'
require 'cgi/session'
require 'controller'

# request parameter
cgi = CGI.new
params = cgi.params
event = params['event'].first
params.delete('event')

# resume a controller or create new one.
session = CGI::Session::new(cgi)
controller = 
      if session['controller'] then
        Marshal.load( session['controller'] )
      else
        Controller.new(File.basename(__FILE__))
      end

# handle event
controller.handle_event(event, params)

# response
print cgi.header( controller.content_type )
print controller.content_body

# suspend the controller
session['controller'] = Marshal.dump(controller)
