/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/output/tar/posix.cc
 */

#ifndef COMMON_TAR_OUTPUT_TAR_POSIX_H
#define COMMON_TAR_OUTPUT_TAR_POSIX_H

#include <tar/output/tar_base.h>

class tar_output_tar_posix: public tar_output_tar_base
{
	 public:
	 virtual ~tar_output_tar_posix();
	 tar_output_tar_posix(file_output *);
	 virtual void write_header(const tar_header &);

	 private:
	 tar_output_tar_posix();
	 tar_output_tar_posix(const tar_output_tar_posix &);
	 tar_output_tar_posix &operator = (const tar_output_tar_posix &);
};

#endif /* COMMON_TAR_OUTPUT_TAR_POSIX_H */
