/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JFrame.java,v $
   Revision 1.24  2004/06/11 03:29:28  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.23  2004/05/26 04:46:07  dannaab
   Changed how Window/Dialog/Frame are initialized.
   Now, the SWT peer's instantiation is delayed until setVisible(true).  This
   has the benefit of allowing Swing's setter methods that can only be set via
   the SWT Shell peer's construction (ie, setResizable(), setModel())

   Revision 1.22  2004/03/22 15:10:22  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.21  2004/03/18 15:13:22  bobintetley
   Temporary fix to getRootPane()

   Revision 1.20  2004/03/18 14:42:11  bobintetley
   Fix to Window hierarchy to match Swing, and fix to allow MDI apps
      to work under SWT 2.x

   Revision 1.19  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.18  2004/01/16 09:35:47  bobintetley
   Full event dispatch thread support!

   Revision 1.17  2004/01/02 11:24:03  bobintetley
   Frame extended states now work correctly

   Revision 1.16  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.15  2003/12/15 17:39:12  bobintetley
   Missing implementations completed

   Revision 1.14  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.13  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwt.awt.*;

public class JFrame extends swingwt.awt.Frame implements WindowConstants, RootPaneContainer {

    public final static int NORMAL = 0;
    public final static int ICONIFIED = 1;
    public final static int MAXIMIZED_HORIZ = 2;
    public final static int MAXIMIZED_VERT = 3;
    public final static int MAXIMIZED_BOTH = 4;
    
    protected int closeOperation = WindowConstants.DISPOSE_ON_CLOSE;
    
    protected boolean isMax = false;
    protected int state = NORMAL;
    
    public JFrame() { super();}
    public JFrame(String title) {super(title); }
    public JFrame(GraphicsConfiguration gc) { super(gc); }
    
    public void setCachedProperties() {
        super.setCachedProperties();
        setExtendedState(state);
    }
    
    private int intRetval;
    public int getExtendedState() {
        if (SwingWTUtils.isSWTControlAvailable(peer)) {
	        SwingUtilities.invokeSync(new Runnable() {
	            public void run() {
		            if (peer.getMaximized())
		                intRetval = MAXIMIZED_BOTH;
		            else if (peer.getMinimized())
		                intRetval = ICONIFIED;
		            else
		                intRetval = NORMAL;
	            }
	        });
        }
        else intRetval = state;
        return intRetval;
    }
    
    public void setExtendedState(final int state) {
        this.state = state;
        if (SwingWTUtils.isSWTControlAvailable(peer)) {
	        SwingUtilities.invokeSync(new Runnable() {
	           public void run() {
	                if ( ((state & MAXIMIZED_BOTH) > 0) ||
	                    ((state & MAXIMIZED_HORIZ) > 0) ||
	                    ((state & MAXIMIZED_VERT) > 0) ) {
	                    peer.setMaximized(true);
	                    isMax = true;
	                }
	                else {
	                    peer.setMaximized(false);
	                    isMax = false;
	                }
	
	                if ((state & ICONIFIED) > 0) {
	                    peer.setMinimized(true);
	                    isIcon = true;
	                }
	                else {
	                    peer.setMinimized(false);
	                    isIcon = false;
	                }
	           }
	        });
        }
    }
    
    /** Handy for layout problems. Toggles the window between
     *  max/norm according to what is set and guarantees 
     *  relayout of components
     */
    public void toggleWindowState() {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
               if (isMax) {
                   peer.setMaximized(false);
                   peer.setMaximized(true);
               }
               else
               {
                   peer.setMaximized(true);
                   peer.setMaximized(false);
               }
            }
        });
    }
    
    public int getDefaultCloseOperation() { 
        return closeOperation;
    }
    
    public void setDefaultCloseOperation(int operation) {
        closeOperation = operation;
    }
    
    public Container getContentPane() {
        return rootPane.getContentPane();
    }
    
    public Component getGlassPane() {
        return rootPane.getGlassPane();
    }
    
    public JLayeredPane getLayeredPane() {
        return rootPane.getLayeredPane();
    }
    
    public JRootPane getRootPane() {
        return rootPane;
    }
    
    public void setContentPane(Container contentPane) {
        rootPane.setContentPane(contentPane);
    }
    
    public void setGlassPane(Component glassPane) {
        rootPane.setGlassPane(glassPane);
    }
    
    public void setLayeredPane(JLayeredPane layeredPane) {
        rootPane.setLayeredPane(layeredPane);
    }
    
    public void registerWindowEvents() {
        
        // Overriden here so we can manage default close operations.
        
        peer.addShellListener(new org.eclipse.swt.events.ShellListener() {
            public void shellActivated(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_ACTIVATED);
            }
            public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
                isClosed = true;
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_CLOSING);
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_CLOSED);
                // See what's set for the default close operation and handle it
                switch (closeOperation) {
                    case WindowConstants.DISPOSE_ON_CLOSE: e.doit = true; SwingWTUtils.decrementWindowReferences(); break;
                    case WindowConstants.DO_NOTHING_ON_CLOSE: e.doit = false; break;
                    case WindowConstants.EXIT_ON_CLOSE: e.doit = true; SwingWTUtils.decrementWindowReferences(); System.exit(0); break;
                    case WindowConstants.HIDE_ON_CLOSE: e.doit = false; peer.setVisible(false); break;
                }
            }
            public void shellDeactivated(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_DEACTIVATED);
            }
            public void shellDeiconified(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_DEICONIFIED);
            }
            public void shellIconified(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_ICONIFIED);
            }
        });
    }
    
}
