/* memops.c, copyright Neven Lovric <nlovric@linux.hr> */

#include <stdlib.h>
#include <unistd.h>
#include "memops.h"

void *smalloc(size_t size)
{
   void *mem;
   
   while (!(mem = malloc(size)))
      usleep(1);
   return(mem);
}

void *srealloc(void *ptr, size_t size)
{
   void *mem;
   
   if (!size) {
      free(ptr);
      return(NULL);
   }
   while (!(mem = realloc(ptr, size)))
      usleep(1);
   return(mem);
}
