/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdlib.h>
#include <SDL/SDL_net.h>
#include "url.h"
#include "http.h"
#include "html.h"
#include "load.h"

static Fl_Preferences *CurComicCache = NULL;	// Holds cache info for html
Fl_Preferences *CurComicCacheGroup = NULL;	// Holds cache info for html

void SwitchComic(Fl_Widget *w, void *New) {
	sURL *Break;
	char *URL;

	free(CurComic);
	CurComic = NULL;

	clonestr((char *)New, &CurComic);

	Out("Switching Comic: %s\n", CurComic);	

	Interface.FirstButton->deactivate();
	Interface.FirstButton->tooltip(NULL);
	Interface.PrevButton->deactivate();
	Interface.PrevButton->tooltip(NULL);
	Interface.RefreshButton->deactivate();
	Interface.RefreshButton->tooltip(NULL);
	Interface.NextButton->deactivate();
	Interface.NextButton->tooltip(NULL);

	delete CurComicG;
	CurComicG = NULL;

	delete CurComicCacheGroup;
	CurComicCacheGroup = NULL;

	delete CurComicCache;
	CurComicCache = NULL;

	free(CurLinks.FirstLink);
	CurLinks.FirstLink = NULL;

	free(CurLinks.CurLink);
	CurLinks.CurLink = NULL;

	free(CurLinks.LatestLink); 
	CurLinks.LatestLink = NULL;

	if (!strlen(CurComic)) {		// Only happens with Update Comics
		return;
	}

	CurComicG = new Fl_Preferences(Prefs, CurComic);
	
	CurComicG->get("baseurl", URL, "");

	if (CurComicG->entryExists("firsturl")) {
		CurComicG->get("firsturl", CurLinks.FirstLink, "");
		if (strcmp(CurLinks.FirstLink, "http://")) {		// Something besides the default
			Interface.FirstButton->activate();
			Interface.FirstButton->tooltip(CurLinks.FirstLink);
		} else {
			free(CurLinks.FirstLink);
			CurLinks.FirstLink = NULL;
		}
	}
	CurComicG->get("baseurl", CurLinks.CurLink, "");
	Interface.RefreshButton->activate();
	Interface.RefreshButton->tooltip(CurLinks.CurLink);
	CurComicG->get("baseurl", CurLinks.LatestLink, "");
	Interface.LatestButton->activate();
	Interface.LatestButton->tooltip(CurLinks.LatestLink);

	CurComicCache = new Fl_Preferences(Fl_Preferences::USER, "racercksproductions", CurComic);

	if (!strlen(URL)) {
		MOut("Invalid Comic, corrupt config?\n");
		free(URL);
		return;
	}

	Break = URLCreate(URL);

	if (Debug) {
		DbgOut("Broken URL:\n");
		DbgOut("Full: %s\n", Break->Full);
		DbgOut("Protocol: %s\n", Break->Protocol);
		DbgOut("Host: %s\n", Break->Host);
		DbgOut("Port: %s\n", Break->Port);
		DbgOut("FullPath: %s\n", Break->FullPath);
		DbgOut("Path: %s\n", Break->Path);
		DbgOut("File: %s\n", Break->File);
		DbgOut("Extension: %s\n", Break->Extension);
	}

	if(strcmp(Break->Protocol, "http")) {
		MOut("Unknown protocol: %s\n", Break->Protocol);
		free(URL);
		URLDelete(Break);
		return;
	}

	if (Offline == OFFTYPE_MISSING) {
		Offline = OFFTYPE_CHECK;
		SwitchDate(URL);
		Offline = OFFTYPE_MISSING;
	} else {
		SwitchDate(URL);
	}

	free(URL);
	URLDelete(Break);
}

void SwitchDate(char *NewURL) {
	static Fl_Image **Images = NULL;
	static Fl_Box **Boxes = NULL;
	sURL *Break;
	int i;

	if (!NewURL || !strlen(NewURL)) {
		MOut("Null or empty pointer passed to SwitchDate(), report this as a bug!\n");
		return;
	}

	Out("Switching Date: %s\n", NewURL);	

	Break = URLCreate(NewURL);

	if (Debug) {
		DbgOut("Broken URL:\n");
		DbgOut("Full: %s\n", Break->Full);
		DbgOut("Protocol: %s\n", Break->Protocol);
		DbgOut("Host: %s\n", Break->Host);
		DbgOut("Port: %s\n", Break->Port);
		DbgOut("FullPath: %s\n", Break->FullPath);
		DbgOut("Path: %s\n", Break->Path);
		DbgOut("File: %s\n", Break->File);
		DbgOut("Extension: %s\n", Break->Extension);
	}

	if(strcmp(Break->Protocol, "http")) {
		MOut("Unknown protocol: %s\n", Break->Protocol);
		URLDelete(Break);
		return;
	}

	{
		char *FullName;
		CurComicG->get("name", FullName, "");
		snprintf(WindowTitle, 199, "%s - %s", SCVERSION, FullName);
		DbgOut("Setting Window Label: %s\n", WindowTitle);
		Interface.MainWindow->label(WindowTitle);
		free(FullName);
	}

	if(CurLinks.CurLink != NewURL) {	// We didn't hit refresh
		if(CurLinks.CurLink) {
			free(CurLinks.CurLink);
			CurLinks.CurLink = NULL;
		}

		clonestr(NewURL, &(CurLinks.CurLink));
		Interface.OutputURL->value(CurLinks.CurLink);
		Interface.RefreshButton->activate();
		Interface.RefreshButton->tooltip(CurLinks.CurLink);
	} else {		// We DID hit refresh, so force delete the html cache (will also check all images as a result of FindImages()
		CurComicCache->deleteGroup(URLFileToFile(Break->File));
	}

	if (!CurComicCache->groupExists(URLFileToFile(Break->File)) || (Offline == OFFTYPE_CHECK)) {
		CurComicCacheGroup = new Fl_Preferences(CurComicCache, URLFileToFile(Break->File));
		LoadURL(NewURL);
	} else {
		CurComicCacheGroup = new Fl_Preferences(CurComicCache, URLFileToFile(Break->File));
		{
			char *Next;
			sURL *NextURL;
			CurComicCacheGroup->get("nextlink", Next, "");
			if (strlen(Next)) {
				NextURL = URLCreate(Next);
				DbgOut("NextURL->FullPath: %s (%d)\n", NextURL->FullPath, strlen(NextURL->FullPath));
				if (!strcmp(Next, CurLinks.LatestLink) || (strlen(NextURL->FullPath) < 2) ||
					(!CurComicCacheGroup->entryExists("nextlink"))) {	
					// We're looking at a page that has the "next" link pointing to "today", or is pointing to the front page, or has no "next" link at all, so make sure it's not been updated
					LoadURL(NewURL);
				}
				URLDelete(NextURL);
			}
			free(Next);
		}
	}

	if (Boxes) {
		DbgOut("Clearing old Boxes\n");
		for (i = 0; Boxes[i]; i++) {
			Boxes[i]->parent()->remove(*(Boxes[i]));
			Boxes[i]->image(NULL);
			delete Boxes[i];
		}
		delete Boxes;
		Boxes = NULL;
		DbgOut("Cleared old Boxes\n");
	}

	Images = LoadImages();
	Interface.BarLabel("Arranging Images...");
	Boxes = MakeImages(Images, Interface.ScrollBox, Interface.ScrollBox->parent()->w() / 2, Interface.ScrollBox->y() + 2);

	Interface.BarLabel("Loading Links...");
	LoadLinks();

	delete CurComicCacheGroup;
	CurComicCacheGroup = NULL;
	CurComicCache->flush();
	Prefs->flush();
	DbgOut("Done switching\n");
	Interface.BarLabel("");
	URLDelete(Break);
}
