<?php
/**
 * $Horde: passwd/lib/Driver/servuftp.php,v 1.2.2.4 2005/02/01 21:45:31 ericr Exp $
 *
 * The serv-u ftp class attempts to change a user's password via
 * the SITE PSWD command used by Serv-u ftpd for windows.
 *
 * @author   Lucas Nelan (screen@brainkrash.com)
 * @package  passwd
 *
 * $Horde: passwd/lib/Driver/servuftp.php,v 1.2.2.4 2005/02/01 21:45:31 ericr Exp $
 */

class Passwd_Driver_servuftp extends Passwd_Driver {

    var $fp;
    var $err_str;

    var $params;

    var $ftpd_connected   = '220';
    var $ftpd_goodbye     = '221';
    var $ftpd_passwordok  = '230';
    var $ftpd_usernameok  = '331';
    var $ftpd_passwordbad = '530';

    /**
     * Constructs a new servuftp Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_servuftp($params = array()) {
        $this->params = $params;
    }

    function connect( $server, $port, $timeout = 30) {
        $this->fp = fsockopen($server, $port, $err_no, $err_str, $timeout);

        if (!$this->fp) {
            $this->err_str = $err_str;
            return false;
        } else {
            return $this->get_prompt();
        }
    }

    function disconnect() {
        if (isset($this->fp)) {
            fputs($this->fp, "quit\n");
            fclose($this->fp);
        }
    }

    function get_prompt() {
        $prompt = fgets($this->fp, 4096);
        $return = '';

        if (ereg("(^[1-5][0-9][0-9])",$prompt,$res)) {
            $return = $res[1];
        }

        return $return;
    }

    function send_command($cmd, $arg) {
        $line = $cmd . " " . $arg . "\r\n";
        fputs($this->fp, $line);
        return $this->get_prompt();
    }

    function change_password($user_name, $old_password, $new_password) {
        $server = @$this->params['host'];
        $port = @$this->params['port'];
        $timeout = @$this->params['timeout'];

        if ( $server == "" || $port == "" ) {
           $this->err_str = _("Password module is not properly configured");
           return false;
        }

        $return_value = false;
        if ($this->connect($server, $port, $timeout) == $this->ftpd_connected) {
            if ($this->send_command("user", $user_name) == $this->ftpd_usernameok) {
                if ($this->send_command("pass", $old_password) == $this->ftpd_passwordok) {
                    if ($this->send_command("site pswd", '"'.$old_password.'" "'.$new_password.'"') == $this->ftpd_passwordok) {
                        $return_value = true;
                    }
                }
            }
            $this->disconnect();
        }
        if ($return_value === true) {
            $this->reset_credentials($user_name, $old_password, $new_password);
        }

        return $return_value;
    }

    function check_password($user_name, $user_password) {
        $server = @$this->params['host'];
        $port = @$this->params['port'];
        $timeout = @$this->params['timeout'];

        if ( $server == "" || $port == "" ) {
           $this->err_str = _("Password module is not properly configured");
           return false;
        }

        $return_value = false;

        if ($this->connect($server, $port, $timeout) == $this->ftpd_connected) {
          if ($this->send_command("user", $user_name) == $this->ftpd_usernameok) {
            if ($this->send_command("pass", $user_password) == $this->ftpd_passwordok) {
              $return_value = true;
            }
          }

          $this->disconnect();
        }
        else
          $return_value = -1;  // cannot connect

        return $return_value;
    }
}
